/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Result;
import com.beyondcron.core.Role;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoRole;
import com.google.protobuf.InvalidProtocolBufferException;

public class RoleCommand
extends AbstractCommandMessage<RoleCommand> {
    private static final String MESSAGE_TAG = "command";
    private Action action;
    private String name;
    private Role role = null;

    public RoleCommand() {
    }

    public RoleCommand(String name, Action action) {
        this.name = name;
        this.action = action;
    }

    public RoleCommand(Role role, Action action) {
        this.name = role.getName();
        this.action = action;
        this.role = role;
    }

    public Action getAction() {
        return this.action;
    }

    public String getName() {
        return this.name;
    }

    public Role getRole() {
        return this.role;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoRole.Command.Builder toProto() {
        ProtoRole.Command.Builder builder = ProtoRole.Command.newBuilder();
        builder.setClientId(this.clientId);
        builder.setChangeId(this.changeGroup);
        builder.setAction(this.action.toProto());
        builder.setName(this.name);
        if (this.role != null) {
            builder.setRole(this.role.toProto());
        }
        return builder;
    }

    @Override
    public RoleCommand fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoRole.Command proto = ProtoRole.Command.parseFrom(data);
        this.clientId = proto.getClientId();
        this.changeGroup = proto.getChangeId();
        this.action = Action.fromProto(proto.getAction());
        this.name = proto.getName();
        this.role = proto.hasRole() ? new Role().fromProto(proto.getRole().toByteArray()) : null;
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private String name;
        private Action action;

        public Response() {
        }

        public Response(RoleCommand command) {
            this.name = command.name;
            this.action = command.action;
        }

        public String getName() {
            return this.name;
        }

        public Action getAction() {
            return this.action;
        }

        public Response setAction(Action action) {
            this.action = action;
            return this;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoRole.CommandResponse.Builder toProto() {
            ProtoRole.CommandResponse.Builder builder = ProtoRole.CommandResponse.newBuilder();
            builder.setAction(this.action.toProto());
            builder.setName(this.name);
            builder.setResult(this.result.toProto());
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoRole.CommandResponse proto = ProtoRole.CommandResponse.parseFrom(data);
            this.action = Action.fromProto(proto.getAction());
            this.name = proto.getName();
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            return this;
        }
    }

    public static enum Action {
        CREATE,
        UPDATE,
        DELETE;

        static EnumMap<Action, ProtoRole.Command.Action> actionMap;

        public static Action fromProto(ProtoRole.Command.Action action) {
            return actionMap.getA(action);
        }

        public ProtoRole.Command.Action toProto() {
            return actionMap.getB(this);
        }

        static {
            actionMap = new EnumMap<Action, ProtoRole.Command.Action>(Action.class, ProtoRole.Command.Action.class);
        }
    }
}

