/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Result;
import com.beyondcron.core.Service;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoService;
import com.google.protobuf.InvalidProtocolBufferException;

public class ServiceCommand
extends AbstractCommandMessage<ServiceCommand> {
    private static final String MESSAGE_TAG = "command";
    private Service.Type type;
    private Action action;

    public ServiceCommand() {
    }

    public ServiceCommand(Service.Type type, Action acion) {
        this.type = type;
        this.action = acion;
    }

    public Service.Type getType() {
        return this.type;
    }

    public Action getAction() {
        return this.action;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoService.Command.Builder toProto() {
        ProtoService.Command.Builder builder = ProtoService.Command.newBuilder();
        builder.setClientId(this.clientId);
        builder.setType(this.type.toString());
        builder.setAction(this.action.toProto());
        return builder;
    }

    @Override
    public ServiceCommand fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoService.Command proto = ProtoService.Command.parseFrom(data);
        this.clientId = proto.getClientId();
        this.type = Service.Type.valueOf(proto.getType());
        this.action = Action.fromProto(proto.getAction());
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();

        public Response() {
        }

        public Response(ServiceCommand command) {
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoService.CommandResponse.Builder toProto() {
            ProtoService.CommandResponse.Builder builder = ProtoService.CommandResponse.newBuilder();
            builder.setResult(this.result.toProto());
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoService.CommandResponse proto = ProtoService.CommandResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            return this;
        }
    }

    public static enum Action {
        RELOAD("Reload"),
        REFRESH("Refresh");

        private String label;
        static EnumMap<Action, ProtoService.Command.Action> serviceMap;

        private Action(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static Action fromProto(ProtoService.Command.Action service) {
            return serviceMap.getA(service);
        }

        public ProtoService.Command.Action toProto() {
            return serviceMap.getB(this);
        }

        static {
            serviceMap = new EnumMap<Action, ProtoService.Command.Action>(Action.class, ProtoService.Command.Action.class);
        }
    }
}

