/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Result;
import com.beyondcron.core.Service;
import com.beyondcron.core.StringUtils;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoService;
import com.google.protobuf.InvalidProtocolBufferException;

public class ServiceQuery
extends AbstractCommandMessage<ServiceQuery> {
    private static final String MESSAGE_TAG = "query";
    private Service.Type type;

    public ServiceQuery() {
    }

    public ServiceQuery(Service.Type type) {
        this.type = type;
    }

    public Service.Type getType() {
        return this.type;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoService.Query.Builder toProto() {
        ProtoService.Query.Builder builder = ProtoService.Query.newBuilder();
        builder.setClientId(this.clientId);
        builder.setType(this.type.toString());
        return builder;
    }

    @Override
    public ServiceQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoService.Query proto = ProtoService.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.type = Service.Type.valueOf(proto.getType());
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private Service.Type type;
        private String name;
        private String description;
        private String message;
        private long connected = 0L;

        public Response() {
        }

        public Response(ServiceQuery query) {
            this.type = query.getType();
        }

        public Service.Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Response setName(String name) {
            this.name = name;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Response setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getMessage() {
            return this.message;
        }

        public Response setMessage(String message) {
            this.message = message;
            return this;
        }

        public boolean isConnected() {
            return this.connected > 0L;
        }

        public long getConnected() {
            return this.connected;
        }

        public Response setConnected(long connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoService.QueryResponse.Builder toProto() {
            ProtoService.QueryResponse.Builder builder = ProtoService.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            builder.setType(this.type.toString());
            if (!StringUtils.isNullOrEmpty(this.name)) {
                builder.setName(this.name);
            }
            if (!StringUtils.isNullOrEmpty(this.description)) {
                builder.setDescription(this.description);
            }
            if (!StringUtils.isNullOrEmpty(this.message)) {
                builder.setMessage(this.message);
            }
            builder.setConnected(this.connected);
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoService.QueryResponse proto = ProtoService.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.type = Service.Type.valueOf(proto.getType());
            this.name = proto.hasName() ? proto.getName() : "";
            this.description = proto.hasDescription() ? proto.getDescription() : "";
            this.message = proto.hasMessage() ? proto.getMessage() : "";
            this.connected = proto.getConnected();
            return this;
        }
    }
}

