/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoTopic;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hazelcast.core.ITopic;
import com.hazelcast.monitor.LocalTopicStats;

public class Topic
implements Message<Topic> {
    private static final String MESSAGE_TAG = "topic";
    private String name = "";
    private long received = 0L;
    private long pending = 0L;

    public Topic() {
    }

    public Topic(ITopic topic) {
        LocalTopicStats stats = topic.getLocalTopicStats();
        this.name = topic.getName();
        this.received = stats.getPublishOperationCount();
        this.pending = this.received - stats.getReceiveOperationCount();
    }

    public String getName() {
        return this.name;
    }

    public long getReceived() {
        return this.received;
    }

    public long getPending() {
        return this.pending;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoTopic.Topic.Builder toProto() {
        return this.toProto(false);
    }

    public ProtoTopic.Topic.Builder toProto(boolean summary) {
        ProtoTopic.Topic.Builder builder = ProtoTopic.Topic.newBuilder();
        builder.setName(this.name);
        if (this.pending > 0L) {
            builder.setPending(this.pending);
        }
        if (!summary && this.received > 0L) {
            builder.setReceived(this.received);
        }
        return builder;
    }

    @Override
    public Topic fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoTopic.Topic proto = ProtoTopic.Topic.parseFrom(data);
        this.name = proto.getName();
        this.received = proto.getReceived();
        this.pending = proto.getPending();
        return this;
    }
}

