/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Filter;
import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultList;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.message.Topic;
import com.beyondcron.messaging.proto.ProtoTopic;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;

public class TopicQuery
extends AbstractCommandMessage<TopicQuery> {
    private static final String MESSAGE_TAG = "query";
    private Filter filter = new Filter();

    public Filter getFilter() {
        return this.filter;
    }

    public TopicQuery setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoTopic.Query.Builder toProto() {
        ProtoTopic.Query.Builder builder = ProtoTopic.Query.newBuilder();
        builder.setClientId(this.clientId);
        if (this.filter.getType() != Filter.Type.ANY) {
            builder.setFilter(this.filter.toProto());
        }
        return builder;
    }

    @Override
    public TopicQuery fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoTopic.Query proto = ProtoTopic.Query.parseFrom(data);
        this.clientId = proto.getClientId();
        this.filter = new Filter();
        if (proto.hasFilter()) {
            this.filter.fromProto(proto.getFilter().toByteArray());
        }
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage,
    ResultList {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private List<Topic> topics = new ArrayList<Topic>();

        public Response addTopic(Topic topic) {
            this.topics.add(topic);
            return this;
        }

        public List<Topic> getTopics() {
            return this.topics;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.topics.isEmpty();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoTopic.QueryResponse.Builder toProto() {
            ProtoTopic.QueryResponse.Builder builder = ProtoTopic.QueryResponse.newBuilder();
            builder.setResult(this.result.toProto());
            for (Topic topic : this.topics) {
                builder.addTopics(topic.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoTopic.QueryResponse proto = ProtoTopic.QueryResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            for (ProtoTopic.Topic topic : proto.getTopicsList()) {
                this.topics.add(new Topic().fromProto(topic.toByteArray()));
            }
            return this;
        }
    }
}

