/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Result;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoUser;
import com.google.protobuf.InvalidProtocolBufferException;

public class UserCommand
extends AbstractCommandMessage<UserCommand> {
    private static final String MESSAGE_TAG = "command";
    private String name;
    private Action action;
    private User user = null;
    private boolean updatePassword = false;

    public UserCommand() {
    }

    public UserCommand(String name, Action action) {
        this.name = name;
        this.action = action;
    }

    public UserCommand(User user, Action action) {
        this(user, action, false);
    }

    public UserCommand(User user, Action action, boolean updatePassword) {
        this.name = user.getName();
        this.action = action;
        this.user = user;
        this.updatePassword = updatePassword;
    }

    public Action getAction() {
        return this.action;
    }

    public String getName() {
        return this.name;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isUpdatePassword() {
        return this.updatePassword;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoUser.Command.Builder toProto() {
        ProtoUser.Command.Builder builder = ProtoUser.Command.newBuilder();
        builder.setClientId(this.clientId);
        builder.setChangeId(this.changeGroup);
        builder.setAction(this.action.toProto());
        builder.setName(this.name);
        if (this.user != null) {
            builder.setUser(this.user.toProto());
        }
        if (this.updatePassword) {
            builder.setUpdatePassword(true);
        }
        return builder;
    }

    @Override
    public UserCommand fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoUser.Command proto = ProtoUser.Command.parseFrom(data);
        this.clientId = proto.getClientId();
        this.changeGroup = proto.getChangeId();
        this.action = Action.fromProto(proto.getAction());
        this.name = proto.getName();
        this.user = proto.hasUser() ? new User().fromProto(proto.getUser().toByteArray()) : null;
        this.updatePassword = proto.getUpdatePassword();
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private String name;
        private Action action;

        public Response() {
        }

        public Response(UserCommand command) {
            this.name = command.name;
            this.action = command.action;
        }

        public String getName() {
            return this.name;
        }

        public Action getAction() {
            return this.action;
        }

        public Response setAction(Action action) {
            this.action = action;
            return this;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoUser.CommandResponse.Builder toProto() {
            ProtoUser.CommandResponse.Builder builder = ProtoUser.CommandResponse.newBuilder();
            builder.setAction(this.action.toProto());
            builder.setName(this.name);
            builder.setResult(this.result.toProto());
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoUser.CommandResponse proto = ProtoUser.CommandResponse.parseFrom(data);
            this.action = Action.fromProto(proto.getAction());
            this.name = proto.getName();
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            return this;
        }
    }

    public static enum Action {
        CREATE,
        UPDATE,
        DELETE;

        static EnumMap<Action, ProtoUser.Command.Action> actionMap;

        public static Action fromProto(ProtoUser.Command.Action action) {
            return actionMap.getA(action);
        }

        public ProtoUser.Command.Action toProto() {
            return actionMap.getB(this);
        }

        static {
            actionMap = new EnumMap<Action, ProtoUser.Command.Action>(Action.class, ProtoUser.Command.Action.class);
        }
    }
}

