/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Result;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoUser;
import com.google.protobuf.InvalidProtocolBufferException;

public class UserPassword
extends AbstractCommandMessage<UserPassword> {
    private static final String MESSAGE_TAG = "command";
    private String name;
    private String password;

    public UserPassword() {
    }

    public UserPassword(String name, String password) {
        this.name = name;
        this.password = password;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoUser.Password.Builder toProto() {
        ProtoUser.Password.Builder builder = ProtoUser.Password.newBuilder();
        builder.setClientId(this.clientId);
        builder.setName(this.name);
        builder.setPassword(this.password);
        return builder;
    }

    @Override
    public UserPassword fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoUser.Password proto = ProtoUser.Password.parseFrom(data);
        this.clientId = proto.getClientId();
        this.name = proto.getName();
        this.password = proto.getPassword();
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private String name;

        public Response() {
        }

        public Response(UserPassword command) {
            this.name = command.name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoUser.PasswordResponse.Builder toProto() {
            ProtoUser.PasswordResponse.Builder builder = ProtoUser.PasswordResponse.newBuilder();
            builder.setResult(this.result.toProto());
            builder.setName(this.name);
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoUser.PasswordResponse proto = ProtoUser.PasswordResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.name = proto.getName();
            return this;
        }
    }
}

