/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message;

import com.beyondcron.core.Result;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.AbstractCommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoUser;
import com.google.protobuf.InvalidProtocolBufferException;

public class UserRefresh
extends AbstractCommandMessage<UserRefresh> {
    private static final String MESSAGE_TAG = "command";
    private String name;

    public UserRefresh() {
        this(null);
    }

    public UserRefresh(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoUser.Refresh.Builder toProto() {
        ProtoUser.Refresh.Builder builder = ProtoUser.Refresh.newBuilder();
        builder.setClientId(this.clientId);
        if (!StringUtils.isNullOrEmpty(this.name)) {
            builder.setName(this.name);
        }
        return builder;
    }

    @Override
    public UserRefresh fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoUser.Refresh proto = ProtoUser.Refresh.parseFrom(data);
        this.clientId = proto.getClientId();
        this.name = proto.hasName() ? proto.getName() : null;
        return this;
    }

    public static class Response
    implements Message<Response>,
    ResultMessage {
        private static final String MESSAGE_TAG = "response";
        private Result result = new Result();
        private User user = null;

        public Response() {
        }

        public User getUser() {
            return this.user;
        }

        public void setUser(User user) {
            this.user = user;
        }

        public Response(Result result) {
            this.result = result;
        }

        @Override
        public Result getResult() {
            return this.result;
        }

        public Response setResult(Result result) {
            this.result = result;
            return this;
        }

        public String toString() {
            return "Result: " + this.result.toString();
        }

        @Override
        public String getMessageTag() {
            return MESSAGE_TAG;
        }

        public ProtoUser.RefreshResponse.Builder toProto() {
            ProtoUser.RefreshResponse.Builder builder = ProtoUser.RefreshResponse.newBuilder();
            builder.setResult(this.result.toProto());
            if (this.user != null) {
                builder.setUser(this.user.toProto());
            }
            return builder;
        }

        @Override
        public Response fromProto(byte[] data) throws InvalidProtocolBufferException {
            ProtoUser.RefreshResponse proto = ProtoUser.RefreshResponse.parseFrom(data);
            this.result = new Result().fromProto(proto.getResult().toByteArray());
            this.user = proto.hasUser() ? new User().fromProto(proto.getUser().toByteArray()) : null;
            return this;
        }
    }
}

