/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging.message.calendar;

import com.beyondcron.core.BlissUtils;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.calendar.ICalendarData;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoICalendar;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.URI;

public class ICalendar
implements Comparable<ICalendar>,
Message<ICalendar> {
    private static final String MESSAGE_TAG = "ical";
    public static final URI ALL_CALENDARS = URI.create(BlissUtils.ACL_DIR_ICALENDARS.toString());
    public static final ICalendar DAILY = new ICalendar(ICalendarData.DAILY);
    public static final ICalendar WEEKDAY = new ICalendar(ICalendarData.WEEKDAY);
    public static final ICalendar WEEKEND = new ICalendar(ICalendarData.WEEKEND);
    private String name = null;
    private String description;
    private URI uri = null;
    private int listenerCount = 0;
    private long modified = 0L;
    private long refreshed = 0L;

    public ICalendar() {
    }

    public ICalendar(String name, String description, URI uri) {
        this.name = name;
        this.description = description != null ? description : "";
        this.uri = uri;
    }

    public ICalendar(ICalendarData icalendar) {
        this.name = icalendar.getName();
        this.description = icalendar.getDescription();
        if (this.description == null) {
            this.description = "";
        }
        this.uri = icalendar.getURI();
        this.modified = icalendar.getLastModified();
        this.refreshed = icalendar.getLastRefreshed();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.getDescription(false);
    }

    public String getDescription(boolean summary) {
        if (!summary) {
            return this.description;
        }
        int i = this.description.indexOf(46) + 1;
        return i > 0 ? this.description.substring(0, i) : this.description;
    }

    public URI getURI() {
        return this.uri;
    }

    public int getListenerCount() {
        return this.listenerCount;
    }

    public ICalendar setListenerCount(int listenerCount) {
        this.listenerCount = listenerCount;
        return this;
    }

    public long getLastModified() {
        return this.modified;
    }

    public long getLastRefreshed() {
        return this.refreshed;
    }

    public String toString() {
        return StringUtils.isNullOrEmpty(this.description) ? this.name : String.format("%s: %s", this.name, this.description);
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoICalendar.ICalendar.Builder toProto() {
        ProtoICalendar.ICalendar.Builder builder = ProtoICalendar.ICalendar.newBuilder();
        builder.setName(this.name);
        if (!StringUtils.isNullOrEmpty(this.description)) {
            builder.setDescription(this.description);
        }
        builder.setUri(this.uri.toString());
        if (this.listenerCount > 0) {
            builder.setListeners(this.listenerCount);
        }
        builder.setLastModified(this.modified);
        builder.setLastRefreshed(this.refreshed);
        return builder;
    }

    @Override
    public ICalendar fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoICalendar.ICalendar proto = ProtoICalendar.ICalendar.parseFrom(data);
        this.name = proto.getName();
        this.description = proto.hasDescription() ? proto.getDescription() : "";
        this.uri = NetUtils.parseURI(proto.getUri());
        this.listenerCount = proto.getListeners();
        this.modified = proto.getLastModified();
        this.refreshed = proto.getLastRefreshed();
        return this;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ICalendar)) {
            return false;
        }
        return this.compareTo((ICalendar)obj) == 0;
    }

    @Override
    public int compareTo(ICalendar that) {
        int i = this.name.compareTo(that.name);
        if (i != 0) {
            return i;
        }
        return this.uri.compareTo(that.uri);
    }
}

