/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.service.kubernetes;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.SizeUtils;
import com.beyondcron.core.Sleep;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.ThreadUtils;
import com.beyondcron.core.agent.AgentService;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.core.job.ContainerJob;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.Output;
import com.beyondcron.core.job.Status;
import com.beyondcron.messaging.Connection;
import com.beyondcron.messaging.message.JobExecute;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.squareup.okhttp.Call;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.apis.CoreV1Api;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.models.V1Container;
import io.kubernetes.client.models.V1ContainerState;
import io.kubernetes.client.models.V1ContainerStateRunning;
import io.kubernetes.client.models.V1ContainerStateTerminated;
import io.kubernetes.client.models.V1ContainerStateWaiting;
import io.kubernetes.client.models.V1ContainerStatus;
import io.kubernetes.client.models.V1DeleteOptions;
import io.kubernetes.client.models.V1EnvVar;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1Pod;
import io.kubernetes.client.models.V1PodCondition;
import io.kubernetes.client.models.V1PodSpec;
import io.kubernetes.client.models.V1ResourceRequirements;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.Watch;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class KubernetesAgentService
extends AgentService {
    static Logger logger = LogUtils.getLogger(KubernetesAgentService.class);
    public static final String SERVICE_NAME = "Kubernetes";
    public static final String SERVICE_POD_LISTENER_LOCK = "kubernetes.pod.listener.lock";
    public static final String SERVICE_STATUS_QUEUE = "kubernetes.status.queue";
    public static final String SERVICE_NAMESPACE_MAP = "kubernetes.namespace.map";
    @StringConfig.Annotation(regex="(?s).*", defaultValue="kubernetes.yaml")
    public static final String KUBERNETES_CONFIG = "kubernetes.config";
    public static final String KUBERNETES_LABEL_CLUSTER_NAME = "BeyondCron";
    public static final String KUBERNETES_ANNOTATION_JOB_NAME = "job";
    public static final String KUBERNETES_POD_NAME_FORMAT = "beyondcron-%x";
    public static final String KUBERNETES_PARAMETER_NEVER = "Never";
    public static final String KUBERNETES_PARAMETER_FALSE = Boolean.FALSE.toString();
    public static final String KUBERNETES_PARAMETER_TRUE = Boolean.TRUE.toString();
    public static final String RESOURCE_NAMESPACE = "namespace";
    public static final String RESOURCE_CPU = "cpu";
    public static final String RESOURCE_MEMORY = "memory";
    public static final Map<String, String> resourceNames = new HashMap<String, String>();
    private HazelcastInstance hazelcast;
    private static String clusterName;
    private IMap<Name, String> jobNamespace;
    private CoreV1Api commandApi = null;
    private CoreV1Api watcherApi = null;
    private Lock podListenerLock;
    private PodListener podListener;
    private StatusListener statusListener;
    private IQueue<Status> statusQueue;

    public KubernetesAgentService(HazelcastInstance hazelcast) {
        super(SERVICE_NAME);
        this.hazelcast = hazelcast;
    }

    protected void init() throws ServiceException {
        this.init(this.hazelcast);
        clusterName = Connection.getClusterName((HazelcastInstance)this.hazelcast);
        this.statusListener = new StatusListener();
        this.statusListener.start();
        this.podListener = new PodListener();
        this.podListener.start();
    }

    private void init(HazelcastInstance hazelcast) throws ServiceException {
        try {
            FileInputStream input;
            File configFile = Configs.getFile((String)KUBERNETES_CONFIG);
            FileInputStream fileInputStream = input = configFile != null ? new FileInputStream(configFile) : null;
            if (input != null) {
                ApiClient apiClient = Config.fromConfig((InputStream)input);
                this.commandApi = new CoreV1Api(apiClient);
                apiClient = Config.fromConfig((InputStream)input);
                apiClient.getHttpClient().setReadTimeout(0L, TimeUnit.SECONDS);
                this.watcherApi = new CoreV1Api(apiClient);
            } else {
                ApiClient apiClient = Config.defaultClient();
                this.commandApi = new CoreV1Api(apiClient);
                apiClient = Config.defaultClient();
                apiClient.getHttpClient().setReadTimeout(0L, TimeUnit.SECONDS);
                this.watcherApi = new CoreV1Api(apiClient);
            }
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        this.jobNamespace = hazelcast.getMap(SERVICE_NAMESPACE_MAP);
        this.podListenerLock = hazelcast.getLock(SERVICE_POD_LISTENER_LOCK);
        this.statusQueue = hazelcast.getQueue(SERVICE_STATUS_QUEUE);
        try {
            this.commandApi.getAPIResources();
        }
        catch (ApiException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public Job.Type getJobType() {
        return Job.Type.CONTAINER;
    }

    public void close() {
        if (this.podListener != null) {
            this.podListener.stop();
            this.podListener = null;
        }
        if (this.statusListener != null) {
            this.statusListener.stop();
            this.statusListener = null;
        }
    }

    public void execute(JobExecute command) throws ServiceException {
        Job job = command.getJob();
        if (job.getType() != Job.Type.CONTAINER) {
            throw new ServiceException(Localise.format((String)"unsupported job type - %s", (Object[])new Object[]{job.getType()}));
        }
        Name jobName = job.getName();
        switch (command.getAction()) {
            case START: {
                this.startPod((ContainerJob)job);
                break;
            }
            case KILL: {
                this.killJob(jobName);
                break;
            }
            default: {
                throw new ServiceException(Localise.format((String)"unsupported action - %s", (Object[])new Object[]{command.getAction()}));
            }
        }
    }

    private void startPod(ContainerJob job) {
        Name jobName = job.getName();
        String podName = KubernetesAgentService.getPodName(jobName);
        if (job.getImageName().isEmpty()) {
            this.notifyListener(new Status(jobName, Status.Result.ERROR).setMessage(Localise.format((String)"Container image undefined")));
            return;
        }
        Property namespaceProperty = job.getProperty(RESOURCE_NAMESPACE);
        if (namespaceProperty == null) {
            this.notifyListener(new Status(jobName, Status.Result.ERROR).setMessage(Localise.format((String)"Missing %s resource", (Object[])new Object[]{RESOURCE_NAMESPACE})));
            return;
        }
        String namespace = namespaceProperty.getValue();
        if (namespace.isEmpty()) {
            this.notifyListener(new Status(jobName, Status.Result.ERROR).setMessage(Localise.format((String)"Empty %s resource", (Object[])new Object[]{RESOURCE_NAMESPACE})));
            return;
        }
        V1Container container = new V1Container().name(podName).image(job.getImageName());
        V1ResourceRequirements resources = new V1ResourceRequirements();
        for (Property property : job.getProperties(Property.Type.RESOURCE)) {
            String name = resourceNames.get(property.getName());
            if (name == null) {
                this.notifyListener(new Status(jobName, Status.Result.ERROR).setMessage(Localise.format((String)"Unsupported resource: %s", (Object[])new Object[]{property.getName()})));
                return;
            }
            if (name.equals(RESOURCE_NAMESPACE)) continue;
            String value = property.getValue();
            if (name.equals(RESOURCE_MEMORY)) {
                try {
                    value = Long.toString((long)SizeUtils.Unit.B.getSize(value, SizeUtils.Unit.M));
                }
                catch (NumberFormatException e) {
                    this.notifyListener(new Status(jobName, Status.Result.ERROR).setMessage(Localise.format((String)"Invalid %s resource value: ", (Object[])new Object[]{property.getName(), value})));
                }
            }
            try {
                resources.putRequestsItem(resourceNames.get(name), new Quantity(value));
            }
            catch (Exception e) {
                this.notifyListener(new Status(jobName, Status.Result.ERROR).setMessage(Localise.format((String)"Invalid %s resource value: %s", (Object[])new Object[]{property.getName(), value})));
                return;
            }
        }
        if (resources.getRequests() != null) {
            container.setResources(resources);
        }
        for (Property property : job.getProperties(Property.Type.ENVIRONMENT)) {
            V1EnvVar var = new V1EnvVar().name(property.getName()).value(property.getValue());
            container.addEnvItem(var);
        }
        for (String arg : StringUtils.split((String)job.getCommand().getCommand())) {
            container.addCommandItem(arg);
        }
        V1PodSpec podSpec = new V1PodSpec().addContainersItem(container).restartPolicy(KUBERNETES_PARAMETER_NEVER);
        V1ObjectMeta metaData = new V1ObjectMeta().name(podName).putLabelsItem(KUBERNETES_LABEL_CLUSTER_NAME, clusterName).putAnnotationsItem(KUBERNETES_ANNOTATION_JOB_NAME, jobName.toString());
        V1Pod pod = new V1Pod().metadata(metaData).spec(podSpec);
        try {
            this.commandApi.createNamespacedPod(namespace, pod, KUBERNETES_PARAMETER_TRUE);
            this.jobNamespace.put((Object)jobName, (Object)namespace);
        }
        catch (ApiException e) {
            String responseBody = e.getResponseBody();
            if (responseBody != null) {
                JSONObject response = new JSONObject(responseBody);
                if (response.getString("reason").equals("AlreadyExists")) {
                    this.notifyListener(new Status(jobName, Status.State.RUNNING, Status.Result.ERROR).setMessage(Localise.format((String)"Already running")));
                } else {
                    logger.debug("exception starting {} - {}", (Object)jobName.toString(), (Object)e.getResponseBody());
                    this.deletePod(jobName);
                    this.notifyListener(new Status(jobName, Status.Result.ERROR).setMessage(response.getString("message")));
                }
            }
            logger.debug("exception starting {} - {}", (Object)jobName.toString(), (Object)e.getMessage());
            this.notifyListener(new Status(jobName, Status.Result.EXCEPTION).setMessage(e.getMessage()));
        }
    }

    private void killJob(Name jobName) {
        Status status = new Status(jobName, Status.Result.KILLED);
        if (!this.jobNamespace.containsKey((Object)jobName)) {
            this.notifyListener(status);
            return;
        }
        status.setOutput(this.getPodOutput(jobName));
        if (this.deletePod(jobName)) {
            this.notifyListener(status);
        }
    }

    private boolean deletePod(Name jobName) {
        String podName = KubernetesAgentService.getPodName(jobName);
        String namespace = (String)this.jobNamespace.remove((Object)jobName);
        if (namespace == null) {
            return false;
        }
        try {
            this.commandApi.deleteNamespacedPod(podName, namespace, new V1DeleteOptions(), KUBERNETES_PARAMETER_TRUE, Integer.valueOf(0), null, null);
            return true;
        }
        catch (ApiException e) {
            this.jobNamespace.put((Object)jobName, (Object)namespace);
            logger.error("could not stop {} - {}", (Object)jobName.toString(), (Object)e.getResponseBody(), (Object)e);
        }
        catch (JsonSyntaxException e) {
            if (e.getMessage().contains("Expected a string but was BEGIN_OBJECT")) {
                logger.debug("expected json exception");
                return true;
            }
            this.jobNamespace.put((Object)jobName, (Object)namespace);
            logger.error("could not stop {} - {}", (Object)jobName.toString(), (Object)e.getMessage(), (Object)e);
        }
        return false;
    }

    private Output getPodOutput(Name jobName) {
        String namespace = (String)this.jobNamespace.get((Object)jobName);
        if (namespace == null) {
            return null;
        }
        String podName = KubernetesAgentService.getPodName(jobName);
        Output.Builder output = new Output.Builder();
        try {
            output.addConcatenatedLines(this.commandApi.readNamespacedPodLog(podName, namespace, null, null, null, null, null, null, null, null));
        }
        catch (ApiException e) {
            this.notifyListener(new ServiceException((Throwable)e));
        }
        return output.build();
    }

    public static String getPodName(Name name) {
        return String.format(KUBERNETES_POD_NAME_FORMAT, (clusterName + name).hashCode());
    }

    static {
        Configs.addConfigs(KubernetesAgentService.class);
        resourceNames.put(RESOURCE_CPU, RESOURCE_CPU);
        resourceNames.put("cpus", RESOURCE_CPU);
        resourceNames.put("mem", RESOURCE_MEMORY);
        resourceNames.put(RESOURCE_MEMORY, RESOURCE_MEMORY);
        resourceNames.put(RESOURCE_NAMESPACE, RESOURCE_NAMESPACE);
    }

    private class StatusListener
    extends Threaded {
        private StatusListener() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Status status;
                    if ((status = (Status)KubernetesAgentService.this.statusQueue.take()).isInactive()) {
                        Name name = status.getName();
                        status.setOutput(KubernetesAgentService.this.getPodOutput(name));
                        KubernetesAgentService.this.deletePod(name);
                    }
                    KubernetesAgentService.this.notifyListener(status);
                }
            }
            catch (TargetDisconnectedException e) {
                Localise.logWarn((Logger)logger, (String)"disconnected from cluster", (Object[])new Object[0]);
            }
            catch (InterruptedException e) {
                this.interrupted();
            }
        }
    }

    private class PodListener
    extends Threaded {
        private PodListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Sleep delay = new Sleep(1, 300);
            block5: while (true) {
                KubernetesAgentService.this.podListenerLock.lock();
                try {
                    Watch watcher = Watch.createWatch((ApiClient)KubernetesAgentService.this.watcherApi.getApiClient(), (Call)KubernetesAgentService.this.watcherApi.listPodForAllNamespacesCall(null, null, Boolean.valueOf(false), String.format("%s=%s", KubernetesAgentService.KUBERNETES_LABEL_CLUSTER_NAME, clusterName), null, null, null, null, Boolean.valueOf(true), null, null), (Type)new TypeToken<Watch.Response<V1Pod>>(){}.getType());
                    delay.reset();
                    Iterator iterator = watcher.iterator();
                    while (true) {
                        List conditions;
                        V1Pod pod;
                        Map annotations;
                        Name jobName;
                        if (!iterator.hasNext()) continue block5;
                        Watch.Response item = (Watch.Response)iterator.next();
                        if (item.type == null || item.type.equals("DELETED") || (jobName = (annotations = (pod = (V1Pod)item.object).getMetadata().getAnnotations()) != null ? Name.parse((String)((String)annotations.get(KubernetesAgentService.KUBERNETES_ANNOTATION_JOB_NAME))) : null) == null || (conditions = pod.getStatus().getConditions()) == null || conditions.isEmpty()) continue;
                        V1PodCondition condition = (V1PodCondition)conditions.get(0);
                        if ("Unschedulable".equals(condition.getReason())) {
                            KubernetesAgentService.this.statusQueue.put((Object)new Status(jobName, Status.Result.ERROR).setMessage(condition.getMessage()));
                            continue;
                        }
                        List statuses = pod.getStatus().getContainerStatuses();
                        if (statuses == null || statuses.isEmpty()) continue;
                        V1ContainerState state = ((V1ContainerStatus)statuses.get(0)).getState();
                        V1ContainerStateTerminated terminated = state.getTerminated();
                        V1ContainerStateRunning running = state.getRunning();
                        V1ContainerStateWaiting waiting = state.getWaiting();
                        Status status = null;
                        if (terminated != null) {
                            status = this.stateTerminated(jobName, terminated);
                        } else if (running != null) {
                            status = this.stateRunning(jobName, running);
                        } else if (waiting != null) {
                            status = this.stateWaiting(jobName, waiting);
                        }
                        if (status == null) continue;
                        KubernetesAgentService.this.statusQueue.put((Object)status);
                    }
                }
                catch (Exception e) {
                    logger.error("unexpected exception - {}", (Object)e.getMessage(), (Object)e);
                    delay.sleep();
                    continue;
                }
                finally {
                    KubernetesAgentService.this.podListenerLock.unlock();
                    continue;
                }
                break;
            }
        }

        private Status stateRunning(Name name, V1ContainerStateRunning state) {
            return new Status(name, Status.State.RUNNING).setTimestamp(state.getStartedAt().getMillis(), true);
        }

        private Status stateTerminated(Name name, V1ContainerStateTerminated state) {
            String message;
            Status.Result result;
            if (!KubernetesAgentService.this.jobNamespace.containsKey((Object)name)) {
                return null;
            }
            if (state.getSignal() != null) {
                result = Status.Result.KILLED;
                message = this.getMessage(state.getReason(), state.getMessage());
            } else if (state.getReason().equals("Completed")) {
                result = state.getExitCode() == 0 ? Status.Result.SUCCESS : Status.Result.ERROR;
                message = state.getMessage();
            } else {
                result = Status.Result.ERROR;
                message = this.getMessage(state.getReason(), state.getMessage());
            }
            return new Status(name, result).setTimestamp(state.getFinishedAt().getMillis(), true).setExitValue(state.getExitCode().intValue()).setMessage(message);
        }

        private Status stateWaiting(Name name, V1ContainerStateWaiting state) {
            if (state.getReason().equals("ImagePullBackOff")) {
                return new Status(name, Status.Result.ERROR).setMessage(String.format("%s: %s", state.getReason(), state.getMessage()));
            }
            return null;
        }

        private String getMessage(String reason, String message) {
            return message != null ? String.format("%s: %s", reason, message) : reason;
        }
    }

    private abstract class Threaded
    implements Runnable {
        private Thread thread = null;
        protected boolean stopping = false;

        private Threaded() {
        }

        public void start() {
            if (!this.isRunning()) {
                this.thread = ThreadUtils.getThread((Runnable)this);
                this.thread.start();
            }
        }

        public void stop() {
            if (this.isRunning()) {
                this.stopping = true;
                this.thread.interrupt();
            }
            this.thread = null;
        }

        public boolean isRunning() {
            return this.thread != null && this.thread.isAlive();
        }

        protected void interrupted() {
            logger.error(Localise.format((String)"%s unexpected interrupt", (Object[])new Object[]{Thread.currentThread().getName()}));
            KubernetesAgentService.this.notifyListener(new ServiceException(Localise.format((String)"unexpected interrupt")));
        }
    }
}

