/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.service.unix;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Filter;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Period;
import com.beyondcron.core.Role;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.config.BooleanConfig;
import com.beyondcron.core.config.PeriodConfig;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.core.user.User;
import com.beyondcron.core.user.UserService;
import com.hazelcast.core.HazelcastInstance;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jnr.posix.Group;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import jnr.posix.Passwd;
import org.apache.logging.log4j.Logger;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;

public class UnixUserService
extends UserService {
    static final Logger logger = LogUtils.getLogger(UnixUserService.class);
    public static final String SERVICE_NAME = "Unix";
    @PeriodConfig.Annotation(defaultValue="15 minutes")
    public static final String UNIX_CACHE_PERIOD = "unix.refresh.period";
    @StringConfig.Annotation(defaultValue="bc_")
    public static final String UNIX_GROUP_PREFIX = "unix.group.prefix";
    @BooleanConfig.Annotation
    public static final String UNIX_GROUP_REQUIRED = "unix.group.required";
    @StringConfig.Annotation(defaultValue="login")
    public static final String UNIX_PAM_AUTH_SERVICE = "unix.pam.auth.service";
    private POSIX posix;
    private PAM pam;
    private boolean groupRequired;
    private String groupPrefix;
    private int groupPrefixLength;
    private long cachePeriod;
    private UserCache users;
    private GroupCache groups;

    public UnixUserService() {
        this(null);
    }

    public UnixUserService(HazelcastInstance hazelcast) {
        super(SERVICE_NAME);
        this.groups = new GroupCache(hazelcast);
        this.users = new UserCache(hazelcast);
    }

    protected void init() throws ServiceException {
        super.init();
        this.posix = POSIXFactory.getPOSIX();
        try {
            this.pam = new PAM((String)Configs.get((String)UNIX_PAM_AUTH_SERVICE));
        }
        catch (PAMException e) {
            throw new ServiceException((Throwable)e);
        }
        this.groupRequired = (Boolean)Configs.get((String)UNIX_GROUP_REQUIRED);
        this.groupPrefix = (String)Configs.get((String)UNIX_GROUP_PREFIX);
        this.groupPrefixLength = this.groupPrefix.length();
        this.cachePeriod = ((Period)Configs.get((String)UNIX_CACHE_PERIOD)).getMilliseconds();
    }

    public User authenticateUser(String name, String password) throws ServiceException {
        User user = this.users.getUser(name, true);
        if (user == null) {
            return null;
        }
        try {
            if (this.pam.authenticate(name, password) == null) {
                user = null;
            }
        }
        catch (PAMException e) {
            if (e.getMessage().equals("pam_authenticate failed : authentication error")) {
                user = null;
            }
            throw new ServiceException((Throwable)e);
        }
        return user;
    }

    public User getUser(String name, boolean refresh) {
        return this.users.getUser(name, refresh);
    }

    public Set<User> getUsers(Filter filter) {
        TreeSet<User> userSet = new TreeSet<User>();
        for (User user : this.users.getUsers()) {
            if (filter != null && !filter.matches(user.getName())) continue;
            userSet.add(user);
        }
        return userSet;
    }

    public boolean isUser(String name) {
        return this.users.isUser(name);
    }

    public Role getRole(String name) {
        return this.groups.isGroup(name) ? new Role(name) : null;
    }

    public Set<Role> getRoles(Filter filter) {
        TreeSet<Role> roleSet = new TreeSet<Role>();
        for (String name : this.groups.getGroups()) {
            if (filter != null && !filter.matches(name)) continue;
            roleSet.add(new Role(name));
        }
        return roleSet;
    }

    public boolean isRole(String name) {
        return this.groups.isGroup(name);
    }

    public void refresh() {
        logger.info("refreshing unix service");
        this.groups.updateCache(true);
        this.users.updateCache(true);
    }

    private class GroupCache {
        private Map<String, Set<String>> groups;
        private Map<Long, String> groupIDs;
        private long cacheExpiry = 0L;
        private Lock lock;

        public GroupCache(HazelcastInstance hazelcast) {
            if (hazelcast != null) {
                this.groups = hazelcast.getMap("service.user.unix.groups");
                this.groupIDs = hazelcast.getMap("service.user.unix.groups.ids");
                this.lock = hazelcast.getLock("service.user.unix.groups.lock");
            } else {
                this.groups = new HashMap<String, Set<String>>();
                this.groupIDs = new HashMap<Long, String>();
                this.lock = new ReentrantLock();
            }
        }

        public boolean isGroup(String name) {
            this.lock.lock();
            try {
                this.updateCache(false);
                boolean bl = this.groups.containsKey(name);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public Set<String> getGroups() {
            this.lock.lock();
            try {
                this.updateCache(false);
                Set<String> set = this.groups.keySet();
                return set;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<String> getGroups(Passwd passwd) {
            this.lock.lock();
            try {
                this.updateCache(false);
                HashSet<String> groupSet = new HashSet<String>();
                String name = passwd.getLoginName();
                String primaryGroup = this.groupIDs.get(passwd.getGID());
                if (primaryGroup != null) {
                    groupSet.add(primaryGroup);
                }
                for (String group : this.groups.keySet()) {
                    if (!this.groups.get(group).contains(name)) continue;
                    groupSet.add(group);
                }
                HashSet<String> hashSet = groupSet;
                return hashSet;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateCache(boolean force) {
            if (!UnixUserService.this.isConnected()) {
                return;
            }
            this.lock.lock();
            try {
                if (force || System.currentTimeMillis() > this.cacheExpiry) {
                    Group group;
                    this.groups.clear();
                    this.groupIDs.clear();
                    UnixUserService.this.posix.setgrent();
                    while ((group = UnixUserService.this.posix.getgrent()) != null) {
                        String name = group.getName();
                        if (UnixUserService.this.groupPrefixLength > 0) {
                            if (!name.startsWith(UnixUserService.this.groupPrefix)) continue;
                            name = name.substring(UnixUserService.this.groupPrefixLength);
                        }
                        HashSet<String> members = new HashSet<String>(Arrays.asList(group.getMembers()));
                        this.groups.put(name, members);
                        this.groupIDs.put(group.getGID(), name);
                    }
                    UnixUserService.this.posix.endgrent();
                    this.cacheExpiry = System.currentTimeMillis() + UnixUserService.this.cachePeriod;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private class UserCache {
        private Map<String, User> users;
        private long cacheExpiry = 0L;
        private Lock lock;

        public UserCache(HazelcastInstance hazelcast) {
            if (hazelcast != null) {
                this.users = hazelcast.getMap("service.user.unix.users");
                this.lock = hazelcast.getLock("service.user.unix.users.lock");
            } else {
                this.users = new HashMap<String, User>();
                this.lock = new ReentrantLock();
            }
        }

        public boolean isUser(String name) {
            this.lock.lock();
            try {
                this.updateCache(false);
                boolean bl = this.users.containsKey(name);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public User getUser(String name, boolean ignoreCache) {
            this.lock.lock();
            try {
                User user = this.users.get(name);
                if ((user == null || ignoreCache || System.currentTimeMillis() > this.cacheExpiry) && UnixUserService.this.isConnected()) {
                    Passwd passwd = UnixUserService.this.posix.getpwnam(name);
                    if (passwd == null) {
                        User user2 = null;
                        return user2;
                    }
                    user = this.createUser(passwd);
                }
                User user3 = user;
                return user3;
            }
            finally {
                this.lock.unlock();
            }
        }

        public Collection<User> getUsers() {
            this.lock.lock();
            try {
                this.updateCache(false);
                Collection<User> collection = this.users.values();
                return collection;
            }
            finally {
                this.lock.unlock();
            }
        }

        private User createUser(Passwd passwd) {
            User user = new User(passwd.getLoginName(), passwd.getGECOS());
            String home = passwd.getHome();
            if (!StringUtils.isNullOrEmpty((String)home)) {
                try {
                    user.setHome(new Name(home));
                }
                catch (URISyntaxException e) {
                    logger.warn("invalid home for unix {} - {}", (Object)user.getName(), (Object)home);
                }
            }
            user.addRoles(UnixUserService.this.groups.getGroups(passwd));
            if (UnixUserService.this.groupRequired && user.getRoles().size() < 1) {
                return null;
            }
            this.users.put(user.getName(), user);
            return user;
        }

        private void updateCache(boolean force) {
            if (!UnixUserService.this.isConnected()) {
                return;
            }
            this.lock.lock();
            try {
                if (force || System.currentTimeMillis() > this.cacheExpiry) {
                    Passwd passwd;
                    this.users.clear();
                    UnixUserService.this.posix.setpwent();
                    while ((passwd = UnixUserService.this.posix.getpwent()) != null) {
                        this.createUser(passwd);
                    }
                    UnixUserService.this.posix.endpwent();
                    this.cacheExpiry = System.currentTimeMillis() + UnixUserService.this.cachePeriod;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

