/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Localise;

public class BooleanUtils {
    public static boolean valueOf(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("null");
        }
        switch (value.toLowerCase()) {
            case "true": 
            case "yes": {
                return true;
            }
            case "false": 
            case "no": {
                return false;
            }
        }
        throw new IllegalArgumentException("not a boolean");
    }

    public static boolean valueOf(String value, boolean defaultValue) {
        if (value != null) {
            switch (value.toLowerCase()) {
                case "true": 
                case "yes": {
                    return true;
                }
                case "false": 
                case "no": {
                    return false;
                }
            }
        }
        return defaultValue;
    }

    public static boolean isBoolean(String value) {
        return "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
    }

    public static boolean isBooleanYesNo(String value) {
        return "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value);
    }

    public static boolean isTrueYes(String value) {
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    public static boolean isFalseNo(String value) {
        return "false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value);
    }

    public static String toYesNo(String value) {
        return BooleanUtils.toYesNo(BooleanUtils.valueOf(value));
    }

    public static String toYesNo(boolean value) {
        return value ? Localise.format("Yes") : Localise.format("No");
    }

    public static String toString(String value) {
        return Boolean.valueOf(value).toString();
    }

    public static String toString(boolean value) {
        return Boolean.valueOf(value).toString();
    }
}

