/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtils {
    public static <T> Map<T, Integer> increment(Map<T, Integer> map, T value) {
        if (map.containsKey(value)) {
            map.put(value, 1);
        } else {
            map.put(value, map.get(value) + 1);
        }
        return map;
    }

    public static <T> List<T> asList(T ... values) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, values);
        return list;
    }

    public static <T> Set<T> asSet(T ... values) {
        HashSet set = new HashSet();
        Collections.addAll(set, values);
        return set;
    }

    public static <T> Set<T> asSet(Collection<T> values) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(values);
        return set;
    }

    public static <T> Set<T> join(Collection<T> ... collections) {
        HashSet<T> set = new HashSet<T>();
        for (Collection<T> collection : collections) {
            set.addAll(collection);
        }
        return set;
    }

    public static <T extends Comparable<? super T>> List<T> sort(Collection<T> values) {
        ArrayList<T> list = new ArrayList<T>(values);
        Collections.sort(list);
        return list;
    }

    public static <T extends Comparable<? super T>> Set<T> not(Collection<T> valuesA, Collection<T> valuesB) {
        HashSet<Comparable> set = new HashSet<Comparable>();
        for (Comparable value : valuesA) {
            if (valuesB.contains(value)) continue;
            set.add(value);
        }
        return set;
    }
}

