/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandStack {
    static Pattern nthCommandPattern = Pattern.compile("^!-([1-9][0-9]*)$");
    static Pattern commandPattern = Pattern.compile("^!(.+)$");
    static Pattern historyPattern = Pattern.compile("^history( +([1-9][0-9]*))?$");
    PrintStream out;
    int maxSize;
    LinkedList<String> commands = new LinkedList();

    public CommandStack(OutputStream out, int maxSize) {
        this.out = new PrintStream(out);
        this.maxSize = maxSize;
    }

    public void add(String command) {
        this.commands.addFirst(command);
        if (this.commands.size() > this.maxSize) {
            this.commands.removeLast();
        }
    }

    public String get(String expression) {
        if (expression.equals("!!")) {
            if (this.commands.size() > 0) {
                String s = this.commands.getFirst();
                this.out.println(s);
                return s;
            }
            return null;
        }
        Matcher m = nthCommandPattern.matcher(expression);
        if (m.matches()) {
            int i = Integer.parseInt(m.group(1)) - 1;
            if (i < this.commands.size()) {
                String s = this.commands.get(i);
                this.out.println(s);
                return s;
            }
            return null;
        }
        m = commandPattern.matcher(expression);
        if (m.matches()) {
            String s = m.group(1);
            for (String command : this.commands) {
                if (!command.startsWith(s)) continue;
                this.out.println(command);
                return command;
            }
            return null;
        }
        m = historyPattern.matcher(expression);
        if (m.matches()) {
            int i = m.group(2) != null ? Integer.parseInt(m.group(2)) : this.commands.size();
            int n = i = i > this.commands.size() ? this.commands.size() : i;
            while (i-- > 0) {
                this.out.println("  " + this.commands.get(i));
            }
            this.add(expression);
            return "";
        }
        return expression;
    }
}

