/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.JSONUtils;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class Credit
implements Comparable<Credit> {
    static final Logger logger = LogUtils.getLogger(Credit.class);
    public static final String JSON_CREDITS = "credits";
    public static final String JSON_NAME = "name";
    public static final String JSON_NAME_URL = "nameURL";
    public static final String JSON_VERSION = "version";
    public static final String JSON_LICENSE = "license";
    public static final String JSON_LICENSE_TEXT = "licenseText";
    public static final String JSON_LICENSE_URL = "licenseURL";
    private String name = null;
    private String nameURL = null;
    private String version = null;
    private String license = null;
    private String licenseText = null;
    private String licenseURL = null;

    public static List<Credit> loadCredits(Enumeration<URL> urls) throws IOException {
        TreeSet<Credit> credits = new TreeSet<Credit>();
        while (urls.hasMoreElements()) {
            credits.addAll(Credit.loadCredits(urls.nextElement()));
        }
        return new ArrayList<Credit>(credits);
    }

    public static List<Credit> loadCredits(URL url) throws IOException {
        TreeSet<Credit> credits = new TreeSet<Credit>();
        if (url == null) {
            Localise.logError(logger, "Undefined url", new Object[0]);
            return null;
        }
        if (!url.getFile().toLowerCase().endsWith("yaml")) {
            Localise.logError(logger, "Unsupported credits file format - %1$s", url.toString());
            return null;
        }
        JSONObject json = JSONUtils.fromYAML(url.openStream());
        JSONArray a = json.getJSONArray(JSON_CREDITS);
        for (int i = 0; i < a.length(); ++i) {
            Credit credit = new Credit();
            JSONObject c = a.getJSONObject(i);
            if (!c.has(JSON_NAME)) {
                Localise.logError(logger, "Ignoring invalid credit entry - %1$s", c.toString());
                continue;
            }
            credit.name = c.getString(JSON_NAME);
            credit.nameURL = c.optString(JSON_NAME_URL);
            credit.version = c.optString(JSON_VERSION);
            credit.license = c.optString(JSON_LICENSE);
            credit.licenseText = c.optString(JSON_LICENSE_TEXT);
            credit.licenseURL = c.optString(JSON_LICENSE_URL);
            credits.add(credit);
        }
        return new ArrayList<Credit>(credits);
    }

    private Credit() {
    }

    public String getName() {
        return this.name;
    }

    public String getNameURL() {
        return this.nameURL;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLicense() {
        return this.license;
    }

    public String getLicenseText() {
        return this.licenseText;
    }

    public String getLicenseURL() {
        return this.licenseURL;
    }

    public String toString() {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(this.name);
        if (!StringUtils.isNullOrEmpty(this.nameURL)) {
            values.add("(" + this.nameURL + ")");
        }
        if (!StringUtils.isNullOrEmpty(this.version)) {
            values.add(this.version);
        }
        if (!StringUtils.isNullOrEmpty(this.license)) {
            values.add(this.license);
        }
        if (!StringUtils.isNullOrEmpty(this.licenseText)) {
            values.add("[" + this.licenseText + "]");
        }
        if (!StringUtils.isNullOrEmpty(this.licenseURL)) {
            values.add("(" + this.licenseURL + ")");
        }
        return StringUtils.join(" ", values);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Credit)) {
            return false;
        }
        return this.compareTo((Credit)obj) == 0;
    }

    @Override
    public int compareTo(Credit that) {
        int i = this.name.compareToIgnoreCase(that.name);
        if (i != 0) {
            return i;
        }
        return this.version.compareTo(that.version);
    }
}

