/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import java.util.HashMap;
import java.util.Map;

public class EnumMap<A extends Enum<A>, B extends Enum<B>> {
    private A defaultA;
    private B defaultB;
    private Map<A, B> enumAtoB = new HashMap<A, B>();
    private Map<B, A> enumBtoA = new HashMap<B, A>();

    public EnumMap(Class<A> classA, Class<B> classB) {
        this(classA, classB, null, null);
    }

    public EnumMap(Class<A> classA, Class<B> classB, A defaultA, B defaultB) {
        this.defaultA = defaultA;
        this.defaultB = defaultB;
        for (Enum value : (Enum[])classA.getEnumConstants()) {
            try {
                this.enumAtoB.put(value, Enum.valueOf(classB, value.toString()));
            }
            catch (IllegalArgumentException e) {
                this.enumAtoB.put(value, defaultB);
            }
        }
        for (Enum value : (Enum[])classB.getEnumConstants()) {
            try {
                this.enumBtoA.put(value, Enum.valueOf(classA, value.toString()));
            }
            catch (IllegalArgumentException e) {
                this.enumBtoA.put(value, defaultA);
            }
        }
    }

    public B getB(A value) {
        return (B)(value != null ? (Enum)this.enumAtoB.get(value) : this.defaultB);
    }

    public A getA(B value) {
        return (A)(value != null ? (Enum)this.enumBtoA.get(value) : this.defaultA);
    }
}

