/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class IOUtils {
    static final Logger logger = LogUtils.getLogger(IOUtils.class);
    private static final List<File> resourceDirectories = new ArrayList<File>();
    private static final int BUFFER_SIZE = 4098;
    private static BufferedReader console = null;

    public static long copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[4098];
        int copied = 0;
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
            copied += len;
        }
        return copied;
    }

    public static String read(InputStream in) throws IOException {
        return IOUtils.read(new InputStreamReader(in));
    }

    public static String read(InputStreamReader in) throws IOException {
        int len;
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[4098];
        while ((len = in.read(buffer)) != -1) {
            sb.append(buffer, 0, len);
        }
        return sb.toString();
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        int len;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] buffer = new byte[4098];
        while ((len = in.read(buffer)) != -1) {
            if (logger.isDebugEnabled()) {
                int i = bytes.size();
                Localise.logDebug(Localise.logger, "read bytes %d - %d", i, i + len - 1);
            }
            bytes.write(buffer, 0, len);
        }
        return bytes.toByteArray();
    }

    public static String readLine(String prompt) {
        if (prompt != null) {
            System.out.print(prompt);
            System.out.flush();
        }
        if (console == null) {
            console = new BufferedReader(new InputStreamReader(System.in));
        }
        try {
            return console.readLine();
        }
        catch (IOException e) {
            Localise.logError(logger, e, "Could not read input", new Object[0]);
            System.exit(1);
            return null;
        }
    }

    public static void addResourceDirectory(File directory) {
        if (!resourceDirectories.contains(directory)) {
            resourceDirectories.add(directory);
        }
    }

    public static String readResource(String name) throws IOException {
        URL resource = null;
        for (File directory : resourceDirectories) {
            File file = new File(directory, name);
            if (!file.exists()) continue;
            resource = file.toURI().toURL();
        }
        if (resource == null) {
            resource = IOUtils.class.getClassLoader().getResource(name);
        }
        if (resource != null) {
            if (logger.isInfoEnabled()) {
                Localise.logInfo(logger, "loading %s", resource.toString());
            }
            return IOUtils.read(resource.openStream());
        }
        throw new IOException("resource does not exist");
    }
}

