/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.JSON;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class JSONUtils {
    public static String toYAML(JSONObject json) {
        return JSONUtils.toYAML(json, false);
    }

    public static String toYAML(JSONObject json, boolean prettyPrint) {
        DumperOptions options = new DumperOptions();
        options.setPrettyFlow(prettyPrint);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return JSONUtils.toYAML(json, options);
    }

    public static String toYAML(JSONObject json, DumperOptions options) {
        Yaml yaml = new Yaml(options);
        return yaml.dump(yaml.load(json.toString(2)));
    }

    public static JSONObject fromYAML(String yaml) {
        return (JSONObject)JSONUtils.parseYAML(new Yaml().load(yaml));
    }

    public static JSONObject fromYAML(InputStream in) {
        return (JSONObject)JSONUtils.parseYAML(new Yaml().load(in));
    }

    public static boolean equals(JSON obj1, JSON obj2) {
        return JSONUtils.compare(obj1, obj2) == 0;
    }

    public static boolean equals(JSONObject json1, JSONObject json2) {
        return JSONUtils.compare(json1, json2) == 0;
    }

    public static int compare(JSON obj1, JSON obj2) {
        return JSONUtils.compare(obj1.toJSON(), obj2.toJSON());
    }

    public static int compare(JSONObject json1, JSONObject json2) {
        return json1.toString().compareTo(json2.toString());
    }

    private static Object parseYAML(Object yaml) {
        if (yaml instanceof Map) {
            return JSONUtils.parseYAML((Map)yaml);
        }
        if (yaml instanceof List) {
            return JSONUtils.parseYAML((List)yaml);
        }
        return yaml;
    }

    private static JSONObject parseYAML(Map<String, Object> yaml) {
        JSONObject json = new JSONObject();
        for (String name : yaml.keySet()) {
            json.put(name, JSONUtils.parseYAML(yaml.get(name)));
        }
        return json;
    }

    private static JSONArray parseYAML(List<Object> yaml) {
        JSONArray json = new JSONArray();
        for (Object value : yaml) {
            json.put(JSONUtils.parseYAML(value));
        }
        return json;
    }

    public static JSONObject filter(JSONObject jsonObject, Set<String> filters) {
        if (filters.isEmpty()) {
            return jsonObject;
        }
        JSONObject json = new JSONObject();
        for (String key : jsonObject.keySet()) {
            JSONArray a;
            Object obj = jsonObject.get(key);
            if (filters.contains(key)) {
                json.put(key, obj);
                continue;
            }
            if (obj instanceof JSONObject) {
                JSONObject j = JSONUtils.filter((JSONObject)obj, filters);
                if (j.length() <= 0) continue;
                json.put(key, j);
                continue;
            }
            if (!(obj instanceof JSONArray) || (a = JSONUtils.filter((JSONArray)obj, filters)).length() <= 0) continue;
            json.put(key, a);
        }
        return json;
    }

    public static JSONArray filter(JSONArray jsonArray, Set<String> filters) {
        if (filters.isEmpty()) {
            return jsonArray;
        }
        JSONArray json = new JSONArray();
        for (Object obj : jsonArray) {
            JSONArray a;
            if (obj instanceof JSONObject) {
                JSONObject o = JSONUtils.filter((JSONObject)obj, filters);
                if (o.length() <= 0) continue;
                json.put(o);
                continue;
            }
            if (!(obj instanceof JSONArray) || (a = JSONUtils.filter((JSONArray)obj, filters)).length() <= 0) continue;
            json.put(a);
        }
        return json;
    }
}

