/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.BooleanUtils;
import com.beyondcron.core.Configs;
import com.beyondcron.core.EnumMap;
import com.beyondcron.core.JSON;
import com.beyondcron.core.JSONUtils;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.NumberUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.Program;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.TableFormatter;
import com.beyondcron.core.TimeUtils;
import com.beyondcron.core.Version;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoLicense;
import com.beyondcron.messaging.proto.ProtoProperty;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class License
implements JSON<License>,
Message<License> {
    static final Logger logger = LogUtils.getLogger(License.class);
    private static final String MESSAGE_TAG = "license";
    public static final String JSON_CALENDARS = "calendars";
    public static final String JSON_EXECUTIONS = "executions";
    public static final String JSON_EXPIRES = "expires";
    public static final String JSON_EXPIRY = "expiry";
    public static final String JSON_JOBS = "jobs";
    public static final String JSON_INSTANCE = "instance";
    public static final String JSON_ISSUED = "issued";
    public static final String JSON_LICENSEE = "licensee";
    public static final String JSON_PROPERTIES = "properties";
    public static final String JSON_SERVERS = "servers";
    public static final String JSON_SIGNATURE = "signature";
    public static final String JSON_TEST = "test";
    public static final String JSON_TYPE = "type";
    public static final String JSON_VALID = "valid";
    private static final String KEY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final String PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqjiSkt5ZBy7qfSwYJ/Ir\nuEwJ3J9XxUgYvGHwiDUnltfVAAG/tE4qIN/U1wLM/MGwG8qkgVtibKt6xw1m7L2j\nHkeuXibJBM9p2S+Kj/h4jmtMV57NtPexBry2AL84+q2s/xNFCNZ0ouI8/R2Vssup\nZWWdkfW1+0Z6Mc+QVLhuS5B2oFchE0si9MaUGDuer50NtNKsZHyWcQ7Z5/q/wezL\nrM9o48ehDZjr2fMp1M4i2DsWBKjoTex3d6yQ4ZN4CNZ4pwPbd42xe8aNMRPX5M9+\nqqGVV5fdHm3w/7EHuZ8dlKue39JP0XxFxP4piJ8IPavt+jbmmdsgCFV2Te1bNEQE\nZQIDAQAB\n";
    private static PublicKey publicKey;
    private static int evalExpiryUnit;
    private static int evalExpiryPeriod;
    private static DateTimeFormatter expiryFormatter;
    private static final String itemFormat = "%1$s: %2$s";
    public static final String DEFAULT_LICENSE = "defaultLicense";
    public static final String TEST_LICENSE = "testLicense";
    public static final String MAX_SERVERS = "maxServers";
    public static final String MAX_CALENDARS = "maxCalendars";
    public static final String MAX_JOBS = "maxJobs";
    public static final String MAX_EXECUTIONS = "maxExecutions";
    public static final String MAX_EXECUTIONS_HOUR = "maxExecutionsHour";
    public static Map<String, String> DEFAULTS;
    public static final String JOB_FLOWS = "jobFlows";
    public static final String JOB_FLOW_WILDCARDS = "jobFlowWildcards";
    public static final String JOB_OUTPUT = "jobOutput";
    public static final String COMMAND_JOBS = "commandJobs";
    public static final String CONTAINER_JOBS = "containerJobs";
    public static final String CUSTOM_JOBS = "customJobs";
    public static final String MESSAGE_JOBS = "messageJobs";
    public static final String SQL_JOBS = "sqlJobs";
    public static final String TRIGGER_JOBS = "triggerJobs";
    public static final String URL_JOBS = "urlJobs";
    private File file = null;
    private Type type;
    private Date issued = new Date();
    private Date expiry;
    private String licensee = null;
    private String instance = null;
    private boolean valid = false;
    private String reason = null;
    private Date epoch = new Date(0L);
    private String signature = null;
    private Map<String, String> properties = new TreeMap<String, String>();

    public License() {
        this(Type.EVALUATION, new Date(0L));
        this.addProperty(DEFAULT_LICENSE, true);
    }

    public License(Type type, Date expiry) {
        this(type, expiry, null);
    }

    public License(Type type, Date expiry, String licensee) {
        this.type = type;
        this.expiry = expiry;
        this.licensee = licensee;
        boolean bl = this.valid = expiry.getTime() > 0L;
        if (!this.valid) {
            this.reason = Localise.format("Invalid expiry date");
        }
    }

    public License(Version version) {
        this.type = Type.EVALUATION;
        Date buildDate = version.getBuildDate();
        boolean bl = this.valid = buildDate.getTime() > 0L;
        if (!this.valid && !License.class.getProtectionDomain().getCodeSource().getLocation().getPath().endsWith(".jar")) {
            this.valid = true;
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            buildDate = cal.getTime();
        }
        if (!this.valid) {
            this.reason = Localise.format("Invalid expiry date");
        }
        this.setEvalEpoch(buildDate);
    }

    public License(File file) throws IOException {
        this(file, true);
    }

    public License(File file, boolean requireSignature) throws IOException {
        if (!file.exists()) {
            throw new IOException(Localise.format("License file %s does not exist", file.toString()));
        }
        if (!file.canRead()) {
            throw new IOException(Localise.format("Cannot read license file %S", file.toString()));
        }
        this.file = file;
        this.loadLicense(new FileInputStream(file), requireSignature);
    }

    public License(String licenseText) throws IOException {
        this.loadLicense(StringUtils.asStream(licenseText), true);
    }

    public License(String licenseText, boolean requireSignature) throws IOException {
        this.loadLicense(StringUtils.asStream(licenseText), requireSignature);
    }

    public License(InputStream inputStream) throws IOException {
        this.loadLicense(inputStream, true);
    }

    public License(InputStream inputStream, boolean requireSignature) throws IOException {
        this.loadLicense(inputStream, requireSignature);
    }

    private void loadLicense(InputStream inputStream, boolean requireSignature) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        while (in.ready()) {
            sb.append(in.readLine().replaceAll("\\s+", " "));
            sb.append("\n");
        }
        JSONObject json = JSONUtils.fromYAML(sb.toString());
        this.fromJSON(json);
        this.valid = true;
        if (requireSignature) {
            if (this.signature != null) {
                this.valid = this.verifySignature();
                if (!this.valid) {
                    this.reason = Localise.format("Invalid signature");
                }
            } else {
                this.valid = false;
                this.reason = Localise.format("Missing signature");
            }
        }
        if (this.valid) {
            boolean bl = this.valid = this.expiry.getTime() > 0L;
            if (!this.valid) {
                this.reason = Localise.format("Invalid expiry date");
            }
        }
    }

    public boolean isDefaultLicense() {
        return this.type == Type.EVALUATION && this.getBooleanProperty(DEFAULT_LICENSE, false);
    }

    public boolean isActive() {
        return this.isValid() && (!this.isExpired() || !this.type.hasHardExpiry());
    }

    public boolean isActiveEvaluation() {
        return this.type == Type.EVALUATION && !this.isExpired();
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getReason() {
        return this.reason;
    }

    public Type getType() {
        return this.type;
    }

    public String getLicensee() {
        return this.licensee;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public Date getIssued() {
        return this.issued;
    }

    public void setIssued(Date issued) {
        this.issued = issued;
    }

    public Date getExpiry() {
        return this.expiry;
    }

    public int getExpiryDays() {
        long expiryTime = this.expiry.getTime();
        if (expiryTime == Long.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)((expiryTime - new Date().getTime()) / Period.Unit.DAY.getMilliseconds(1L));
    }

    public String getExpiryMessage() {
        String message = null;
        int expiresIn = this.getExpiryDays();
        int warning = (Integer)Configs.get("beyondcron.license.expiry.warning");
        if (this.type == Type.EVALUATION) {
            warning = Math.min(warning, 7);
        }
        if (warning > 0 && expiresIn <= warning) {
            message = expiresIn > 1 ? Localise.format("License expires in %1$d days", expiresIn) : (expiresIn == 1 ? Localise.format("License expires tomorrow", expiresIn) : (expiresIn == 0 ? Localise.format("License expires today", expiresIn) : (expiresIn == -1 ? Localise.format("License expired yesterday", expiresIn) : Localise.format("License expired %1$d days ago", -expiresIn))));
        }
        return message;
    }

    public void setExpiry(Date expiry) {
        this.expiry = expiry;
    }

    private Date getEvalExpiry(Date epoch) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(epoch);
        cal.add(evalExpiryUnit, evalExpiryPeriod);
        return cal.getTime();
    }

    public boolean isExpired() {
        return new Date().after(this.expiry);
    }

    public int getMaxServers() {
        return this.getIntProperty(MAX_SERVERS, 1);
    }

    public long getMaxCalendars() {
        return this.getLongProperty(MAX_CALENDARS);
    }

    public long getMaxJobs() {
        return this.getLongProperty(MAX_JOBS);
    }

    public long getMaxExecutions() {
        return this.getLongProperty(MAX_EXECUTIONS);
    }

    public boolean isTestLicense() {
        return this.isProperty(TEST_LICENSE) ? this.getBooleanProperty(TEST_LICENSE, false) : false;
    }

    public License addProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public License addProperty(String name, boolean value) {
        this.properties.put(name, Boolean.toString(value));
        return this;
    }

    public License addProperty(String name, int value) {
        this.properties.put(name, Integer.toString(value));
        return this;
    }

    public License addProperty(String name, long value) {
        this.properties.put(name, Long.toString(value));
        return this;
    }

    public boolean isProperty(String name) {
        return this.properties.containsKey(name);
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public String getProperty(String name) {
        String value = this.properties.get(name);
        return value != null ? value : DEFAULTS.get(name);
    }

    public Map<String, String> getProperties() {
        TreeMap<String, String> p = new TreeMap<String, String>();
        for (String name : this.properties.keySet()) {
            if (name.equals(MAX_SERVERS) || name.equals(MAX_CALENDARS) || name.equals(MAX_JOBS) || name.equals(MAX_EXECUTIONS)) continue;
            String value = this.properties.get(name);
            if (BooleanUtils.isBoolean(value)) {
                p.put(Localise.format(name), BooleanUtils.toYesNo(value));
                continue;
            }
            if (value.equals("-1")) {
                p.put(Localise.format(name), Localise.format("Unlimited"));
                continue;
            }
            p.put(Localise.format(name), value);
        }
        return p;
    }

    public boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        if (!this.isProperty(name) && this.isActiveEvaluation()) {
            return true;
        }
        String value = this.getProperty(name);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    public int getIntProperty(String name) throws NumberFormatException {
        return this.getIntProperty(name, 0);
    }

    public int getIntProperty(String name, int defaultValue) throws NumberFormatException {
        if (!this.isProperty(name) && this.isActiveEvaluation()) {
            return Integer.MAX_VALUE;
        }
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        int i = Integer.parseInt(value);
        return i >= 0 ? i : Integer.MAX_VALUE;
    }

    public long getLongProperty(String name) throws NumberFormatException {
        return this.getLongProperty(name, 0L);
    }

    public long getLongProperty(String name, long defaultValue) throws NumberFormatException {
        if (!this.isProperty(name) && this.isActiveEvaluation()) {
            return Long.MAX_VALUE;
        }
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        return l >= 0L ? l : Long.MAX_VALUE;
    }

    public void setEvalEpoch(Date epoch) {
        if (epoch.after(this.epoch)) {
            this.epoch = epoch;
            this.expiry = this.getEvalExpiry(epoch);
            this.valid = this.expiry.getTime() > 0L;
            String string = this.reason = this.valid ? null : Localise.format("Invalid expiry date");
        }
        if (this.isExpired()) {
            this.reset();
        }
    }

    public void setEvalExpiryUnit(int unit) {
        evalExpiryUnit = unit;
        this.expiry = this.getEvalExpiry(this.epoch);
    }

    public void setEvalExpiryPeriod(int period) {
        evalExpiryPeriod = period;
        this.expiry = this.getEvalExpiry(this.epoch);
    }

    public License reset() {
        for (String name : DEFAULTS.keySet()) {
            this.properties.remove(name);
        }
        if (this.type == Type.EVALUATION && this.isExpired()) {
            this.type = Type.FREE;
            this.issued = this.expiry;
            this.expiry = new Date(Long.MAX_VALUE);
        }
        return this;
    }

    public String getHash() {
        StringBuilder sb = new StringBuilder();
        sb.append("96C8wr7TCZJAkp9mBmWj");
        sb.append(this.type.toString());
        sb.append(this.expiry.getTime());
        sb.append(this.licensee);
        if (this.instance != null) {
            sb.append(this.instance);
        }
        for (String name : this.properties.keySet()) {
            sb.append(name);
            sb.append(this.properties.get(name));
        }
        return StringUtils.hashString(sb.toString().toLowerCase());
    }

    public boolean setSignature(String signature) {
        boolean valid = this.verifySignature(signature);
        if (valid) {
            this.signature = signature;
        }
        return valid;
    }

    public boolean hasSignature() {
        return !StringUtils.isNullOrEmpty(this.signature);
    }

    public boolean verifySignature() {
        return this.verifySignature(this.signature);
    }

    public boolean verifySignature(String signature) {
        try {
            Signature sig = Signature.getInstance(SIGNATURE_ALGORITHM);
            sig.initVerify(publicKey);
            sig.update(this.getSignatureMessage().getBytes());
            return sig.verify(Base64.getMimeDecoder().decode(signature));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            Localise.logWarn(logger, "Error validating signature: %1$s", e.getMessage());
            return false;
        }
    }

    public String getSignatureMessage() {
        ArrayList<String> items = new ArrayList<String>();
        items.add(String.format(itemFormat, JSON_LICENSEE, this.licensee));
        items.add(String.format(itemFormat, JSON_TYPE, this.type.toString()));
        if (this.isProperty(MAX_JOBS)) {
            items.add(String.format(itemFormat, JSON_JOBS, this.getMaxJobs()));
        }
        if (this.isProperty(MAX_EXECUTIONS)) {
            items.add(String.format(itemFormat, JSON_EXECUTIONS, this.getMaxExecutions()));
        }
        items.add(String.format(itemFormat, JSON_SERVERS, this.getMaxServers()));
        items.add(String.format(itemFormat, JSON_INSTANCE, this.instance));
        if (this.issued != null) {
            items.add(String.format(itemFormat, JSON_ISSUED, TimeUtils.getLocalDateTime(this.issued).format(expiryFormatter)));
        }
        items.add(String.format(itemFormat, JSON_EXPIRES, TimeUtils.getLocalDateTime(this.expiry).format(expiryFormatter)));
        if (this.isTestLicense()) {
            items.add(String.format(itemFormat, JSON_TEST, "true"));
        }
        Collections.sort(items);
        return StringUtils.join(";", items).toLowerCase().replaceAll("\\s+", "");
    }

    public String toString() {
        return this.toTable().toString();
    }

    public TableFormatter toTable() {
        TableFormatter table = new TableFormatter();
        table.displayHeader(false);
        table.alignColumn(0, TableFormatter.Column.Align.RIGHT);
        if (this.type != Type.EVALUATION && this.type != Type.FREE || !StringUtils.isNullOrEmpty(this.licensee)) {
            table.addRow(Localise.format(JSON_LICENSEE), this.licensee);
        }
        ArrayList<String> l = new ArrayList<String>();
        if (this.isDefaultLicense()) {
            l.add("default");
        }
        if (this.isTestLicense()) {
            l.add(JSON_TEST);
        }
        if (l.isEmpty()) {
            table.addRow(Localise.format(JSON_TYPE), StringUtils.capitalise((Object)this.type));
        } else {
            table.addRow(Localise.format(JSON_TYPE), Localise.format("%1$s (%2$s)", StringUtils.capitalise((Object)this.type), StringUtils.join(" ", l)));
        }
        long i = this.getMaxCalendars();
        if (i < Long.MAX_VALUE) {
            table.addRow(Localise.format(MAX_CALENDARS), NumberUtils.toString(i, null, Localise.format("Unlimited")));
        }
        table.addRow(Localise.format(MAX_JOBS), NumberUtils.toString(this.getMaxJobs(), null, Localise.format("Unlimited")));
        i = this.getMaxExecutions();
        if (i < Long.MAX_VALUE) {
            table.addRow(Localise.format(MAX_EXECUTIONS), NumberUtils.toString(i, null, Localise.format("Unlimited")));
        }
        table.addRow(Localise.format(MAX_SERVERS), NumberUtils.toString(this.getMaxServers(), null, Localise.format("Unlimited")));
        if (!StringUtils.isNullOrEmpty(this.instance)) {
            table.addRow(Localise.format(JSON_INSTANCE), this.instance);
        }
        if (this.issued != null && this.issued.getTime() > 0L) {
            table.addRow(Localise.format(JSON_ISSUED), TimeUtils.getLocalDateTime(this.issued).format(expiryFormatter));
        }
        if (this.expiry != null && this.expiry.getTime() < Long.MAX_VALUE) {
            table.addRow(Localise.format(this.isExpired() ? "expired" : JSON_EXPIRES), TimeUtils.getLocalDateTime(this.expiry).format(expiryFormatter));
        }
        if (this.isTestLicense()) {
            table.addRow(Localise.format(JSON_TEST), true);
        }
        if (!this.properties.isEmpty()) {
            TableFormatter tbl = new TableFormatter();
            tbl.displayHeader(false);
            tbl.alignColumn(0, TableFormatter.Column.Align.RIGHT);
            tbl.setColumnSeparator(": ");
            Map<String, String> p = this.getProperties();
            if (!p.isEmpty()) {
                Iterator<String> iterator = p.keySet().iterator();
                block11: while (iterator.hasNext()) {
                    String k;
                    switch (k = iterator.next()) {
                        case "defaultLicense": 
                        case "maxCalendars": 
                        case "maxJobs": 
                        case "maxExecutions": 
                        case "maxServers": 
                        case "testLicense": {
                            continue block11;
                        }
                    }
                    tbl.addRow(k, p.get(k));
                }
                if (tbl.getRowCount() > 0) {
                    table.startRow();
                    table.addValue(Localise.format("Properties"));
                    table.addValue((Object)tbl.toString(), false);
                    table.endRow();
                }
            }
        }
        if (this.file != null) {
            table.addRow(Localise.format("file"), this.file.toPath());
        }
        return table;
    }

    @Override
    public JSONObject toJSON() {
        long servers;
        long jobs;
        JSONObject json = new JSONObject();
        if (!StringUtils.isNullOrEmpty(this.licensee)) {
            json.put(JSON_LICENSEE, this.licensee);
        }
        json.put(JSON_TYPE, this.type.toString());
        long calendars = this.getMaxCalendars();
        if (calendars != Long.MAX_VALUE) {
            json.put(JSON_CALENDARS, calendars);
        }
        json.put(JSON_JOBS, (jobs = this.getMaxJobs()) != Long.MAX_VALUE ? jobs : -1L);
        long executions = this.getMaxExecutions();
        if (executions != Long.MAX_VALUE) {
            json.put(JSON_EXECUTIONS, executions);
        }
        json.put(JSON_SERVERS, (servers = (long)this.getMaxServers()) != Long.MAX_VALUE ? servers : -1L);
        if (!StringUtils.isNullOrEmpty(this.instance)) {
            json.put(JSON_INSTANCE, this.instance);
        }
        if (this.issued != null && this.issued.getTime() > 0L) {
            json.put(JSON_ISSUED, TimeUtils.getLocalDateTime(this.issued).format(expiryFormatter));
        }
        json.put(JSON_EXPIRES, TimeUtils.getLocalDateTime(this.expiry).format(expiryFormatter));
        json.put(JSON_VALID, this.valid);
        if (this.isTestLicense()) {
            json.put(JSON_TEST, true);
        }
        JSONObject props = new JSONObject();
        Iterator<String> iterator = this.properties.keySet().iterator();
        block10: while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "maxCalendars": 
                case "maxJobs": 
                case "maxExecutions": 
                case "maxServers": 
                case "testLicense": {
                    continue block10;
                }
            }
            props.put(key, this.properties.get(key));
        }
        if (props.length() > 0) {
            json.put(JSON_PROPERTIES, props);
        }
        json.put(JSON_SIGNATURE, this.signature);
        JSONObject p = new JSONObject();
        for (String name : this.properties.keySet()) {
            String value = this.properties.get(name);
            if (BooleanUtils.isBoolean(value)) {
                p.put(name, Boolean.valueOf(value));
                continue;
            }
            if (NumberUtils.isLong(value)) {
                p.put(name, Long.parseLong(value));
                continue;
            }
            if (NumberUtils.isDouble(value)) {
                p.put(name, Double.parseDouble(value));
                continue;
            }
            p.put(name, value);
        }
        return json;
    }

    @Override
    public License fromJSON(JSONObject data) throws IllegalArgumentException {
        this.type = null;
        this.licensee = null;
        this.instance = null;
        this.issued = null;
        this.expiry = null;
        this.valid = false;
        this.signature = null;
        this.properties.clear();
        block48: for (String key : data.keySet()) {
            switch (key.toLowerCase()) {
                case "type": {
                    try {
                        this.type = Type.valueOf(data.getString(key).toUpperCase());
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(Localise.format("Illegal %s - %s", JSON_TYPE, data.getString(key)));
                    }
                }
                case "licensee": {
                    this.licensee = data.getString(key);
                    break;
                }
                case "instance": {
                    this.instance = data.getString(key);
                    break;
                }
                case "issued": {
                    try {
                        this.issued = TimeUtils.getDate(LocalDate.from(expiryFormatter.parse(data.getString(key))));
                        break;
                    }
                    catch (JSONException e) {
                        throw new IllegalArgumentException(Localise.format("Illegal %s - %s", key, data.getString(key)));
                    }
                }
                case "expires": {
                    try {
                        this.expiry = TimeUtils.getDate(LocalDate.from(expiryFormatter.parse(data.getString(key))));
                        break;
                    }
                    catch (JSONException e) {
                        throw new IllegalArgumentException(Localise.format("Illegal %s - %s", key, data.getString(key)));
                    }
                }
                case "expiry": {
                    try {
                        this.expiry = new Date(data.getLong(key));
                        break;
                    }
                    catch (JSONException e) {
                        throw new IllegalArgumentException(Localise.format("Illegal %s - %s", key, data.getString(key)));
                    }
                }
                case "valid": {
                    this.valid = data.getBoolean(key);
                    break;
                }
                case "calendars": {
                    try {
                        this.addProperty(MAX_CALENDARS, data.getLong(key));
                        break;
                    }
                    catch (JSONException e) {
                        throw new IllegalArgumentException(Localise.format("Illegal %s - %s", key, data.getString(key)));
                    }
                }
                case "jobs": {
                    try {
                        this.addProperty(MAX_JOBS, data.getLong(key));
                        break;
                    }
                    catch (JSONException e) {
                        throw new IllegalArgumentException(Localise.format("Illegal %s - %s", key, data.getString(key)));
                    }
                }
                case "executions": {
                    try {
                        this.addProperty(MAX_EXECUTIONS, data.getLong(key));
                        break;
                    }
                    catch (JSONException e) {
                        throw new IllegalArgumentException(Localise.format("Illegal %s - %s", key, data.getString(key)));
                    }
                }
                case "servers": {
                    try {
                        this.addProperty(MAX_SERVERS, data.getLong(key));
                        break;
                    }
                    catch (JSONException e) {
                        throw new IllegalArgumentException(Localise.format("Illegal %s - %s", key, data.getString(key)));
                    }
                }
                case "test": {
                    this.addProperty(TEST_LICENSE, data.getBoolean(key));
                    break;
                }
                case "signature": {
                    this.signature = data.getString(key);
                    break;
                }
                case "properties": {
                    JSONObject p = data.getJSONObject(JSON_PROPERTIES);
                    for (String k : p.keySet()) {
                        this.properties.put(k, p.get(k).toString());
                    }
                    continue block48;
                }
                default: {
                    throw new IllegalArgumentException(Localise.format("Unsupported value: %s - %s", key, data.get(key).toString()));
                }
            }
        }
        if (this.type == null) {
            throw new IllegalArgumentException(Localise.format("Missing %s field", JSON_TYPE));
        }
        if (this.expiry == null) {
            throw new IllegalArgumentException(Localise.format("Missing %s field", JSON_EXPIRY));
        }
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoLicense.License.Builder toProto() {
        ProtoLicense.License.Builder builder = ProtoLicense.License.newBuilder();
        builder.setType(this.type.toProto());
        builder.setExpiry(this.expiry.getTime());
        if (this.issued != null) {
            builder.setIssued(this.issued.getTime());
        }
        if (!StringUtils.isNullOrEmpty(this.licensee)) {
            builder.setLicensee(this.licensee);
        }
        if (!StringUtils.isNullOrEmpty(this.instance)) {
            builder.setInstance(this.instance);
        }
        builder.setValid(this.valid);
        for (String name : this.properties.keySet()) {
            ProtoProperty.Property.Builder property = ProtoProperty.Property.newBuilder();
            String value = this.properties.get(name);
            property.setName(name);
            if (value != null && value.length() > 0) {
                property.setValue(value);
            }
            builder.addProperty(property);
        }
        return builder;
    }

    @Override
    public License fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoLicense.License proto = ProtoLicense.License.parseFrom(data);
        this.type = Type.fromProto(proto.getType());
        this.expiry = new Date(proto.getExpiry());
        this.issued = proto.hasIssued() ? new Date(proto.getIssued()) : new Date(0L);
        this.licensee = proto.hasLicensee() ? proto.getLicensee() : null;
        this.instance = proto.hasInstance() ? proto.getInstance() : null;
        this.valid = proto.getValid();
        this.properties.clear();
        for (ProtoProperty.Property property : proto.getPropertyList()) {
            this.properties.put(property.getName(), property.hasValue() ? property.getValue() : null);
        }
        return this;
    }

    static {
        evalExpiryUnit = 2;
        evalExpiryPeriod = 1;
        expiryFormatter = DateTimeFormatter.ofPattern("d MMM yyy", Locale.US);
        DEFAULTS = new HashMap<String, String>();
        DEFAULTS.put(MAX_SERVERS, "1");
        DEFAULTS.put(MAX_CALENDARS, "-1");
        DEFAULTS.put(MAX_JOBS, "5");
        DEFAULTS.put(MAX_EXECUTIONS, "-1");
        DEFAULTS.put(JOB_FLOWS, "true");
        DEFAULTS.put(JOB_FLOW_WILDCARDS, "true");
        DEFAULTS.put(JOB_OUTPUT, "true");
        DEFAULTS.put(COMMAND_JOBS, "true");
        DEFAULTS.put(CONTAINER_JOBS, "true");
        DEFAULTS.put(CUSTOM_JOBS, "true");
        DEFAULTS.put(MESSAGE_JOBS, "true");
        DEFAULTS.put(SQL_JOBS, "true");
        DEFAULTS.put(TRIGGER_JOBS, "true");
        DEFAULTS.put(URL_JOBS, "true");
        Localise.addBundle("License");
        byte[] publicKeyBytes = Base64.getMimeDecoder().decode(PUBLIC_KEY.getBytes(StandardCharsets.UTF_8));
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKeyBytes);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            publicKey = keyFactory.generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            Localise.logFatal(logger, e, "Could not initialise public key", new Object[0]);
            Program.exit(1);
        }
    }

    public static enum Type {
        EVALUATION(false),
        PERPETUAL(false),
        SUBSCRIPTION(true),
        USER(true),
        FREE(false);

        private boolean hardExpiry;
        static EnumMap<Type, ProtoLicense.License.Type> typeMap;

        private Type(boolean hardExpiry) {
            this.hardExpiry = hardExpiry;
        }

        public boolean hasHardExpiry() {
            return this.hardExpiry;
        }

        public static Type fromProto(ProtoLicense.License.Type type) {
            return typeMap.getA(type);
        }

        public ProtoLicense.License.Type toProto() {
            return typeMap.getB(this);
        }

        static {
            typeMap = new EnumMap<Type, ProtoLicense.License.Type>(Type.class, ProtoLicense.License.Type.class);
        }
    }
}

