/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.License;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Period;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoLimit;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.Duration;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.logging.log4j.Logger;

public class Limit
implements Comparable<Limit>,
Message<Limit> {
    static final Logger logger = LogUtils.getLogger(Limit.class);
    private static final String MESSAGE_TAG = "limit";
    private static final long dayMilliSeconds = Period.Unit.DAY.getMilliseconds(1L);
    private static long nextExecutionsEpoch;
    protected long maxCalendars;
    protected long maxJobs;
    protected long maxExecutions;
    private boolean hasLimits;
    private long executionsEpoch = 0L;
    private long lastExecutionsEpoch = 0L;
    private long calendars = 0L;
    private long jobs = 0L;
    private long executions = 0L;

    public Limit() {
    }

    public Limit(License license) {
        this.executionsEpoch = Limit.getNextExecutionsEpoch();
        this.lastExecutionsEpoch = this.executionsEpoch - dayMilliSeconds;
        this.setLicense(license);
    }

    public Limit(Limit limit) {
        this.executionsEpoch = limit.executionsEpoch;
        this.lastExecutionsEpoch = limit.lastExecutionsEpoch;
        this.maxCalendars = limit.maxCalendars;
        this.maxJobs = limit.maxJobs;
        this.maxExecutions = limit.maxExecutions;
        this.hasLimits = limit.hasLimits;
        this.setCalendars(limit.getCalendars());
        this.setJobs(limit.getJobs());
        this.setExecutions(limit.getExecutions());
    }

    public void setLicense(License license) {
        this.maxCalendars = license.getMaxCalendars();
        this.maxJobs = license.getMaxJobs();
        this.maxExecutions = license.getMaxExecutions();
        this.hasLimits = this.maxCalendars != Long.MAX_VALUE || this.maxJobs != Long.MAX_VALUE || this.maxExecutions != Long.MAX_VALUE;
    }

    public boolean hasLimits() {
        return this.hasLimits;
    }

    public long getCalendars() {
        return this.calendars;
    }

    public void setCalendars(long calendars) {
        this.calendars = calendars;
    }

    public boolean addCalendar() {
        if (this.calendars < this.maxCalendars) {
            ++this.calendars;
            return true;
        }
        return false;
    }

    public boolean removeCalendar() {
        if (this.calendars > 0L) {
            --this.calendars;
            return true;
        }
        return false;
    }

    public long getMaxCalendars() {
        return this.maxCalendars;
    }

    public long getJobs() {
        return this.jobs;
    }

    public void setJobs(long jobs) {
        this.jobs = jobs;
    }

    public boolean addJob() {
        if (this.jobs < this.maxJobs) {
            ++this.jobs;
            return true;
        }
        return false;
    }

    public boolean removeJob() {
        if (this.jobs > 0L) {
            --this.jobs;
            return true;
        }
        return false;
    }

    public long getMaxJobs() {
        return this.maxJobs;
    }

    public long getExecutions() {
        return this.executions;
    }

    public long setExecutions(long executions) {
        this.executions = executions;
        return this.executions;
    }

    public long incrementExecutions() {
        return ++this.executions;
    }

    public boolean execute(String userName) {
        long execs;
        long now = System.currentTimeMillis();
        if (now < this.executionsEpoch) {
            execs = this.incrementExecutions();
            if (execs == this.maxExecutions) {
                this.logExecutions(userName, execs, this.lastExecutionsEpoch);
            }
        } else {
            execs = this.getExecutions();
            this.logExecutions(userName, execs, this.lastExecutionsEpoch);
            this.executionsEpoch = Limit.getNextExecutionsEpoch();
            execs = this.setExecutions(1L);
        }
        return execs <= this.maxExecutions;
    }

    public long getMaxExecutions() {
        return this.maxExecutions;
    }

    public long getExecutionsEpoch() {
        long epoch = this.executionsEpoch;
        long now = System.currentTimeMillis();
        if (epoch < now) {
            while (epoch < now) {
                epoch += dayMilliSeconds;
            }
            this.setExecutions(0L);
        }
        return epoch;
    }

    public void resetExecutionCounter() {
        this.setExecutions(0L);
    }

    protected void logExecutions(String userName, long executions, long epochStart) {
        if (executions >= this.maxExecutions) {
            Duration duration = Duration.ofMillis(System.currentTimeMillis() - epochStart);
            long hours = duration.toHours();
            duration = duration.minusHours(hours);
            long minutes = duration.toMinutes();
            duration = duration.minusMinutes(minutes);
            long seconds = duration.getSeconds();
            Localise.logInfo(logger, "  limited: %s executed %d/%s jobs over %02d:%02d:%02d", userName, executions, this.maxExecutions != Long.MAX_VALUE ? Long.toString(this.maxExecutions) : "*", hours, minutes, seconds);
        } else {
            Localise.logInfo(logger, "unlimited: %s executed %d/%s jobs over 24:00:00", userName, executions, this.maxExecutions != Long.MAX_VALUE ? Long.toString(this.maxExecutions) : "*");
        }
    }

    public static String format(long value, long maxValue) {
        if (maxValue == Long.MAX_VALUE) {
            return String.format("%d/*", value);
        }
        return String.format("%d/%d", value, maxValue);
    }

    public static String formatHtml(long value, long maxValue) {
        if (maxValue == Long.MAX_VALUE) {
            return String.format("<span>%d/&infin;</span>", value);
        }
        return String.format("<span>%d/%d</span>", value, maxValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Limit)) {
            return false;
        }
        return this.compareTo((Limit)obj) == 0;
    }

    @Override
    public int compareTo(Limit that) {
        int i = Long.compare(this.maxCalendars, that.maxCalendars);
        if (i != 0) {
            return i;
        }
        i = Long.compare(this.maxJobs, that.maxJobs);
        if (i != 0) {
            return i;
        }
        return Long.compare(this.maxExecutions, that.maxExecutions);
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoLimit.Limit.Builder toProto() {
        long executions;
        long jobs;
        long calendars;
        ProtoLimit.Limit.Builder builder = ProtoLimit.Limit.newBuilder();
        if (this.maxCalendars > 0L) {
            builder.setMaxCalendars(this.maxCalendars);
        }
        if (this.maxJobs > 0L) {
            builder.setMaxJobs(this.maxJobs);
        }
        if (this.maxExecutions > 0L) {
            builder.setMaxExecutions(this.maxExecutions);
        }
        if ((calendars = this.getCalendars()) > 0L) {
            builder.setCalendars(calendars);
        }
        if ((jobs = this.getJobs()) > 0L) {
            builder.setJobs(jobs);
        }
        if ((executions = this.getExecutions()) > 0L) {
            builder.setExecutions(executions);
        }
        builder.setExecutionsEpoch(this.executionsEpoch);
        builder.setLastExecutionsEpoch(this.lastExecutionsEpoch);
        return builder;
    }

    @Override
    public Limit fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoLimit.Limit proto = ProtoLimit.Limit.parseFrom(data);
        this.maxCalendars = proto.getMaxCalendars();
        this.maxJobs = proto.getMaxJobs();
        this.maxExecutions = proto.getMaxExecutions();
        this.setCalendars(proto.getCalendars());
        this.setJobs(proto.getJobs());
        this.setExecutions(proto.getExecutions());
        this.executionsEpoch = proto.getExecutionsEpoch();
        this.lastExecutionsEpoch = proto.getLastExecutionsEpoch();
        return this;
    }

    public static long getNextExecutionsEpoch() {
        long now = System.currentTimeMillis();
        if (now > nextExecutionsEpoch) {
            nextExecutionsEpoch += dayMilliSeconds;
        }
        return nextExecutionsEpoch;
    }

    static {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        ((Calendar)cal).add(5, 1);
        nextExecutionsEpoch = cal.getTimeInMillis();
    }
}

