/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Localise;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogUtils {
    public static final String LOG4J_CONFIGURATION_FILE_PROPERTY = "log4j.configurationFile";
    public static final String LOG4J_CONFIGURATION_FILE_ENV = "LOG4J_CONFIGURATION_FILE";
    public static final String LOG4J_YAML = "log4j2.yaml";
    private static URL configURL = null;

    public static URL getConfigURL() {
        return configURL;
    }

    public static Logger getLogger(Class<?> clazz) {
        return LogManager.getLogger(clazz);
    }

    public static Logger getLogger(String name) {
        return LogManager.getLogger((String)name);
    }

    public static void consolePrint(Logger logger, String message) {
        if (logger.isInfoEnabled()) {
            logger.info(message);
        } else {
            System.out.println(message);
        }
    }

    public static void consolePrintConfigURL(Logger logger) {
        if (configURL != null) {
            if (configURL.getProtocol().equalsIgnoreCase("file")) {
                LogUtils.consolePrint(logger, Localise.format("Logging config: %1$s", configURL.getPath()));
            } else {
                LogUtils.consolePrint(logger, Localise.format("Logging config: %1$s", configURL.toString()));
            }
        } else {
            LogUtils.consolePrint(logger, Localise.format("Logging config: log4j2 default"));
        }
    }

    private static URL getResource(String name) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = null;
        String programName = System.getProperty("program.name");
        if (programName == null || programName.isEmpty()) {
            programName = System.getenv("PROGRAM_NAME");
        }
        if (programName != null && !programName.isEmpty()) {
            url = classLoader.getResource(programName + "-" + name);
        }
        return url != null ? url : classLoader.getResource(name);
    }

    private static void copyResource(String name, File target) throws IOException {
        int length;
        URL url = LogUtils.getResource(name);
        if (url == null) {
            throw new IOException(name + " not a system resource");
        }
        InputStream in = url.openStream();
        if (target.exists()) {
            if (!target.isFile()) {
                throw new IOException(target + " not a file");
            }
            if (!target.canWrite()) {
                throw new IOException("cannot write " + target);
            }
        }
        FileOutputStream out = new FileOutputStream(target);
        byte[] buffer = new byte[1024];
        while ((length = in.read(buffer)) >= 0) {
            ((OutputStream)out).write(buffer, 0, length);
        }
        in.close();
        ((OutputStream)out).close();
    }

    static {
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        String configName = System.getProperty(LOG4J_CONFIGURATION_FILE_PROPERTY);
        if (configName == null || configName.isEmpty()) {
            configName = System.getenv(LOG4J_CONFIGURATION_FILE_ENV);
        }
        File configFile = null;
        if (configName != null && !configName.isEmpty()) {
            try {
                configURL = new URL(configName);
            }
            catch (MalformedURLException e) {
                try {
                    configURL = new File(configName).toURI().toURL();
                }
                catch (MalformedURLException ex) {
                    System.err.printf("Cannot create log4j configuration URL from %1$s, using defaults - %2$s%n", configName, ex.getMessage());
                }
            }
            if (configURL != null && configURL.getProtocol().equalsIgnoreCase("file")) {
                configFile = new File(configURL.getPath());
                if (!configFile.exists()) {
                    File configDir = configFile.getParentFile();
                    if (configDir.exists() && configDir.canWrite()) {
                        try {
                            configFile.createNewFile();
                        }
                        catch (IOException e) {
                            System.err.printf("Cannot create log4j configuration file %1$s, using defaults.%n", configName);
                            configURL = null;
                        }
                    }
                } else if (!configFile.canRead()) {
                    System.err.printf("Cannot read log4j properties file %s, using defaults.%n", configName);
                    configURL = null;
                }
            }
        }
        if (configFile != null && configFile.getName().equals(LOG4J_YAML) && configFile.exists() && configFile.length() == 0L && configFile.canWrite()) {
            try {
                LogUtils.copyResource(LOG4J_YAML, configFile);
            }
            catch (IOException e) {
                System.err.printf("Could not initialise log4j configuration file %1$s - %2$s%n", configFile.toPath(), e.getMessage());
            }
        }
        if (configURL == null) {
            configURL = LogUtils.getResource(LOG4J_YAML);
        }
        if (configURL != null) {
            System.setProperty(LOG4J_CONFIGURATION_FILE_PROPERTY, configURL.toString());
        }
    }
}

