/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Name;
import com.beyondcron.core.StringUtils;
import java.net.URISyntaxException;
import java.util.ArrayList;

public class NameUtils {
    public static boolean hasDisplayName(Name name) {
        return NameUtils.hasDisplayName(name.toString());
    }

    public static boolean hasDisplayName(String name) {
        return name.contains(":");
    }

    public static String getDisplayName(Name name) {
        StringBuilder sb = new StringBuilder();
        for (String s : name.toString().substring(1).split("\\/")) {
            sb.append('/').append(NameUtils.getDisplayName(s));
        }
        return sb.toString();
    }

    public static String getDisplayName(String name) {
        String s = name;
        int i = s.lastIndexOf(":");
        return ++i > 0 && i < s.length() ? s.substring(0, --i) : s;
    }

    public static Name getCanonicalName(Name name) {
        try {
            return new Name(NameUtils.getCanonicalPath(name.getPath()));
        }
        catch (URISyntaxException e) {
            return name;
        }
    }

    public static String getCanonicalPath(String path) {
        if (((String)path).contains("//")) {
            path = ((String)path).replaceAll("//+", "/");
        }
        if (((String)path).contains("/./") || ((String)path).endsWith("/.") || ((String)path).contains("/../") || ((String)path).endsWith("/..")) {
            ArrayList<String> tokens = new ArrayList<String>();
            for (String token : ((String)path).split("/")) {
                if (token.length() == 0 || token.equals(".")) continue;
                if (token.equals("..")) {
                    int i = tokens.size() - 1;
                    if (i < 0) continue;
                    tokens.remove(i);
                    continue;
                }
                tokens.add(token);
            }
            path = "/" + StringUtils.join("/", tokens);
        }
        return path;
    }
}

