/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Configs;
import com.beyondcron.core.InetSocketAddress;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.Program;
import com.beyondcron.core.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;

public class NetUtils {
    static final Logger logger = LogUtils.getLogger(NetUtils.class);
    public static final String CHARSET = "UTF-8";
    public static final String ECHO_HOST = "example.com";
    public static final String ECHO_DOMAIN = ".example.com";
    public static final String SCHEME_FILE = "file";
    private static String defaultHostName = "localhost";
    private static int defaultPort = 0;
    static final Pattern regexHostName = Pattern.compile(".+//(.+?)[:/].*");
    static final Pattern regexInetSocketAddress = Pattern.compile("([^:]+)?(:([0-9]+))?");
    private static final String pingCommand = (String)Configs.get("BEYONDCRON_PING_COMMAND");
    private static final Period pingTimeout = (Period)Configs.get("BEYONDCRON_PING_TIMEOUT");
    private static Set<InetAddress> localAddresses = null;
    private static String hostName = null;

    public static String getHostName() {
        if (hostName == null) {
            try {
                hostName = InetAddress.getLocalHost().getHostName().toLowerCase();
            }
            catch (UnknownHostException e) {
                Localise.logError(Localise.logger, e, "could not get host name", new Object[0]);
                hostName = "unknown";
            }
        }
        return hostName;
    }

    public static String getUnqualifiedHostName() {
        return NetUtils.getUnqualifiedHostName(NetUtils.getHostName());
    }

    public static String getUnqualifiedHostName(String hostName) {
        int i = hostName.indexOf(46);
        if (i < 0) {
            return hostName;
        }
        if (Program.getOs() == Program.OS.MACOSX && hostName.endsWith(".local")) {
            return hostName;
        }
        return hostName.substring(0, i);
    }

    static String getDefaultHostName() {
        return defaultHostName;
    }

    public static void setDefaultHostName(String hostName) {
        defaultHostName = hostName;
    }

    static int getDefaultPort() {
        return defaultPort;
    }

    public static void setDefaultPort(int port) {
        defaultPort = port;
    }

    public static InetSocketAddress parseInetSocketAddress(String value) {
        String hostname = defaultHostName;
        int port = defaultPort;
        Matcher m = regexInetSocketAddress.matcher(value);
        if (!m.matches()) {
            throw new IllegalArgumentException(Localise.format("%s is not a valid address", value));
        }
        if (m.group(1) != null) {
            hostname = m.group(1);
        }
        if (m.group(3) != null) {
            try {
                port = Integer.parseInt(m.group(3));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(Localise.format("%s in %s is not a valid port", m.group(3), value));
            }
        }
        return new InetSocketAddress(hostname, port);
    }

    public static URI parseURI(String value) {
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URI parseURI(String value, String defaultScheme) {
        try {
            URI uri = new URI(value);
            if (uri.getScheme() == null) {
                uri = new URI(defaultScheme + ":" + value);
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URI parseURI(String value, String oldScheme, String newScheme) {
        return value.startsWith(oldScheme + ":") ? NetUtils.parseURI(value.replace(oldScheme, newScheme)) : NetUtils.parseURI(value);
    }

    public static String getHost(URI url) {
        Matcher m;
        String host = url.getHost();
        if (host == null && (m = regexHostName.matcher(url.toString())).matches()) {
            host = m.group(1);
        }
        return host;
    }

    public static String getHost(URL url) {
        return url.getHost();
    }

    public static boolean isEchoEmail(String email) {
        if (email == null) {
            return false;
        }
        int i = email.indexOf("@");
        return ++i > 0 && NetUtils.isEchoHost(email.substring(i));
    }

    public static boolean isEchoHost(String host) {
        String s = host != null ? host.toLowerCase() : "";
        return s.equals(ECHO_HOST) || s.endsWith(ECHO_DOMAIN);
    }

    public static boolean isEchoHost(URI url) {
        return NetUtils.isEchoHost(NetUtils.getHost(url));
    }

    public static boolean isEchoHost(URL url) {
        return NetUtils.isEchoHost(NetUtils.getHost(url));
    }

    public static String getParameterString(Map<String, String> values) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String name : values.keySet()) {
            if (++i > 1) {
                sb.append('&');
            }
            sb.append(NetUtils.encode(name)).append('=').append(NetUtils.encode(values.get(name)));
        }
        return sb.toString();
    }

    public static Map<String, String> parseQuery(String query) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!StringUtils.isNullOrEmpty(query)) {
            for (String param : query.split("&")) {
                int i = param.indexOf(61);
                if (i < 0) {
                    params.put(NetUtils.decode(param), "");
                    continue;
                }
                params.put(NetUtils.decode(param.substring(0, i)), NetUtils.decode(param.substring(++i)));
            }
        }
        return params;
    }

    public static Map<String, String> parseQuery(URI url) {
        return NetUtils.parseQuery(NetUtils.getQuery(url));
    }

    public static Map<String, String> parseQuery(URL url) {
        return NetUtils.parseQuery(NetUtils.getQuery(url));
    }

    public static URI stripQuery(URI url) {
        String query = NetUtils.getQuery(url);
        if (query != null) {
            try {
                return new URI(url.toString().replace("?" + query, ""));
            }
            catch (URISyntaxException e) {
                Localise.logError(logger, "could not strip query from - %s - %s", url.toString(), e.getMessage());
            }
        }
        return url;
    }

    public static URL stripQuery(URL url) {
        String query = NetUtils.getQuery(url);
        if (query != null) {
            try {
                return new URL(url.toString().replace("?" + query, ""));
            }
            catch (MalformedURLException e) {
                Localise.logError(logger, "could not strip query from - %s - %s", url.toString(), e.getMessage());
            }
        }
        return url;
    }

    public static String getQuery(URI url) {
        String urlString;
        int queryStart;
        if (url != null && (queryStart = (urlString = url.toString()).indexOf("?") + 1) > 0) {
            int queryEnd = urlString.indexOf("#", queryStart);
            if (queryEnd > queryStart) {
                return urlString.substring(queryStart, queryEnd);
            }
            return urlString.substring(queryStart);
        }
        return null;
    }

    public static String getQuery(URL url) {
        return url != null ? url.getQuery() : null;
    }

    public static String toString(InetSocketAddress socket) {
        return socket.getPort() > 0 ? socket.getHostName().toLowerCase() + ":" + socket.getPort() : socket.getHostName().toLowerCase();
    }

    public static String decode(String value) {
        try {
            return URLDecoder.decode(value, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            Localise.logError(logger, "decoding - %s - %s", value, e.getMessage());
            return "";
        }
    }

    public static String encode(String value) {
        try {
            return URLEncoder.encode(value, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            Localise.logError(logger, "encoding - %s - %s", value, e.getMessage());
            return "";
        }
    }

    public static String decodeBraces(String value) {
        return value != null ? value.replace("%7B", "{").replace("%7D", "}").replace("%20", " ") : "";
    }

    public static String encodeBraces(String value) {
        return value != null ? value.replace("{", "%7B").replace("}", "%7D").replace(" ", "%20") : "";
    }

    public static String appendPath(URI uri, String path) {
        Object s = uri.toString();
        int i = ((String)s).indexOf(63);
        if (i >= 0) {
            s = ((String)s).substring(0, i);
        }
        if ((i = ((String)s).indexOf(35)) >= 0) {
            s = ((String)s).substring(0, i);
        }
        s = ((String)s).endsWith("/") && path.startsWith("/") ? (String)s + path.substring(1) : (String)s + path;
        return s;
    }

    public static Set<InetAddress> getLocalAddresses() {
        if (localAddresses == null) {
            localAddresses = new HashSet<InetAddress>();
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    Enumeration<InetAddress> addresses = interfaces.nextElement().getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        localAddresses.add(addresses.nextElement());
                    }
                }
            }
            catch (SocketException e) {
                Localise.logError(logger, "unexpected error getting network interfaces - %s", e.getMessage());
            }
        }
        return localAddresses;
    }

    public static boolean isLocalHost(String hostName) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(hostName);
        return NetUtils.getLocalAddresses().contains(address) || address.isLoopbackAddress();
    }

    public static boolean isLoopbackAddress(URI uri) {
        String hostName = uri.getHost();
        if (hostName != null) {
            try {
                return new InetSocketAddress(hostName, 0).getAddress().isLoopbackAddress();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception e) {
                Localise.logError(logger, "unexpected exception confirming if %s is a loopback address - %s", uri.getHost(), e.getMessage());
            }
        }
        return false;
    }

    public static boolean ping(InetAddress address) {
        return NetUtils.ping(address, pingTimeout);
    }

    public static boolean ping(InetAddress address, Period timeout) {
        String command = String.format(pingCommand, address.getHostAddress());
        try {
            Process ping = new ProcessBuilder(StringUtils.split(command)).start();
            if (ping.waitFor(timeout.getMilliseconds(), TimeUnit.MILLISECONDS)) {
                return ping.exitValue() == 0;
            }
            ping.destroy();
        }
        catch (IOException e) {
            Localise.logError(logger, e, "unexpected error executing command - %1$s", command);
        }
        catch (InterruptedException e) {
            Localise.logWarn(logger, "unexpectedly interrupted executing command - %1$s", command);
        }
        return false;
    }

    private static int getReachablePort() {
        return (Integer)Configs.get("beyondcron.host.reachable.port");
    }

    private static int getReachableTimeout() {
        return (int)((Period)Configs.get("beyondcron.host.reachable.timeout")).getMilliseconds();
    }

    public static boolean isReachable(String hostName) {
        try {
            return NetUtils.isReachable(InetAddress.getByName(hostName), NetUtils.getReachablePort(), NetUtils.getReachableTimeout());
        }
        catch (UnknownHostException e) {
            Localise.logWarn(logger, "unexpected exception in isReachable(%1$s) - %2$s", hostName, e.getMessage());
            return false;
        }
    }

    public static boolean isReachable(InetAddress address) {
        return NetUtils.isReachable(address, NetUtils.getReachablePort(), NetUtils.getReachableTimeout());
    }

    public static boolean isReachable(InetAddress address, int port, int timeout) {
        boolean bl;
        Socket soc = new Socket();
        try {
            soc.connect(new InetSocketAddress(address, port), timeout);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    soc.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return false;
            }
        }
        soc.close();
        return bl;
    }
}

