/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Localise;
import com.beyondcron.core.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberUtils {
    private static Pattern ordinalRegex = Pattern.compile("(-?[0-9]+)(st|nd|rd|th)?");

    public static String getOrdinalHybrid(int value) {
        return String.format("%d%s", value, NumberUtils.getOrdinalSuffix(value));
    }

    public static String getOrdinalSuffix(int value) {
        int i = value % 100;
        if (i >= 10 && i <= 20) {
            return "th";
        }
        switch (value % 10) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    public static boolean isInt(String value) {
        boolean number = true;
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            number = false;
        }
        return number;
    }

    public static int parseInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean isLong(String value) {
        boolean number = true;
        try {
            Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            number = false;
        }
        return number;
    }

    public static long parseLong(String value, long defaultValue) {
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean isFloat(String value) {
        boolean number = true;
        try {
            Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            number = false;
        }
        return number;
    }

    public static float parseFloat(String value, float defaultValue) {
        try {
            return Float.parseFloat(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean isDouble(String value) {
        boolean number = true;
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            number = false;
        }
        return number;
    }

    public static double parseDouble(String value, double defaultValue) {
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int parseOrdinal(String value) throws NumberFormatException {
        Matcher m = ordinalRegex.matcher(value);
        if (!m.matches()) {
            throw new NumberFormatException(Localise.format("%s is not an ordinal number", value));
        }
        int i = Integer.parseInt(m.group(1));
        String suffix = m.group(2);
        if (suffix != null) {
            String requiredSuffix;
            switch (i % 10) {
                case 1: {
                    requiredSuffix = "st";
                    break;
                }
                case 2: {
                    requiredSuffix = "nd";
                    break;
                }
                case 3: {
                    requiredSuffix = "rd";
                    break;
                }
                default: {
                    requiredSuffix = "th";
                }
            }
            if (!suffix.equals(requiredSuffix)) {
                throw new NumberFormatException(Localise.format("%s has an incompatible suffix"));
            }
        }
        return i;
    }

    public static String toString(int value, String minName, String maxName) {
        if (value == Integer.MIN_VALUE && !StringUtils.isNullOrEmpty(minName)) {
            return minName;
        }
        if (value == Integer.MAX_VALUE && !StringUtils.isNullOrEmpty(maxName)) {
            return maxName;
        }
        return Long.toString(value);
    }

    public static String toString(long value, String minName, String maxName) {
        if (value == Long.MIN_VALUE && !StringUtils.isNullOrEmpty(minName)) {
            return minName;
        }
        if (value == Long.MAX_VALUE && !StringUtils.isNullOrEmpty(maxName)) {
            return maxName;
        }
        return Long.toString(value);
    }
}

