/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.EnumMap;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoHostACL;
import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.regex.PatternSyntaxException;

public class Pattern
implements Comparable<Pattern>,
Message<Pattern> {
    private static final String MESSAGE_TAG = "pattern";
    public static final String MATCH_ALL = "*";
    private String pattern;
    private Type type;
    private PathMatcher matcher;
    private boolean matchesAll;
    private static FileSystem defaultFileSystem = FileSystems.getDefault();

    public Pattern() {
        this.init(Type.GLOB, null);
    }

    public Pattern(String pattern) throws PatternSyntaxException {
        int i;
        int n = i = pattern != null ? pattern.indexOf(":") : -1;
        if (i > 0) {
            if (pattern.substring(0, i).equals(Type.GLOB.label)) {
                this.init(Type.GLOB, pattern.substring(++i));
            } else if (pattern.substring(0, i).equals(Type.REGEX.label)) {
                this.init(Type.REGEX, pattern.substring(++i));
            } else {
                this.init(Type.GLOB, pattern);
            }
        } else {
            this.init(Type.GLOB, pattern);
        }
    }

    public Pattern(Type type, String pattern) throws PatternSyntaxException {
        this.init(type, pattern);
    }

    private void init(Type type, String pattern) {
        this.type = type;
        if (pattern != null && !pattern.equals(MATCH_ALL)) {
            this.pattern = pattern;
            this.matchesAll = false;
            this.matcher = defaultFileSystem.getPathMatcher(type.getLabel() + ":" + pattern);
        } else {
            this.pattern = MATCH_ALL;
            this.matchesAll = true;
            this.matcher = null;
        }
    }

    public Type getType() {
        return this.type;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean matchesAll() {
        return this.matchesAll;
    }

    public boolean matches(String value) {
        if (value == null || this.matchesAll) {
            return this.matchesAll;
        }
        if (this.matcher == null) {
            this.matcher = defaultFileSystem.getPathMatcher(this.type.getLabel() + ":" + this.pattern);
        }
        return this.matcher.matches(defaultFileSystem.getPath(value, new String[0]));
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Pattern)) {
            return false;
        }
        return this.compareTo((Pattern)obj) == 0;
    }

    @Override
    public int compareTo(Pattern that) {
        int i = this.type.compareTo(that.getType());
        return i != 0 ? i : this.pattern.compareTo(that.pattern);
    }

    public String toString() {
        return this.type.label + ":" + this.pattern;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoHostACL.Pattern.Builder toProto() {
        ProtoHostACL.Pattern.Builder builder = ProtoHostACL.Pattern.newBuilder();
        builder.setPattern(this.pattern);
        if (!this.matchesAll) {
            if (this.type != Type.GLOB) {
                builder.setType(this.type.toProto());
            }
            builder.setPattern(this.pattern);
            builder.setMatchesAll(this.matchesAll);
        }
        return builder;
    }

    @Override
    public Pattern fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoHostACL.Pattern proto = ProtoHostACL.Pattern.parseFrom(data);
        this.type = Type.fromProto(proto.getType());
        this.pattern = proto.hasPattern() ? proto.getPattern() : MATCH_ALL;
        this.matchesAll = proto.getMatchesAll();
        this.matcher = null;
        return this;
    }

    public static enum Type {
        GLOB("glob"),
        REGEX("regex");

        private final String label;
        private static final EnumMap<Type, ProtoHostACL.Pattern.Type> typeMap;

        private Type(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static Type fromProto(ProtoHostACL.Pattern.Type type) {
            return typeMap.getA(type);
        }

        public ProtoHostACL.Pattern.Type toProto() {
            return typeMap.getB(this);
        }

        static {
            typeMap = new EnumMap<Type, ProtoHostACL.Pattern.Type>(Type.class, ProtoHostACL.Pattern.Type.class);
        }
    }
}

