/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Credit;
import com.beyondcron.core.IOUtils;
import com.beyondcron.core.InetSocketAddress;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.TableFormatter;
import com.beyondcron.core.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import jnr.constants.platform.Signal;
import jnr.posix.LibC;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import org.apache.logging.log4j.Logger;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Program {
    static final Logger logger = LogUtils.getLogger(Program.class);
    public static final String CREDITS_FILE = "credits.yaml";
    public static final String PROGRAM_HOME = "PROGRAM_HOME";
    public static final String PROGRAM_NAME_ENV = "PROGRAM_NAME";
    public static final String PROGRAM_NAME_PROPERTY = "program.name";
    public static final String VERSION_FILE = "version.txt";
    public static final String COPYRIGHT = "Copyright BeyondCron Pty Ltd and related entities";
    public static final POSIX posix = POSIXFactory.getNativePOSIX();
    private static Package mainPackage = null;
    private static String mainClassName = null;
    private static File home = null;
    private static String name = null;
    private static String title = null;
    private static Version version = null;
    private static String vendor = null;
    private static final OS os;
    private static final String osName;
    private static final String osArch;
    private static final String osVersion;
    private static final String userName;
    private static List<Credit> credits;
    private static boolean shuttingDown;
    private static boolean exiting;
    private final CmdLineParser parser;
    private final Map<String, Option> options = new TreeMap<String, Option>();
    private final Map<Integer, Argument> arguments = new TreeMap<Integer, Argument>();
    private final int usageWidth = 80;
    private int usageKeyWidth = 3;

    public Program(Object bean) {
        Program.getMainClassName();
        this.parser = new CmdLineParser(bean);
        this.parser.setUsageWidth(80);
        for (Field f : bean.getClass().getDeclaredFields()) {
            for (Annotation a : f.getDeclaredAnnotations()) {
                Argument argument;
                if (a instanceof Option) {
                    Option option = (Option)a;
                    Object key = option.name();
                    if (option.aliases().length > 0) {
                        key = (String)key + " (";
                        key = (String)key + StringUtils.join(", ", option.aliases());
                        key = (String)key + ")";
                    }
                    this.options.put((String)key, option);
                    if (((String)key).length() <= this.usageKeyWidth) continue;
                    this.usageKeyWidth = ((String)key).length();
                    continue;
                }
                if (!(a instanceof Argument) || (argument = (Argument)a).metaVar().length() <= 0 && argument.usage().length() <= 0 && !argument.required()) continue;
                this.arguments.put(argument.index(), argument);
                if (argument.metaVar().length() <= this.usageKeyWidth) continue;
                this.usageKeyWidth = argument.metaVar().length();
            }
        }
    }

    public void parseArgs(String ... args) throws CmdLineException {
        this.parser.parseArgument(args);
    }

    public void printUsage() {
        this.printUsage(System.out);
    }

    public void printUsage(OutputStream out) {
        this.printUsage(out, false);
    }

    public void printUsage(OutputStream out, boolean includeDetails) {
        StringBuilder sb = new StringBuilder();
        sb.append("usage: ").append(Program.getName());
        for (Option option : this.options.values()) {
            sb.append(" [").append(option.name()).append("]");
        }
        for (Argument argument : this.arguments.values()) {
            sb.append(argument.required() ? " " : " [");
            sb.append(argument.metaVar());
            if (argument.multiValued()) {
                sb.append(" ...");
            }
            if (argument.required()) continue;
            sb.append("]");
        }
        if (includeDetails) {
            String format = "\n %-" + this.usageKeyWidth + "s : %s";
            for (String option : this.options.keySet()) {
                sb.append(String.format(format, option, this.options.get(option).usage()));
            }
            for (Argument argument : this.arguments.values()) {
                sb.append(String.format(format, argument.metaVar(), argument.usage()));
            }
        }
        new PrintStream(out).println(sb);
    }

    public static void printVersion() {
        Program.printVersion(System.out, new HashMap<String, String>());
    }

    public static void printVersion(Map<String, String> options) {
        Program.printVersion(System.out, options);
    }

    public static void printVersion(OutputStream out, Map<String, String> options) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s: %s\n", Program.getName(), Program.getVersion()));
        TableFormatter table = new TableFormatter().setIndent("  ").setColumnSeparator(" ");
        table.displayHeader(false);
        table.alignColumn(0, TableFormatter.Column.Align.RIGHT);
        table.addRow("Java:", String.format("%s %s", Program.getJavaVersion(), Program.getJavaVendor()));
        for (String name : options.keySet()) {
            table.addRow(String.format("%s:", name), String.format("%s", options.get(name)));
        }
        sb.append(table);
        new PrintStream(out).print(sb);
    }

    public static void println(String message) {
        Program.println(System.out, message);
    }

    public static void println(OutputStream out, String message) {
        new PrintStream(out).println(Program.getName() + ": " + message);
    }

    public static File getHome() {
        if (home == null) {
            String dir;
            int i;
            String[] paths;
            String name = System.getProperty(PROGRAM_HOME);
            if (name == null) {
                name = System.getenv(PROGRAM_HOME);
            }
            if (name == null && (paths = System.getProperty("java.class.path").split(":")).length > 0 && (i = (dir = paths[0]).lastIndexOf("/lib/")) > 0) {
                name = dir.substring(0, i);
                for (String s : paths) {
                    if (s.startsWith(name)) continue;
                    name = null;
                    break;
                }
            }
            if (name != null) {
                home = new File(name);
                if (!home.exists()) {
                    Localise.logError(logger, "Directory %1$s does not exist", name);
                    name = null;
                } else if (!home.isDirectory()) {
                    Localise.logError(logger, "%1$s is not a directory", name);
                    name = null;
                }
            }
            if (name == null) {
                name = System.getProperty("user.dir");
                home = new File(name);
            }
        }
        return home;
    }

    public static void printEnv() {
        Program.printEnv(System.out);
    }

    public static void printEnv(PrintStream out) {
        Map<String, String> env = System.getenv();
        for (String key : new TreeSet<String>(env.keySet())) {
            out.println(key + ": " + env.get(key));
        }
    }

    public static File getHome(boolean reset) {
        if (reset) {
            home = null;
        }
        return Program.getHome();
    }

    public static String getName() {
        if (name == null) {
            name = System.getenv(PROGRAM_NAME_ENV);
            if (name == null) {
                name = System.getProperty(PROGRAM_NAME_PROPERTY);
            }
            if (name == null && ((name = Program.getTitle()) == null || name.contains("Java") || name.contains("java")) && (name = Program.getMainClassName()).lastIndexOf(46) >= 0) {
                name = name.substring(name.lastIndexOf(46) + 1);
            }
        }
        return name;
    }

    public static void setName(String name) {
        Program.name = name;
    }

    public static String getTitle() {
        Package pkg;
        if (title == null && (pkg = Program.getMainPackage()) != null) {
            title = pkg.getImplementationTitle();
        }
        return title;
    }

    public static Version getVersion() {
        if (version == null) {
            try {
                String versionString = IOUtils.readResource(VERSION_FILE);
                if (!StringUtils.isNullOrEmpty(versionString)) {
                    version = new Version(versionString);
                }
            }
            catch (IOException e) {
                Localise.logError(logger, e, "Unexpected exception reading version file", new Object[0]);
            }
            if (version == null) {
                version = new Version();
            }
        }
        return version;
    }

    public static void setVersion(String version) {
        Program.version = new Version(version);
    }

    public static String getVendor() {
        if (vendor == null) {
            Package pkg = Program.getMainPackage();
            if (pkg != null) {
                vendor = pkg.getImplementationVendor();
            }
            if (vendor == null || vendor.length() < 1) {
                vendor = "BeyondCron";
            }
        }
        return vendor;
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public static OS getOs() {
        return os;
    }

    public static OS getOs(String osName) {
        try {
            return OS.valueOf(StringUtils.strip(osName.toUpperCase(), " "));
        }
        catch (IllegalArgumentException e) {
            try {
                return OS.valueOf(StringUtils.firstToken(osName.toUpperCase(), " "));
            }
            catch (IllegalArgumentException e1) {
                Localise.logWarn(logger, "Unknown OS - %1$s", osName);
                return OS.UNKNOWN;
            }
        }
    }

    public static String getOsName() {
        return osName;
    }

    public static String getOsArch() {
        return osArch;
    }

    public static String getOsVersion() {
        return osVersion;
    }

    public static int getPID() {
        return posix.getpid();
    }

    public static String getUserName() {
        return userName;
    }

    public static long getUserID() {
        return posix.getuid();
    }

    public static long getEffectiveUserID() {
        return posix.geteuid();
    }

    public static long getGroupID() {
        return posix.getgid();
    }

    public static long getEffectiveGroupId() {
        return posix.getegid();
    }

    public static boolean isRootUser() {
        return posix.getuid() == 0 || posix.geteuid() == 0 || posix.getgid() == 0 || posix.getegid() == 0;
    }

    public static String getCopyright() {
        return COPYRIGHT;
    }

    public static List<Credit> getCredits() {
        return credits;
    }

    public static void exit(int status) throws ProgramExitingException {
        Program.exit(status, status != 0, true);
    }

    public static void exit(int status, boolean error) throws ProgramExitingException {
        Program.exit(status, error, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(int status, boolean error, boolean shutdownMessage) throws ProgramExitingException {
        Class<Program> clazz = Program.class;
        synchronized (Program.class) {
            if (logger.isDebugEnabled()) {
                Thread.dumpStack();
            }
            if (exiting) {
                throw new ProgramExitingException();
            }
            exiting = true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (shutdownMessage) {
                if (!error) {
                    Localise.logInfo(logger, "%1$s stopped", Program.getName());
                } else {
                    Localise.logFatal(logger, "%1$s stopped", Program.getName());
                }
            }
            System.exit(status);
            return;
        }
    }

    public static boolean isShuttingDown() {
        return shuttingDown;
    }

    public static boolean setShuttingDown(boolean shuttingDown) {
        boolean b = Program.shuttingDown;
        Program.shuttingDown = shuttingDown;
        return b;
    }

    public static Package getMainPackage() {
        if (mainPackage == null) {
            try {
                mainPackage = Class.forName(Program.getMainClassName()).getPackage();
            }
            catch (ClassNotFoundException e) {
                Localise.logError(logger, "Could not get package for %1$s", Program.getMainClassName());
            }
        }
        return mainPackage;
    }

    public static String getMainClassName() {
        if (mainClassName == null) {
            for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                mainClassName = element.getClassName();
            }
        }
        return mainClassName;
    }

    public static void setMainClassName(String mainClassName) {
        try {
            Program.setMainClass(Class.forName(mainClassName));
        }
        catch (ClassNotFoundException e) {
            Localise.logError(logger, "Could not get class %1$s - %2$s", mainClassName, e.getMessage());
        }
    }

    public static void setMainClass(Class<?> mainClass) {
        mainClassName = mainClass.getName();
        mainPackage = null;
        name = null;
        title = null;
        version = null;
        vendor = null;
        String location = mainClass.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (location != null && location.contains("/WEB-INF/") && (location.endsWith(".class") || location.endsWith("/classes/"))) {
            Program.parseManifest(new File(location.substring(0, location.indexOf("/WEB-INF/")) + "/META-INF/MANIFEST.MF"));
        }
    }

    private static void parseManifest(File file) {
        Manifest manifest;
        if (!file.exists()) {
            Localise.logError(logger, "Manifest file %1$s does not exist", file);
            return;
        }
        if (!file.isFile()) {
            Localise.logError(logger, "Manifest file %1$s is not a file", file);
            return;
        }
        try {
            manifest = new Manifest(new FileInputStream(file));
        }
        catch (IOException e) {
            Localise.logError(logger, "Could not parse manifest %1$s - %2$s", file, e.getMessage());
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        title = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        version = new Version(attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION));
        vendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
    }

    public static void printDebugInformation() {
        Map<String, String> env = System.getenv();
        System.out.println("Environment variables");
        for (String name : env.keySet()) {
            System.out.println(" " + name + ": " + env.get(name));
        }
    }

    public static Signal registerHandler(SignalHandler handler) {
        Signal signal;
        String name = Program.getSignalName((String)Configs.get("beyondcron.signal.stop"));
        try {
            signal = Signal.valueOf((String)name);
        }
        catch (IllegalArgumentException e) {
            signal = Signal.valueOf((String)Program.getSignalName((String)Configs.getDefault("beyondcron.signal.stop")));
            Localise.logError(logger, "Unsupported signal %1$s using %2$s instead", name, signal.description());
        }
        Program.registerHandler(handler, signal);
        return signal;
    }

    private static String getSignalName(String value) {
        String name = value.toUpperCase();
        return name.startsWith("SIG") ? name : "SIG" + name;
    }

    public static void registerHandler(SignalHandler handler, Signal ... signals) {
        for (Signal signal : signals) {
            posix.libc().signal(signal.intValue(), (LibC.LibCSignalHandler)handler);
        }
    }

    static {
        osName = System.getProperty("os.name");
        osArch = System.getProperty("os.arch");
        osVersion = System.getProperty("os.version");
        userName = System.getProperty("user.name");
        shuttingDown = false;
        exiting = false;
        CmdLineParser.registerHandler(InetSocketAddress.class, InetSocketAddress.OptionHandler.class);
        CmdLineParser.registerHandler(Period.class, Period.OptionHandler.class);
        os = Program.getOs(System.getProperty("os.name"));
        try {
            credits = Credit.loadCredits(Program.class.getClassLoader().getResources(CREDITS_FILE));
        }
        catch (Exception e) {
            credits = new ArrayList<Credit>();
            Localise.logWarn(logger, "Could not load program credits %1$s - %2$s", CREDITS_FILE, e);
        }
    }

    public static class ProgramExitingException
    extends RuntimeException {
    }

    public static enum OS {
        UNKNOWN("unknown"),
        LINUX("linux"),
        MACOSX("macosx"),
        SUNOS("sunos"),
        WINDOWS("windows");

        private final String label;

        private OS(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static interface SignalHandler
    extends LibC.LibCSignalHandler {
    }
}

