/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.job.VariableFormatter;
import com.beyondcron.core.property.PropertyValidator;
import com.beyondcron.core.security.ACL;
import com.beyondcron.core.security.UserACLValidator;
import com.beyondcron.messaging.CommandConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class PropertyDefaults {
    private UserACLValidator aclValidator;
    private PropertyValidator propertyValidator;
    private Name name;
    private TimeZone timeZone;
    private Map<String, Property> properties;
    private VariableFormatter formatter;

    public PropertyDefaults(CommandConnection connection, TimeZone timeZone, Name name) {
        this.name = name;
        this.timeZone = timeZone;
        this.aclValidator = connection.getACLValidator();
        this.propertyValidator = PropertyValidator.getInstance(connection.getHazelcast());
        this.properties = new HashMap<String, Property>();
        if (!name.equals(Name.ROOT)) {
            Name parent = name.isRootGroup() ? Name.ROOT : name.getGroup();
            for (com.beyondcron.core.Property property : this.propertyValidator.getProperties(parent, true)) {
                if (property.getType() == Property.Type.UNSET) continue;
                this.properties.put(property.getName(), new Property(property, this.aclValidator.hasPermission(property.getGroup(), ACL.Permission.WRITE)));
            }
        }
        this.formatter = new VariableFormatter(this.properties, timeZone, System.currentTimeMillis());
    }

    public Name getName() {
        return this.name;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public Property get(String name) {
        return this.properties.get(name);
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public boolean hasTemplateValue(String name) {
        return this.getTemplateValue(name, null, false) != null;
    }

    public String getTemplateValue(String name) {
        return this.getTemplateValue(name, null, true);
    }

    public String getTemplateValue(String name, boolean expand) {
        return this.getTemplateValue(name, null, expand);
    }

    public String getTemplateValue(String name, String defaultValue) {
        return this.getTemplateValue(name, defaultValue, true);
    }

    public String getTemplateValue(String name, String defaultValue, boolean expand) {
        Property property = this.properties.get(name);
        if (property == null || property.getType() != Property.Type.TEMPLATE) {
            return defaultValue;
        }
        return expand ? this.formatter.expand(property.getValue()) : property.getValue();
    }

    public static class Property
    extends com.beyondcron.core.Property {
        private boolean showSecrets;

        public Property() {
        }

        public Property(Property property) {
            this(property, property.showSecrets);
        }

        public Property(com.beyondcron.core.Property property, boolean showSecrets) {
            super(property);
            this.showSecrets = showSecrets;
        }

        public boolean showSecrets() {
            return this.showSecrets;
        }

        @Override
        public int getMessageType() {
            return this.getClass().getName().hashCode();
        }
    }
}

