/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.StringUtils;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.message.Link;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.proto.ProtoCore;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Result
implements Message<Result>,
ResultMessage {
    private static final String MESSAGE_TAG = "result";
    public static final int DEFAULT_VALUE = 0;
    private boolean success;
    private int value;
    private String message;
    private List<Link> references = new ArrayList<Link>();

    public Result() {
        this(true, 0, null, new Link[0]);
    }

    public Result(boolean success, String message, Link ... references) {
        this(success, success ? 0 : 1, message, references);
    }

    public Result(boolean success, int value, String message, Link ... references) {
        this.success = success;
        this.value = value;
        this.message = message;
        this.references.addAll(Arrays.asList(references));
    }

    public Result(Exception exception) {
        this.success = false;
        this.value = -1;
        this.message = exception.getMessage();
    }

    public boolean wasSuccess() {
        return this.success;
    }

    public Result setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public Result setSuccess(boolean success, int value) {
        this.success = success;
        this.value = value;
        return this;
    }

    public Result setSuccess(boolean success, String message) {
        return this.setSuccess(success, success ? 0 : 1, message);
    }

    public Result setSuccess(boolean success, int value, String message) {
        this.success = success;
        this.value = value;
        this.message = message;
        return this;
    }

    public int getValue() {
        return this.value;
    }

    public Result setValue(int value) {
        this.value = value;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public Result setMessage(String message) {
        this.message = message;
        return this;
    }

    public List<Link> getReferences() {
        return this.references;
    }

    public Result addReference(Link reference) {
        this.references.add(reference);
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public String toString() {
        return StringUtils.join(" ", " ", Boolean.toString(this.success), Integer.toString(this.value), this.message != null ? this.message : "");
    }

    public ProtoCore.Result.Builder toProto() {
        ProtoCore.Result.Builder builder = ProtoCore.Result.newBuilder();
        builder.setSuccess(this.success);
        if (this.value != 0) {
            builder.setCode(this.value);
        }
        if (this.message != null) {
            builder.setMessage(this.message);
        }
        for (Link reference : this.references) {
            builder.addReferences(reference.toProto());
        }
        return builder;
    }

    @Override
    public Result fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoCore.Result proto = ProtoCore.Result.parseFrom(data);
        this.success = proto.getSuccess();
        this.value = proto.getCode();
        this.message = proto.hasMessage() ? proto.getMessage() : null;
        this.references.clear();
        for (ProtoCore.Link reference : proto.getReferencesList()) {
            this.references.add(new Link().fromProto(reference.toByteArray()));
        }
        return this;
    }

    @Override
    public Result getResult() {
        return this;
    }
}

