/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Configs;
import com.beyondcron.core.JSON;
import com.beyondcron.core.StringUtils;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoProperty;
import com.beyondcron.messaging.proto.ProtoRole;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class Role
implements Cloneable,
Comparable<Role>,
Message<Role>,
JSON<Role> {
    private static final String MESSAGE_TAG = "role";
    public static final String JSON_NAME = "name";
    public static final String JSON_DESCRIPTION = "description";
    public static final String JSON_PROPERTIES = "properties";
    public static final String PROPERTY_ROLE_TYPE = "roleType";
    public static final String ROLE_TYPE = "BeyondCron";
    public static final String ADMIN_NAME = (String)Configs.get("beyondcron.admin.role.name");
    public static final Role ADMIN = new Role(ADMIN_NAME, (String)Configs.get("beyondcron.admin.role.description"));
    public static final String EVERYONE_NAME;
    public static final Role EVERYONE;
    private String name;
    private String description = "";
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private boolean readOnly = false;

    public Role() {
    }

    public Role(String name) {
        this(name, "");
    }

    public Role(String name, String description) {
        if (StringUtils.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("empty/null user name");
        }
        this.name = name;
        this.setDescription(description);
    }

    public Role(Role role) {
        this.name = role.name;
        this.description = role.description;
        this.properties.putAll(role.properties);
        this.readOnly = role.readOnly;
    }

    public String getRoleType() {
        String type = this.properties.get(PROPERTY_ROLE_TYPE);
        return type != null ? type : ROLE_TYPE;
    }

    public Role clone() {
        return new Role(this);
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description != null ? StringUtils.stripDuplicateSpaces(description) : "";
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Role setProperty(String name, Object value) {
        this.properties.put(name, value != null ? value.toString() : "");
        return this;
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public String toString() {
        return this.name + " " + this.description;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put(JSON_NAME, this.name);
        if (!StringUtils.isNullOrEmpty(this.description)) {
            json.put(JSON_DESCRIPTION, this.description);
        }
        if (!this.properties.isEmpty()) {
            json.put(JSON_PROPERTIES, new JSONObject(this.properties));
        }
        return json;
    }

    @Override
    public Role fromJSON(JSONObject json) {
        this.name = json.getString(JSON_NAME);
        this.description = json.optString(JSON_DESCRIPTION);
        this.properties.clear();
        if (json.has(JSON_PROPERTIES)) {
            JSONObject p = json.getJSONObject(JSON_PROPERTIES);
            for (String key : JSONObject.getNames(p)) {
                this.properties.put(key, p.getString(key));
            }
        }
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoRole.Role.Builder toProto() {
        ProtoRole.Role.Builder builder = ProtoRole.Role.newBuilder();
        builder.setName(this.name);
        if (this.description != null && !this.description.isEmpty()) {
            builder.setDescription(this.description);
        }
        for (String name : this.properties.keySet()) {
            builder.addProperties(ProtoProperty.Property.newBuilder().setName(name).setValue(this.properties.get(name)));
        }
        if (this.readOnly) {
            builder.setReadOnly(true);
        }
        return builder;
    }

    @Override
    public Role fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoRole.Role proto = ProtoRole.Role.parseFrom(data);
        this.name = proto.getName();
        this.description = proto.hasDescription() ? proto.getDescription() : "";
        this.properties.clear();
        for (ProtoProperty.Property property : proto.getPropertiesList()) {
            this.properties.put(property.getName(), property.getValue());
        }
        this.readOnly = proto.getReadOnly();
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Role)) {
            return false;
        }
        return this.compareTo((Role)obj) == 0;
    }

    @Override
    public int compareTo(Role that) {
        return this.name.compareTo(that.name);
    }

    static {
        ADMIN.setReadOnly(false);
        EVERYONE_NAME = (String)Configs.get("beyondcron.everyone.role.name");
        EVERYONE = new Role(EVERYONE_NAME, (String)Configs.get("beyondcron.everyone.role.description"));
        EVERYONE.setReadOnly(true);
    }
}

