/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SizeUtils {

    public static enum Unit {
        B(1L, "B"),
        KB(1000L, "KB"),
        KiB(1024L, "KiB"),
        MB(1000000L, "MB"),
        MiB(0x100000L, "MiB"),
        GB(1000000000L, "GB"),
        GiB(0x40000000L, "GiB"),
        TB(1000000000000L, "TB"),
        TiB(0x10000000000L, "TiB"),
        PB(1000000000000000L, "PB"),
        PiB(0x4000000000000L, "PiB");

        private static Pattern regex;
        private static Map<String, Unit> units;
        private String unit;
        private long bytes;

        private Unit(long bytes, String unit) {
            this.bytes = bytes;
            this.unit = unit;
        }

        public double getSize(String value, Unit defaultUnit) {
            Matcher matcher = regex.matcher(value);
            if (!matcher.matches()) {
                throw new NumberFormatException();
            }
            Unit u = defaultUnit;
            String s = matcher.group(3);
            if (s != null && (u = Unit.getUnit(s)) == null) {
                throw new NumberFormatException();
            }
            return Double.parseDouble(matcher.group(1)) * (double)u.bytes / (double)this.bytes;
        }

        private static Unit getUnit(String unit) {
            if (units == null) {
                units = new HashMap<String, Unit>();
                for (Unit u : Unit.values()) {
                    units.put(u.unit, u);
                }
            }
            return units.get(unit);
        }

        static {
            regex = Pattern.compile("^([0-9]+(\\.[0-9]+)?)([BKMGTP]?i?B)?$");
            units = null;
        }
    }
}

