/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import org.apache.logging.log4j.Logger;

public class Sleep {
    static final Logger logger = LogUtils.getLogger(Sleep.class);
    private int minimumSleep;
    private int maximumSleep;
    private int currentSleep;

    public Sleep(int minimumSleep, int maximumSleep) {
        this.minimumSleep = minimumSleep > 0 ? minimumSleep : 1;
        this.maximumSleep = Math.max(maximumSleep, minimumSleep);
        this.reset();
    }

    public void sleep() {
        try {
            Thread.sleep(this.currentSleep * 1000);
        }
        catch (InterruptedException e) {
            Localise.logWarn(logger, "Unexpectedly interrupted", new Object[0]);
        }
        if (this.currentSleep < this.maximumSleep) {
            this.currentSleep *= 2;
            if (this.currentSleep > this.maximumSleep) {
                this.currentSleep = this.maximumSleep;
            }
        }
    }

    public void reset() {
        this.currentSleep = this.minimumSleep;
    }
}

