/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;

public class StringUtils {
    static final Logger logger = LogUtils.getLogger(StringUtils.class);

    public static Map<String, String> asMap(String ... values) {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < values.length) {
            String name = values[i++];
            if (i < values.length) {
                map.put(name, values[i++]);
                continue;
            }
            map.put(name, null);
        }
        return map;
    }

    public static InputStream asStream(String value) {
        return new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
    }

    public static String readLine(String prompt) {
        if (prompt != null && prompt.length() > 0) {
            System.out.print(prompt);
        }
        try {
            return new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (IOException e) {
            Localise.logError(logger, e, "Unexpected exception reading System.in - %1$s", e.getMessage());
            return null;
        }
    }

    public static String capitalise(Object value) {
        String s = value != null ? value.toString() : "";
        switch (s.length()) {
            case 0: {
                return s;
            }
            case 1: {
                return s.toUpperCase();
            }
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1).toLowerCase();
    }

    public static String upperCaseFirst(Object value) {
        String s = value != null ? value.toString() : "";
        switch (s.length()) {
            case 0: {
                return s;
            }
            case 1: {
                return s.toUpperCase();
            }
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static List<String> capitaliseAll(String[] values) {
        ArrayList<String> l = new ArrayList<String>();
        for (String value : values) {
            l.add(StringUtils.capitalise(value));
        }
        return l;
    }

    public static List<String> capitaliseAll(Collection<?> values) {
        ArrayList<String> l = new ArrayList<String>();
        for (Object value : values) {
            l.add(StringUtils.capitalise(value));
        }
        return l;
    }

    public static String csvQuote(String value) {
        if (value == null) {
            return "";
        }
        if (value.contains("\"")) {
            return "\"" + value.replace("\"", "\"\"") + "\"";
        }
        if (value.contains(",") || value.contains("\n")) {
            return "\"" + value + "\"";
        }
        return value;
    }

    public static boolean equals(String value1, String value2) {
        return value1 != null ? value1.equals(value2) : value2 == null;
    }

    public static List<String> lowerCaseAll(String[] values) {
        ArrayList<String> l = new ArrayList<String>();
        for (String value : values) {
            l.add(value.toLowerCase());
        }
        return l;
    }

    public static List<String> lowerCaseAll(Collection<?> values) {
        ArrayList<String> l = new ArrayList<String>();
        for (Object value : values) {
            l.add(value.toString().toLowerCase());
        }
        return l;
    }

    public static String fromCamelCase(String value) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (char c : value.toCharArray()) {
            if (Character.isUpperCase(c)) {
                sb.append(' ');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static int count(String str, String value) {
        int index = value.indexOf(str);
        int count = index >= 0 ? 1 : 0;
        while (true) {
            ++index;
            if ((index = value.indexOf(str, index)) < 0) break;
            ++count;
        }
        return count;
    }

    public static boolean isNullOrEmpty(Object value) {
        return value == null || value.toString().isEmpty();
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static String truncate(String value, int length) {
        return value != null && value.length() > length ? value.substring(0, length - 3) + "..." : value;
    }

    public static String hashString(String value) {
        String hash;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            hash = Base64.getEncoder().encodeToString(digest.digest(value.getBytes()));
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("could not use SHA-256, using String.hashCode() instead", (Throwable)e);
            hash = Base64.getEncoder().encodeToString(Integer.toString(value.hashCode()).getBytes());
        }
        return hash.replace('/', '-');
    }

    public static String fill(char value, int length) {
        return String.format("%" + length + "s", "").replace(' ', value);
    }

    public static String get(String value) {
        return value == null || value.isEmpty() ? "" : value;
    }

    public static String get(String value, String defaultValue) {
        return value == null || value.isEmpty() ? defaultValue : value;
    }

    public static String join(String delimiter, Collection<?> values) {
        return StringUtils.join(delimiter, values.toArray(new Object[0]));
    }

    public static String join(String delimiter, Object[] values) {
        String[] array = new String[values.length];
        int i = 0;
        for (Object value : values) {
            array[i++] = value.toString();
        }
        return StringUtils.join(delimiter, array);
    }

    public static String join(String delimiter, String[] values) {
        return StringUtils.join(delimiter, 0, values.length, values);
    }

    public static String join(String delimiter, int from, int to, String[] values) {
        StringBuilder sb = new StringBuilder();
        for (int i = from; i < to; ++i) {
            if (i > from && delimiter != null) {
                sb.append(delimiter);
            }
            sb.append(values[i]);
        }
        return sb.toString();
    }

    public static String join(String delimiter, String lastDelimiter, Collection<?> values) {
        String[] array = new String[values.size()];
        int i = 0;
        for (Object value : values) {
            array[i++] = value.toString();
        }
        return StringUtils.join(delimiter, lastDelimiter, array);
    }

    public static String join(String delimiter, String lastDelimiter, String ... values) {
        StringBuilder sb = new StringBuilder();
        int j = values.length;
        int i = 0;
        if (j-- > 0) {
            sb.append(values[i]);
            while (++i < j) {
                if (delimiter != null) {
                    sb.append(delimiter);
                }
                sb.append(values[i]);
            }
            if (i == j) {
                if (lastDelimiter != null) {
                    sb.append(lastDelimiter);
                }
                sb.append(values[i]);
            }
        }
        return sb.toString();
    }

    public static String plural(String value, int count) {
        return count == -1 || count == 1 ? value : value + "s";
    }

    public static String singular(String value) {
        return value.toLowerCase().endsWith("s") ? value.substring(0, value.length() - 1) : value;
    }

    public static String[] range(int from, int to, String ... values) {
        String[] array = new String[to - from];
        int j = 0;
        int i = from;
        while (i < to) {
            array[j++] = values[i++];
        }
        return array;
    }

    public static String firstToken(String value, String delimiter) {
        if (value == null) {
            return null;
        }
        int i = value.indexOf(delimiter);
        if (i == 0) {
            return "";
        }
        return i > 0 ? value.substring(0, i) : value;
    }

    public static String lastToken(String value, String delimiter) {
        if (value == null) {
            return null;
        }
        int i = value.lastIndexOf(delimiter) + 1;
        if (i == value.length()) {
            return "";
        }
        return i > 0 ? value.substring(i) : value;
    }

    public static String strip(String value, String delimiter) {
        return StringUtils.join(null, value.split(delimiter));
    }

    public static String stripComment(String value, String delimiter) {
        int i = value.indexOf(delimiter);
        return i < 0 ? value : value.substring(0, i);
    }

    public static String stripPrefix(String value, String prefix) {
        if (!value.startsWith(prefix)) {
            return value;
        }
        return value.substring(prefix.length());
    }

    public static String stripDuplicateSpaces(String value) {
        return value.replaceAll("  +", " ");
    }

    public static String[] split(String value) {
        return StringUtils.split(value, true);
    }

    public static String[] split(String value, boolean stripQuotes) {
        ArrayList<String> words = new ArrayList<String>();
        if (value == null || value.length() < 1) {
            return new String[0];
        }
        String[] tokens = value.split("\\s+");
        int i = 0;
        while (i < tokens.length) {
            int j;
            String token = tokens[i];
            char quote = token.charAt(0);
            if (quote != '\'' && quote != '\"') {
                words.add(token);
                ++i;
                continue;
            }
            if (token.charAt(token.length() - 1) == quote) {
                if (stripQuotes) {
                    words.add(token.substring(1, token.length() - 1));
                } else {
                    words.add(token);
                }
                ++i;
                continue;
            }
            for (j = i + 1; j < tokens.length && tokens[j].charAt(tokens[j].length() - 1) != quote; ++j) {
            }
            if (j++ < tokens.length) {
                token = StringUtils.join(" ", i, j, tokens);
                if (stripQuotes) {
                    words.add(token.substring(1, token.length() - 1));
                } else {
                    words.add(token);
                }
                i = j;
                continue;
            }
            words.add(token);
            ++i;
        }
        return words.toArray(new String[0]);
    }

    public static String[] split(String value, Pattern delim) {
        return StringUtils.split(value, delim, false, false);
    }

    public static String[] split(String value, Pattern delim, boolean includeDelim, boolean includeEmpty) {
        ArrayList<String> words = new ArrayList<String>();
        int start = 0;
        Matcher matcher = delim.matcher(value);
        while (matcher.find()) {
            String wordBefore = value.substring(start, matcher.start());
            if (wordBefore.length() > 0 || includeEmpty) {
                words.add(wordBefore);
            }
            if (includeDelim) {
                words.add(matcher.group());
            }
            start = matcher.end();
        }
        if (start != value.length()) {
            words.add(value.substring(start));
        }
        return words.toArray(new String[0]);
    }

    public static String stackTrace(Exception e) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(out));
        return out.toString();
    }

    public static String trimStart(String value) {
        return value.replaceAll("^\\s+", "");
    }

    public static String trimEnd(String value) {
        return value.replaceAll("\\s+$", "");
    }

    public static String unquote(String value) {
        if (value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static String wrap(int width, String words) {
        StringBuilder sb = new StringBuilder();
        int lineLength = 0;
        for (String word : StringUtils.split(words)) {
            int length = word.length();
            if (lineLength == 0) {
                sb.append(word);
                lineLength = length;
                continue;
            }
            if (lineLength + length + 1 < width) {
                sb.append(' ').append(word);
                lineLength += length + 1;
                continue;
            }
            sb.append("\n").append(word);
            lineLength = length;
        }
        return sb.toString();
    }

    public static Collection<String> toString(Collection<?> values) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Object value : values) {
            strings.add(value.toString());
        }
        return strings;
    }

    public static String toBase64(String value) {
        return Base64.getEncoder().encodeToString(value.getBytes());
    }

    public static String fromBase64(String value) {
        return new String(Base64.getDecoder().decode(value));
    }

    public static boolean constantEquals(String s, String t) {
        byte[] a = s.getBytes();
        byte[] b = t.getBytes();
        int diff = a.length ^ b.length;
        for (int i = 0; i < a.length && i < b.length; ++i) {
            diff |= a[i] ^ b[i];
        }
        return diff == 0;
    }
}

