/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.logging.log4j.Logger;

public class TableFormatter
implements Iterable<String> {
    static final Logger logger = LogUtils.getLogger(TableFormatter.class);
    static String nullValue = "";
    static String defaultIndent = "";
    static String defaultColumnSeparator = " ";
    static char defaultHeaderSeparator = '\u0000';
    static String defaultHeaderColumnSeparator = null;
    private String indent;
    private String columnSeparator;
    private char headerSeparator;
    private String headerColumnSeparator;
    private boolean hasHeader = false;
    private boolean hasHeaderSeparator = false;
    private boolean displayHeader = true;
    private List<Column> columns = new ArrayList<Column>();
    private List<List<Cell>> rows = new ArrayList<List<Cell>>();
    private int lines = 0;
    private List<Cell> nextRow = new ArrayList<Cell>();
    private String rowFormat = null;
    private List<String> columnFormats = new ArrayList<String>();

    public TableFormatter() {
        this.initFormatting();
    }

    public TableFormatter(boolean displayHeader) {
        this.displayHeader = displayHeader;
        this.initFormatting();
    }

    public TableFormatter(String ... headers) {
        this.initFormatting();
        this.hasHeader = true;
        this.addRow(headers);
    }

    private void initFormatting() {
        this.setIndent(defaultIndent);
        this.setColumnSeparator(defaultColumnSeparator);
        this.setHeaderSeparator(defaultHeaderSeparator);
        this.setHeaderColumnSeparator(defaultHeaderColumnSeparator);
    }

    private void initRowFormatting() {
        this.columnFormats.clear();
        for (Column c : this.columns) {
            this.columnFormats.add("%" + (c.getAlignment() == Column.Align.LEFT ? "-" : "") + c.getWidth() + "s");
        }
        this.rowFormat = this.indent + StringUtils.join(this.columnSeparator, this.columnFormats);
    }

    public TableFormatter clear() {
        for (Column column : this.columns) {
            column.clearWidth();
        }
        if (this.hasHeader) {
            int row = 1;
            while (this.rows.size() > row) {
                this.rows.remove(row);
            }
        } else {
            this.rows.clear();
        }
        return this;
    }

    public static void setNullValue(String value) {
        nullValue = value;
    }

    public TableFormatter setIndent(String indent) {
        this.indent = indent;
        return this;
    }

    public static void setDefaultIndent(String indent) {
        defaultIndent = indent;
    }

    public TableFormatter setColumnSeparator(String separator) {
        this.columnSeparator = separator;
        return this;
    }

    public static void setDefaultColumnSeparator(String separator) {
        defaultColumnSeparator = separator;
    }

    public TableFormatter setHeaderSeparator(char separator) {
        this.headerSeparator = separator;
        this.hasHeaderSeparator = separator != '\u0000';
        return this;
    }

    public static void setDefaultHeaderSeparator(char separator) {
        defaultHeaderSeparator = separator;
    }

    public TableFormatter setHeaderColumnSeparator(String separator) {
        this.headerColumnSeparator = separator;
        return this;
    }

    public static void setDefaultHeaderColumnSeparator(String separator) {
        defaultHeaderColumnSeparator = separator;
    }

    public TableFormatter addColumn(String name) {
        List<Object> columns;
        int column = this.getColumn(name);
        if (column >= 0) {
            Localise.logWarn(logger, "Column %1$s already exists, new column will be accessible by index (%2$s) only", name, column);
        }
        if (this.rows.size() > 0) {
            columns = this.rows.get(0);
        } else {
            columns = new ArrayList();
            this.rows.add(columns);
        }
        column = columns.size();
        columns.add(new Cell(name));
        this.setWidth(column, name.length());
        this.hasHeader = true;
        return this;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public List<List<String>> getRows() {
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        int row = 0;
        while (row < this.rows.size()) {
            ArrayList<String> cells = new ArrayList<String>();
            for (Cell cell : this.rows.get(row++)) {
                cells.add(cell.toString());
            }
            table.add(cells);
        }
        return table;
    }

    public int getLineCount() {
        return this.hasHeaderSeparator && this.displayHeader ? this.lines + 1 : this.lines;
    }

    public TableFormatter addColumns(String ... names) {
        for (String name : names) {
            this.addColumn(name);
        }
        return this;
    }

    private int getColumn(String name) {
        List<Cell> values;
        int column = -1;
        if (this.rows.size() > 0 && (values = this.rows.get(0)) != null) {
            for (int i = 0; i < values.size(); ++i) {
                if (!values.get(i).toString().equals(name)) continue;
                column = i;
                break;
            }
        }
        return column;
    }

    public TableFormatter alignColumn(String name, Column.Align alignment) {
        if (this.hasHeader) {
            int column = this.getColumn(name);
            if (column >= 0) {
                return this.alignColumn(column, alignment);
            }
            Localise.logError(logger, "Undefined column %1$s", name);
        } else {
            Localise.logError(logger, "Header row is not defined", new Object[0]);
        }
        return this;
    }

    public TableFormatter alignColumn(int column, Column.Align alignment) {
        while (column >= this.columns.size()) {
            this.columns.add(new Column());
        }
        this.columns.get(column).setAlignment(alignment);
        return this;
    }

    public TableFormatter alignColumns(Column.Align alignment) {
        Column.setDefaultAlignment(alignment);
        for (Column column : this.columns) {
            column.setAlignment(alignment);
        }
        return this;
    }

    public TableFormatter displayHeader(boolean displayHeader) {
        this.displayHeader = displayHeader;
        return this;
    }

    public TableFormatter addRow(Object ... values) {
        this.startRow();
        ArrayList<Cell> row = new ArrayList<Cell>();
        int rowLines = 1;
        int column = 0;
        for (Object value : values) {
            Cell cell = new Cell(value != null ? value.toString() : null, !(value instanceof TableFormatter));
            row.add(cell);
            this.setWidth(column++, cell.getWidth());
            int cellLines = cell.getLineCount();
            if (cellLines <= rowLines) continue;
            rowLines = cellLines;
        }
        this.rows.add(row);
        this.lines += rowLines;
        return this;
    }

    public TableFormatter addValue(Object value) {
        return this.addValue(value, true);
    }

    public TableFormatter addValue(Object value, boolean trim) {
        Cell cell = new Cell(value != null ? value.toString() : null, trim);
        int column = this.nextRow.size();
        this.nextRow.add(cell);
        this.setWidth(column, cell.getWidth());
        return this;
    }

    public TableFormatter addValue(Object value, int width) {
        Cell cell = new Cell(value != null ? value.toString() : null, false);
        int column = this.nextRow.size();
        this.nextRow.add(cell);
        this.setWidth(column, width);
        return this;
    }

    public TableFormatter startRow() {
        if (this.nextRow.size() > 0) {
            int rowLines = 1;
            for (Cell cell : this.nextRow) {
                int cellLines = cell.getLineCount();
                if (cellLines <= rowLines) continue;
                rowLines = cellLines;
            }
            this.lines += rowLines;
            while (this.nextRow.size() < this.columns.size()) {
                this.nextRow.add(new Cell());
            }
            this.rows.add(this.nextRow);
            this.nextRow = new ArrayList<Cell>();
        }
        return this;
    }

    public TableFormatter endRow() {
        this.startRow();
        return this;
    }

    public int getWidth(int column) {
        return this.columns.size() > column ? this.columns.get(column).getWidth() : 1;
    }

    public void setWidth(int column, int width) {
        if (this.columns.size() > column) {
            this.columns.get(column).setWidth(width);
        } else {
            this.columns.add(new Column(width));
        }
    }

    @Override
    public Iterator<String> iterator() {
        Scanner scanner = new Scanner(this.toString());
        scanner.useDelimiter("\\n");
        return scanner;
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.print(out);
        return out.toString();
    }

    public String toString(Object[] values) {
        ArrayList<Cell> row = new ArrayList<Cell>();
        for (Object value : values) {
            Cell cell = new Cell(value != null ? value.toString() : null);
            row.add(cell);
        }
        if (this.rowFormat == null) {
            this.initRowFormatting();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.printRow(new PrintStream(out), this.rowFormat, row);
        return out.toString();
    }

    public void print() {
        this.print(System.out);
    }

    public void print(OutputStream stream) {
        this.print(stream, 0, 0);
    }

    public void print(OutputStream stream, int linesBefore, int linesAfter) {
        PrintStream out = new PrintStream(stream);
        int row = 0;
        this.startRow();
        this.initRowFormatting();
        while (linesBefore-- > 0) {
            out.println();
        }
        if (!this.rows.isEmpty()) {
            if (this.hasHeader) {
                if (this.displayHeader) {
                    this.printRow(out, this.rowFormat, this.rows.get(row));
                }
                ++row;
            }
            if (this.hasHeaderSeparator && this.displayHeader) {
                ArrayList<String> values = new ArrayList<String>();
                for (String format : this.columnFormats) {
                    values.add(String.format(format, Character.valueOf(this.headerSeparator)).replace(' ', this.headerSeparator));
                }
                if (this.headerColumnSeparator != null) {
                    out.println(this.indent + StringUtils.join(this.headerColumnSeparator, values));
                } else {
                    out.println(this.indent + StringUtils.join(this.columnSeparator, values));
                }
            }
            while (row < this.rows.size()) {
                this.printRow(out, this.rowFormat, this.rows.get(row++));
            }
        }
        while (linesAfter-- > 0) {
            out.println();
        }
    }

    private void printRow(PrintStream out, String format, List<Cell> cells) {
        ArrayList<String> values = new ArrayList<String>();
        int lines = 0;
        for (Cell cell : cells) {
            if (cell.getLineCount() <= lines) continue;
            lines = cell.getLineCount();
        }
        if (lines < 1) {
            lines = 1;
        }
        for (int line = 0; line < lines; ++line) {
            values.clear();
            for (Cell cell : cells) {
                values.add(cell.getLine(line, ""));
            }
            while (values.size() < this.columns.size()) {
                values.add("");
            }
            this.printLine(out, format, values);
        }
    }

    private void printLine(PrintStream out, String format, List<String> values) {
        out.println(StringUtils.trimEnd(String.format(format, values.toArray())));
    }

    public static class Cell
    implements Comparable<Cell> {
        List<String> lines = new ArrayList<String>();
        int width = 0;

        public Cell() {
        }

        public Cell(String value) {
            this(value, true);
        }

        public Cell(String value, boolean trim) {
            this.add(value, trim);
        }

        public void clear() {
            this.lines.clear();
            this.width = 0;
        }

        public void add(String value) {
            this.add(value, true);
        }

        public void add(String value, boolean trim) {
            String s;
            if (value != null) {
                s = StringUtils.trimEnd(value);
            } else {
                if (nullValue == null) {
                    return;
                }
                s = nullValue;
            }
            for (String line : s.split("\n")) {
                this.lines.add(trim ? line.trim() : line);
                int len = line.length();
                if (len <= this.width) continue;
                this.width = len;
            }
        }

        public int getWidth() {
            return this.width;
        }

        public int getLineCount() {
            return this.lines.size();
        }

        public List<String> getLines() {
            return this.lines;
        }

        public String getLine(int line) {
            return this.getLine(line, null);
        }

        public String getLine(int line, String emptyValue) {
            if (line < 0 || line >= this.lines.size()) {
                return emptyValue;
            }
            return this.lines.get(line);
        }

        public String toString() {
            return StringUtils.join("\n", this.lines);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Cell) {
                return this.compareTo((Cell)obj) == 0;
            }
            return this.toString().equals(obj.toString());
        }

        @Override
        public int compareTo(Cell that) {
            if (this == that) {
                return 0;
            }
            if (this.lines.size() != that.lines.size()) {
                return this.lines.size() - that.lines.size();
            }
            for (int i = 0; i < this.lines.size(); ++i) {
                int j = this.lines.get(i).compareTo(that.lines.get(i));
                if (j == 0) continue;
                return j;
            }
            return 0;
        }
    }

    public static class Column {
        int width;
        Align alignment;
        public static Align defaultAlignment = Align.LEFT;

        public Column() {
            this(1, defaultAlignment);
        }

        public Column(int width) {
            this(width, defaultAlignment);
        }

        public static void setDefaultAlignment(Align alignment) {
            defaultAlignment = alignment;
        }

        public Column(int width, Align alignment) {
            this.width = width > 0 ? width : 1;
            this.alignment = alignment;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            if (width > this.width) {
                this.width = width;
            }
        }

        public void clearWidth() {
            this.width = 1;
        }

        public Align getAlignment() {
            return this.alignment;
        }

        public void setAlignment(Align alignment) {
            this.alignment = alignment;
        }

        public static enum Align {
            LEFT,
            RIGHT;

        }
    }
}

