/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.ThreadUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class ThreadStats {
    static final Logger logger = LogUtils.getLogger(ThreadStats.class);
    private Map<String, Thread> threads = new TreeMap<String, Thread>();
    private Map<String, GroupSummary> groups = new HashMap<String, GroupSummary>();

    public ThreadStats() {
        this.update();
    }

    private void update() {
        this.threads.clear();
        this.groups.clear();
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            String groupName = thread.getThreadGroup().getName();
            this.threads.put(groupName + ":" + thread.getName(), thread);
            GroupSummary group = this.groups.get(groupName);
            if (group == null) {
                group = new GroupSummary(groupName);
                this.groups.put(groupName, group);
            }
            group.addState(thread.getState());
        }
    }

    public Thread startMonitor(PrintStream out, Period period, boolean groupSummary) {
        Thread monitor = new Thread(() -> {
            while (true) {
                this.update();
                for (String line : groupSummary ? this.getSummary() : this.getDetails()) {
                    out.println(line);
                }
                try {
                    Thread.sleep(period.getMilliseconds());
                }
                catch (InterruptedException e) {
                    Localise.logWarn(logger, e, "Thread monitor unexpectedly interrupted", new Object[0]);
                    return;
                }
            }
        }, ThreadUtils.getName(this, new String[0]));
        monitor.start();
        return monitor;
    }

    public Thread startMonitor(Logger logger, Level level, Period period, boolean groupSummary) {
        Thread monitor = new Thread(() -> {
            while (true) {
                this.update();
                for (String line : groupSummary ? this.getSummary() : this.getDetails()) {
                    logger.log(level, line);
                }
                try {
                    Thread.sleep(period.getMilliseconds());
                }
                catch (InterruptedException e) {
                    Localise.logWarn(logger, e, "Thread monitor unexpectedly interrupted", new Object[0]);
                    return;
                }
            }
        }, ThreadUtils.getName(this, new String[0]));
        monitor.start();
        return monitor;
    }

    public List<String> getDetails() {
        ArrayList<String> lines = new ArrayList<String>();
        for (String name : this.threads.keySet()) {
            lines.add(name + " - " + this.threads.get(name).getState());
        }
        return lines;
    }

    public List<String> getSummary() {
        ArrayList<String> lines = new ArrayList<String>();
        for (GroupSummary group : this.groups.values()) {
            int count = group.getThreads();
            lines.add(String.format("%s: %d threads", group.getName(), count));
            for (Thread.State state : Thread.State.values()) {
                StateCounter counter = group.get(state);
                int i = counter.getValue();
                if (i <= 0) continue;
                lines.add(String.format("- %d (%d%%) %s", i, i * 100 / count, state.toString()));
            }
        }
        return lines;
    }

    private static class StateCounter {
        Thread.State state;
        int value;

        public StateCounter(Thread.State state) {
            this.state = state;
            this.value = 0;
        }

        public void increment() {
            ++this.value;
        }

        public Thread.State getState() {
            return this.state;
        }

        public int getValue() {
            return this.value;
        }
    }

    private static class GroupSummary {
        private String name;
        private int threads = 0;
        private Map<Thread.State, StateCounter> states = new HashMap<Thread.State, StateCounter>();

        public GroupSummary(String name) {
            this.name = name;
            for (Thread.State state : Thread.State.values()) {
                this.states.put(state, new StateCounter(state));
            }
        }

        public StateCounter get(Thread.State state) {
            return this.states.get((Object)state);
        }

        public void addState(Thread.State state) {
            ++this.threads;
            this.states.get((Object)state).increment();
        }

        public String getName() {
            return this.name;
        }

        public int getThreads() {
            return this.threads;
        }
    }
}

