/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.NumberUtils;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.logging.log4j.Logger;

public class TimeUtils {
    static final Logger logger = LogUtils.getLogger(TimeUtils.class);
    public static Map<Integer, String> calendarDays = new HashMap<Integer, String>();
    public static Map<String, String> monthKeys;
    public static Map<String, TimeZone> timeZones;
    public static TimeZone timeZoneUTC;
    public static String dateTimeFormat;
    public static String dateFormat;
    public static String timeFormat;
    public static Pattern dateTimeRegex;

    public static void initDefaultTimeZone() {
        String id = (String)Configs.get("beyondcron.time.zone");
        if (!StringUtils.isNullOrEmpty(id)) {
            TimeZone timeZone = TimeUtils.getTimeZone(id);
            if (timeZone != null) {
                TimeZone.setDefault(timeZone);
            } else {
                Localise.logError(logger, "unknown timezone %s, using %s instead", id, TimeZone.getDefault().getID());
            }
        }
    }

    public static Date getDate(LocalDate date) {
        return TimeUtils.getDate(date, TimeZone.getDefault());
    }

    public static Date getDate(LocalDate date, TimeZone timeZone) {
        return Date.from(date.atStartOfDay(timeZone.toZoneId()).toInstant());
    }

    public static Date getDate(LocalDateTime dateTime) {
        return TimeUtils.getDate(dateTime, TimeZone.getDefault());
    }

    public static Date getDate(LocalDateTime dateTime, TimeZone timeZone) {
        return Date.from(dateTime.atZone(timeZone.toZoneId()).toInstant());
    }

    public static LocalDateTime getLocalDateTime(Date date) {
        return TimeUtils.getLocalDateTime(date, TimeZone.getDefault());
    }

    public static LocalDateTime getLocalDateTime(Date date, TimeZone timeZone) {
        return LocalDateTime.ofInstant(date.toInstant(), timeZone.toZoneId()).withNano(0);
    }

    public static LocalTime getLocalTime(Time time) {
        return LocalTime.of(time.getHour(), time.getMinute(), time.getSecond());
    }

    public static Time getTime(LocalTime time) {
        return new Time(time.getHour(), time.getMinute(), time.getSecond());
    }

    public static TimeZone getTimeZone(String id) {
        TimeZone timeZone = id == null || id.length() < 1 || id.equalsIgnoreCase("current") ? TimeZone.getDefault() : timeZones.get(id.toLowerCase());
        return timeZone;
    }

    public static String format(long date) {
        return TimeUtils.format(new Date(date), TimeZone.getDefault(), false);
    }

    public static String format(long date, TimeZone timeZone) {
        return TimeUtils.format(new Date(date), timeZone, false);
    }

    public static String format(long date, TimeZone timeZone, boolean full) {
        return TimeUtils.format(new Date(date), timeZone, full);
    }

    public static String format(LocalDateTime dateTime, TimeZone timeZone) {
        return TimeUtils.format(TimeUtils.getDate(dateTime, timeZone), timeZone, false);
    }

    public static String format(LocalDateTime dateTime, TimeZone timeZone, boolean full) {
        return TimeUtils.format(TimeUtils.getDate(dateTime, timeZone), timeZone, full);
    }

    public static String format(Date date) {
        return TimeUtils.format(date, TimeZone.getDefault(), false);
    }

    public static String format(Date date, TimeZone timeZone) {
        return TimeUtils.format(date, timeZone, false);
    }

    public static String format(Date date, TimeZone timeZone, boolean full) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateTimeFormat);
        dateFormat.setTimeZone(timeZone != null ? timeZone : TimeZone.getDefault());
        if (full) {
            return dateFormat.format(date);
        }
        Calendar calendar = dateFormat.getCalendar();
        calendar.setTime(date);
        Period period = Period.between(LocalDate.now(dateFormat.getTimeZone().toZoneId()), LocalDate.of(calendar.get(1), calendar.get(2) + 1, calendar.get(5)));
        if (period.toTotalMonths() == 0L) {
            int days = period.getDays();
            if (days == 0) {
                return String.format("%02d:%02d:%02d %s", calendar.get(11), calendar.get(12), calendar.get(13), Localise.format("today"));
            }
            if (days == 1) {
                return String.format("%02d:%02d:%02d %s", calendar.get(11), calendar.get(12), calendar.get(13), Localise.format("tomorrow"));
            }
            if (days == -1) {
                return String.format("%02d:%02d:%02d %s", calendar.get(11), calendar.get(12), calendar.get(13), Localise.format("yesterday"));
            }
            if (days > 1 && days < 7) {
                return String.format("%02d:%02d:%02d %s", calendar.get(11), calendar.get(12), calendar.get(13), Localise.format(calendarDays.get(calendar.get(7))));
            }
        }
        return String.format("%02d:%02d:%02d %02d/%02d/%04d", calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(5), calendar.get(2) + 1, calendar.get(1));
    }

    public static String formatDateTime(long timestamp, TimeZone timeZone) {
        return TimeUtils.formatTimestamp(timestamp, timeZone, dateTimeFormat, dateTimeFormat);
    }

    public static String formatDateTime(long timestamp, TimeZone timeZone, String format) {
        return TimeUtils.formatTimestamp(timestamp, timeZone, format, dateTimeFormat);
    }

    public static String formatDate(long timestamp, TimeZone timeZone) {
        return TimeUtils.formatTimestamp(timestamp, timeZone, dateFormat, dateFormat);
    }

    public static String formatDate(long timestamp, TimeZone timeZone, String format) {
        return TimeUtils.formatTimestamp(timestamp, timeZone, format, dateFormat);
    }

    public static String formatTime(long timestamp, TimeZone timeZone) {
        return TimeUtils.formatTimestamp(timestamp, timeZone, timeFormat, timeFormat);
    }

    public static String formatTime(LocalDateTime dateTime, TimeZone timeZone) {
        return TimeUtils.formatTimestamp(TimeUtils.getDate(dateTime, timeZone).getTime(), timeZone, timeFormat, timeFormat);
    }

    public static String formatTime(long timestamp, TimeZone timeZone, String format) {
        return TimeUtils.formatTimestamp(timestamp, timeZone, format, timeFormat);
    }

    private static String formatTimestamp(long timestamp, TimeZone timeZone, String format, String defaultFormat) {
        SimpleDateFormat formatter;
        try {
            formatter = new SimpleDateFormat(format);
        }
        catch (Exception e) {
            Localise.logWarn(logger, "invalid date/time format \"%1$s\" using \"%2$s\" instead", format, defaultFormat);
            formatter = new SimpleDateFormat(defaultFormat);
        }
        formatter.setTimeZone(timeZone != null ? timeZone : TimeZone.getDefault());
        return formatter.format(new Date(timestamp));
    }

    public static String formatDateTime(ZonedDateTime dateTime, String format, String defaultFormat) {
        DateTimeFormatter formatter;
        try {
            formatter = DateTimeFormatter.ofPattern(format);
        }
        catch (Exception e) {
            Localise.logWarn(logger, "Invalid date/time format \"%1$s\" using \"%2$s\" instead", format, defaultFormat);
            formatter = DateTimeFormatter.ofPattern(defaultFormat);
        }
        return dateTime.format(formatter);
    }

    public static long parseDateTime(String value, TimeZone timeZone) throws ParseException {
        return TimeUtils.parseDateTime(value).atZone(timeZone.toZoneId()).toEpochSecond() * 1000L;
    }

    public static LocalDateTime parseDateTime(String value) throws ParseException {
        Matcher m = dateTimeRegex.matcher(value);
        if (!m.matches()) {
            throw new ParseException("invalid date/time", 0);
        }
        LocalDateTime now = LocalDateTime.now();
        int hour = Integer.parseInt(m.group(1)) % 24;
        int minute = Integer.parseInt(m.group(2)) % 60;
        int second = NumberUtils.parseInt(m.group(4), 0);
        int day = NumberUtils.parseInt(m.group(6), now.getDayOfMonth());
        int month = NumberUtils.parseInt(m.group(7), now.getMonthValue());
        int year = NumberUtils.parseInt(m.group(9), now.getYear());
        return LocalDateTime.of(year, month, day, hour, minute, second);
    }

    public static long parseTimestamp(String value, TimeZone timeZone, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setTimeZone(timeZone);
        return formatter.parse(value).getTime();
    }

    public static String formatDuration(long value) {
        return TimeUtils.formatDuration(value, false);
    }

    public static String formatDuration(long value, boolean full) {
        long seconds = value / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        if (full) {
            return String.format("%02d:%02d:%02d.%03d", hours, minutes % 60L, seconds % 60L, value % 1000L);
        }
        if (hours > 0L) {
            return String.format("%d:%02d:%02d", hours, minutes % 60L, seconds % 60L);
        }
        if (minutes > 0L) {
            return String.format("%d:%02d", minutes % 60L, seconds % 60L);
        }
        return String.format("%d", seconds % 60L);
    }

    public static boolean isSameDay(long date1, long date2) {
        return TimeUtils.isSameDay(date1, date2, TimeZone.getDefault());
    }

    public static boolean isSameDay(long date1, long date2, TimeZone timeZone) {
        return TimeUtils.isSameDay(new Date(date1), new Date(date2), timeZone);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        return TimeUtils.isSameDay(date1, date2, TimeZone.getDefault());
    }

    public static boolean isSameDay(Date date1, Date date2, TimeZone timeZone) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateTimeFormat);
        dateFormat.setTimeZone(timeZone);
        Calendar calendar = dateFormat.getCalendar();
        calendar.setTime(date1);
        int day1 = calendar.get(6);
        calendar.setTime(date2);
        int day2 = calendar.get(6);
        return day1 == day2;
    }

    public static String getMonthSortKey(String name) {
        String key = monthKeys.get(name.toLowerCase());
        return key != null ? key : name;
    }

    public static String getMonthSortKey(Name value) {
        String key;
        String name = value.getName();
        return name.equals(key = TimeUtils.getMonthSortKey(name)) ? value.toString() : value.getGroupName() + key;
    }

    public static List<Name> sortMonths(List<Name> names) {
        TreeMap<String, Name> nameMap = new TreeMap<String, Name>();
        for (Name name : names) {
            nameMap.put(TimeUtils.getMonthSortKey(name), name);
        }
        return new ArrayList<Name>(nameMap.values());
    }

    static {
        calendarDays.put(1, "Sunday");
        calendarDays.put(2, "Monday");
        calendarDays.put(3, "Tuesday");
        calendarDays.put(4, "Wednesday");
        calendarDays.put(5, "Thursday");
        calendarDays.put(6, "Friday");
        calendarDays.put(7, "Saturday");
        monthKeys = new HashMap<String, String>();
        int i = 0;
        String[] stringArray = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String month = stringArray[j];
            String s = Localise.format(month);
            monthKeys.put(s.toLowerCase(), String.format(" %02d%s", ++i, s));
        }
        timeZones = new HashMap<String, TimeZone>();
        for (String id : TimeZone.getAvailableIDs()) {
            timeZones.put(id.toLowerCase(), TimeZone.getTimeZone(id));
        }
        timeZoneUTC = TimeZone.getTimeZone("UTC");
        dateTimeFormat = (String)Configs.get("beyondcron.datetime.format.full");
        try {
            new SimpleDateFormat(dateTimeFormat);
        }
        catch (IllegalArgumentException e) {
            String s = (String)Configs.getDefault("beyondcron.datetime.format.full");
            Localise.logError(logger, "invalid default date time format \"%1$s\" using \"%2$s\" instead", dateTimeFormat, s);
            dateTimeFormat = s;
        }
        dateFormat = (String)Configs.get("beyondcron.date.format");
        try {
            new SimpleDateFormat(dateFormat);
        }
        catch (IllegalArgumentException e) {
            String s = (String)Configs.getDefault("beyondcron.date.format");
            Localise.logError(logger, "invalid default date format \"%1$s\" using \"%2$s\" instead", dateFormat, s);
            dateFormat = s;
        }
        timeFormat = (String)Configs.get("beyondcron.time.format");
        try {
            new SimpleDateFormat(timeFormat);
        }
        catch (IllegalArgumentException e) {
            String s = (String)Configs.getDefault("HH:mm:ss");
            Localise.logError(logger, "invalid time format \"%1$s\" using \"%2$s\" instead", timeFormat, s);
            timeFormat = s;
        }
        String s = (String)Configs.get("beyondcron.datetime.regex");
        try {
            dateTimeRegex = Pattern.compile(s);
        }
        catch (PatternSyntaxException e) {
            String t = (String)Configs.getDefault("beyondcron.datetime.regex");
            Localise.logError(logger, "invalid date/time format \"%1$s\" using \"%2$s\" instead", s, t);
            dateTimeRegex = Pattern.compile(s);
        }
    }
}

