/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.StringUtils;
import com.beyondcron.core.TableFormatter;
import com.beyondcron.core.Usage;
import com.beyondcron.core.Usages;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class UsageFormatter {
    private Map<String, List<Usage>> commands = new TreeMap<String, List<Usage>>();

    public UsageFormatter(Object bean) {
        for (Method m : bean.getClass().getDeclaredMethods()) {
            Usages usages;
            Usage usage = m.getAnnotation(Usage.class);
            if (usage != null) {
                this.addUsage(usage);
            }
            if ((usages = m.getAnnotation(Usages.class)) == null) continue;
            for (Usage u : usages.value()) {
                this.addUsage(u);
            }
        }
    }

    private void addUsage(Usage usage) {
        String name = usage.name();
        List<Usage> l = this.commands.get(name);
        if (l == null) {
            l = new ArrayList<Usage>();
            this.commands.put(name, l);
        }
        l.add(usage);
    }

    public Set<String> getCommandNames() {
        return this.commands.keySet();
    }

    public List<Usage> getUsages(String name) {
        return this.commands.get(name);
    }

    public void printUsage() {
        this.printUsage((OutputStream)System.out, false);
    }

    public void printUsage(OutputStream out) {
        this.printUsage(out, false);
    }

    public void printUsage(OutputStream out, boolean includeDescription) {
        TableFormatter table = new TableFormatter();
        table.setColumnSeparator("  ");
        for (String name : this.commands.keySet()) {
            this.tableAddCommand(table, name, includeDescription);
        }
        table.print(out);
    }

    public boolean printUsage(OutputStream out, String name) {
        return this.printUsage(out, name, null);
    }

    public boolean printUsage(OutputStream out, String name, List<String> args) {
        TableFormatter table = new TableFormatter();
        table.setColumnSeparator("  ");
        Object key = name;
        if (args != null && args.size() > 0) {
            key = (String)key + " " + StringUtils.join(" ", args);
        }
        for (String s : this.commands.keySet()) {
            if (!s.startsWith((String)key)) continue;
            this.tableAddCommand(table, s, true);
        }
        table.print(out);
        return table.getRowCount() > 0;
    }

    private void tableAddCommand(TableFormatter table, String name, boolean includeDescription) {
        List<Usage> usages = this.commands.get(name);
        if (usages == null | usages.isEmpty()) {
            return;
        }
        for (Usage usage : usages) {
            table.startRow();
            if (usage.args().length() > 0) {
                table.addValue(usage.name() + " " + usage.args());
            } else {
                table.addValue(usage.name());
            }
            if (!includeDescription) continue;
            table.addValue(usage.description());
        }
    }
}

