/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Configs;
import com.beyondcron.core.IOUtils;
import com.beyondcron.core.License;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.Program;
import com.beyondcron.core.Version;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\bJ\u0010\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/beyondcron/core/Versions;", "", "license", "Lcom/beyondcron/core/License;", "(Lcom/beyondcron/core/License;)V", "getLicense", "()Lcom/beyondcron/core/License;", "getLatest", "Lcom/beyondcron/core/Version;", "getLatestLicensed", "isLatest", "", "version", "isLatestLicensed", "Companion", "Bliss-core"})
@SourceDebugExtension(value={"SMAP\nVersions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Versions.kt\ncom/beyondcron/core/Versions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1855#2,2:92\n*S KotlinDebug\n*F\n+ 1 Versions.kt\ncom/beyondcron/core/Versions\n*L\n77#1:92,2\n*E\n"})
public final class Versions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final License license;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Version programVersion;
    @NotNull
    private static final List<Version> versions;
    @Nullable
    private static Exception error;
    private static long updated;

    public Versions(@NotNull License license) {
        Intrinsics.checkNotNullParameter((Object)license, (String)"license");
        this.license = license;
        com.beyondcron.core.Versions$Companion.updateVersions$default(Companion, false, 1, null);
    }

    @NotNull
    public final License getLicense() {
        return this.license;
    }

    @NotNull
    public final Version getLatest() {
        com.beyondcron.core.Versions$Companion.updateVersions$default(Companion, false, 1, null);
        Version version = (Version)CollectionsKt.firstOrNull(versions);
        if (version == null) {
            version = programVersion;
        }
        return version;
    }

    public final boolean isLatest(@NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return version.compareTo(this.getLatest()) >= 0;
    }

    public static /* synthetic */ boolean isLatest$default(Versions versions, Version version, int n, Object object) {
        if ((n & 1) != 0) {
            version = programVersion;
        }
        return versions.isLatest(version);
    }

    @NotNull
    public final Version getLatestLicensed() {
        com.beyondcron.core.Versions$Companion.updateVersions$default(Companion, false, 1, null);
        License.Type type = this.license.getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: {
                Version version = (Version)CollectionsKt.firstOrNull(versions);
                if (version == null) {
                    version = programVersion;
                }
                return version;
            }
        }
        Iterable $this$forEach$iv = versions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Version it = (Version)element$iv;
            boolean bl = false;
            if (it.getBuildDate().compareTo(this.license.getExpiry()) > 0) continue;
            return it;
        }
        return programVersion;
    }

    public final boolean isLatestLicensed(@NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return version.compareTo(this.getLatestLicensed()) >= 0;
    }

    public static /* synthetic */ boolean isLatestLicensed$default(Versions versions, Version version, int n, Object object) {
        if ((n & 1) != 0) {
            version = programVersion;
        }
        return versions.isLatestLicensed(version);
    }

    static {
        Logger logger = LogUtils.getLogger(Versions.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Versions::class.java)");
        Versions.logger = logger;
        Version version = Program.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"getVersion()");
        programVersion = version;
        versions = new ArrayList();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0019R\"\u0010\u0003\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/beyondcron/core/Versions$Companion;", "", "()V", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getError", "()Ljava/lang/Exception;", "setError", "(Ljava/lang/Exception;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "programVersion", "Lcom/beyondcron/core/Version;", "getProgramVersion", "()Lcom/beyondcron/core/Version;", "updated", "", "versions", "", "getVersions", "()Ljava/util/List;", "hasError", "", "updateVersions", "", "force", "Bliss-core"})
    @SourceDebugExtension(value={"SMAP\nVersions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Versions.kt\ncom/beyondcron/core/Versions$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1855#2,2:92\n*S KotlinDebug\n*F\n+ 1 Versions.kt\ncom/beyondcron/core/Versions$Companion\n*L\n36#1:92,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final Version getProgramVersion() {
            return programVersion;
        }

        @NotNull
        public final List<Version> getVersions() {
            return versions;
        }

        @Nullable
        public final Exception getError() {
            return error;
        }

        public final void setError(@Nullable Exception exception) {
            error = exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void updateVersions(boolean force) {
            Version version = this.getProgramVersion();
            synchronized (version) {
                boolean bl = false;
                Object t = Configs.get("beyondcron.versions.ttl");
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type com.beyondcron.core.Period");
                long ttl = ((Period)t).getMilliseconds();
                long now = new Date().getTime();
                if (!force && now < updated + ttl) {
                    return;
                }
                Set versionSet = new LinkedHashSet();
                if (Companion.getProgramVersion().getType() == Version.Type.STABLE) {
                    versionSet.add(Companion.getProgramVersion());
                }
                try {
                    String string = IOUtils.read(new URL((String)Configs.get("beyondcron.url.releases")).openConnection().getInputStream());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"read(URL(Configs.get(Con\u2026ction().getInputStream())");
                    String[] stringArray = new String[]{"\n"};
                    Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        Version version2 = new Version(it);
                        if (version2.getMajor() <= 0) continue;
                        versionSet.add(version2);
                    }
                    updated = now;
                    Companion.setError(null);
                }
                catch (Exception e) {
                    Companion.setError(e);
                }
                Companion.getVersions().clear();
                boolean bl3 = Companion.getVersions().addAll(CollectionsKt.sortedDescending((Iterable)versionSet));
            }
        }

        public static /* synthetic */ void updateVersions$default(Companion companion, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            companion.updateVersions(bl);
        }

        public final boolean hasError() {
            return this.getError() != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[License.Type.values().length];
            try {
                nArray[License.Type.EVALUATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[License.Type.FREE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

