/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.calendar;

import com.beyondcron.core.calendar.ICalendarData;
import java.io.Serializable;
import java.util.Collection;
import java.util.TimeZone;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.util.TimeZones;

public class ICalendarInstance
implements Comparable<ICalendarInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final TimeZone timeZone;
    private Calendar icalendar;

    public ICalendarInstance(ICalendarData data, TimeZone timeZone) {
        this.name = String.format("%s-%s", data.getURI(), timeZone.getID());
        this.timeZone = timeZone;
        this.update(data);
    }

    public String getName() {
        return this.name;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public PeriodList getPeriodList(Period period) {
        PeriodList periods = new PeriodList();
        TimeZones.setDefault((TimeZone)this.timeZone);
        for (Object event : this.icalendar.getComponents("VEVENT")) {
            periods.addAll((Collection)((VEvent)event).calculateRecurrenceSet(period));
        }
        return periods.normalise();
    }

    public ICalendarInstance update(ICalendarData icalendarData) {
        this.icalendar = icalendarData.getICalendar(this.timeZone);
        return this;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ICalendarInstance)) {
            return false;
        }
        return this.compareTo((ICalendarInstance)obj) == 0;
    }

    @Override
    public int compareTo(ICalendarInstance that) {
        return this.name.compareTo(that.name);
    }

    public String toString() {
        return String.format("%s: %s", this.timeZone, this.icalendar);
    }
}

