/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.config;

import com.beyondcron.core.Localise;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.config.Config;
import com.beyondcron.messaging.proto.ProtoConfig;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.json.JSONException;
import org.json.JSONObject;

public class StringConfig
extends Config<String> {
    public static final String DEFAULT_VALUE = "";
    public static final String JSON_REGEX = "regex";
    public static final String JSON_REGEX_DESCRIPTION = "regexDescription";
    private String regex;
    private Pattern regexPattern;
    private String regexDescription;
    private String initValue;

    public StringConfig() {
    }

    public StringConfig(String name, String value) {
        this(name, DEFAULT_VALUE, DEFAULT_VALUE, Pattern.compile(".*"), DEFAULT_VALUE, DEFAULT_VALUE, false, false, false);
        this.setValue(value, Config.Type.USER);
    }

    public StringConfig(String name, String description, String defaultValue, Pattern regexPattern, String regexDescription, String initValue, boolean secret, boolean startup, boolean hidden) {
        super(name, description, StringUtils.isNullOrEmpty(initValue) ? (defaultValue != null ? defaultValue : DEFAULT_VALUE) : null, secret, startup, hidden);
        if (regexPattern != null) {
            this.regexPattern = regexPattern;
            this.regex = regexPattern.toString();
        } else {
            this.regexPattern = null;
            this.regex = null;
        }
        this.regexDescription = !StringUtils.isNullOrEmpty(regexDescription) ? regexDescription : null;
        this.initValue = initValue;
    }

    public String getRegex() {
        return this.regex;
    }

    public String getRegexDescription() {
        return this.regexDescription;
    }

    public String getInitValue() {
        return this.initValue;
    }

    @Override
    public String getValue() {
        if (this.defaultValue == null) {
            this.defaultValue = StringConfig.getConfigInitValue(this.initValue);
        }
        return (String)super.getValue();
    }

    public StringConfig set(String value, Config.Type type) throws IllegalArgumentException {
        this.setValue(value, type);
        return this;
    }

    @Override
    public String validate(String value) {
        if (this.regex == null) {
            return null;
        }
        if (this.regexPattern == null) {
            this.regexPattern = Pattern.compile(this.regex);
        }
        if (this.regexPattern.matcher(value).matches()) {
            return null;
        }
        return this.regexDescription != null ? this.regexDescription : Localise.format("value does not match \"%1$s\"", this.regex);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (!((String)this.defaultValue).equals(DEFAULT_VALUE)) {
            json.put("default", this.defaultValue);
        }
        if (this.regex != null) {
            json.put(JSON_REGEX, this.regex);
        }
        if (this.regexDescription != null) {
            json.put(JSON_REGEX_DESCRIPTION, this.regexDescription);
        }
        return json;
    }

    @Override
    public StringConfig fromJSON(JSONObject json) throws JSONException {
        super.fromJSON(json);
        this.defaultValue = json.optString("default", DEFAULT_VALUE);
        this.regex = json.optString(JSON_REGEX);
        if (!this.regex.isEmpty()) {
            try {
                this.regexPattern = Pattern.compile(json.getString(JSON_REGEX));
            }
            catch (PatternSyntaxException e) {
                throw new JSONException(Localise.format("invalid %1$s - %2$s - %3$s", JSON_REGEX, json.getString(JSON_REGEX), e.getMessage()));
            }
        } else {
            this.regex = null;
        }
        this.regexDescription = json.optString(JSON_REGEX_DESCRIPTION, null);
        return this;
    }

    @Override
    public ProtoConfig.Config.Builder toProto() {
        ProtoConfig.Config.Builder baseBuilder = super.toProto();
        ProtoConfig.ConfigString.Builder builder = ProtoConfig.ConfigString.newBuilder();
        if (this.value != null) {
            builder.setValue((String)this.value);
        }
        if (!StringUtils.isNullOrEmpty(this.initValue)) {
            builder.setInitValue(this.initValue);
        } else if (!((String)this.defaultValue).equals(DEFAULT_VALUE)) {
            builder.setDefaultValue((String)this.defaultValue);
        }
        if (this.regex != null) {
            builder.setRegex(this.regex);
        }
        if (this.regexDescription != null) {
            builder.setRegexDescription(this.regexDescription);
        }
        baseBuilder.setStringExt(builder);
        return baseBuilder;
    }

    @Override
    public StringConfig fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoConfig.ConfigString proto = ProtoConfig.Config.parseFrom(data).getStringExt();
        super.fromProto(data);
        Object object = this.value = proto.hasValue() ? proto.getValue() : null;
        if (proto.hasInitValue()) {
            this.defaultValue = null;
            this.initValue = proto.getInitValue();
        } else {
            this.defaultValue = proto.hasDefaultValue() ? proto.getDefaultValue() : DEFAULT_VALUE;
            this.initValue = null;
        }
        this.regex = proto.hasRegex() ? proto.getRegex() : null;
        this.regexDescription = proto.hasRegexDescription() ? proto.getRegexDescription() : null;
        this.regexPattern = null;
        return this;
    }

    @Override
    public StringConfig duplicate() {
        try {
            return new StringConfig().fromProto(this.toProto().build().toByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            Localise.logError(logger, "Unexpected exception duplicating config - %1$s", e.getMessage());
            return null;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Annotation {
        public String description() default "";

        public String defaultValue() default "";

        public String regex() default ".*";

        public String regexDescription() default "";

        public String initValue() default "";

        public boolean secret() default false;

        public boolean startup() default false;

        public boolean system() default false;

        public boolean hidden() default false;
    }
}

