/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.data;

import com.beyondcron.core.Name;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.security.ACL;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.message.calendar.Calendar;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MultiMap;
import java.util.HashMap;
import java.util.Map;

public class DataValidator {
    private static Map<String, DataValidator> validators = new HashMap<String, DataValidator>();
    private MultiMap<Name, Name> groups;
    private MultiMap<Name, ACL> acls;
    private MultiMap<Name, Name> aclGroups;
    private IMap<Name, Calendar> calendars;
    private MultiMap<Name, Name> calendarGroups;
    private IMap<Name, Job> jobs;
    private MultiMap<Name, Name> jobGroups;

    public static synchronized DataValidator getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        DataValidator validator = validators.get(name);
        if (validator == null) {
            validator = new DataValidator(hazelcast);
            validators.put(name, validator);
        }
        return validator;
    }

    protected DataValidator(HazelcastInstance hazelcast) {
        this.groups = Hazelcast.getGroupTreeMap(hazelcast);
        this.acls = Hazelcast.getACLMap(hazelcast);
        this.aclGroups = Hazelcast.getACLGroupMap(hazelcast);
        this.calendars = Hazelcast.getCalendarMap(hazelcast);
        this.calendarGroups = Hazelcast.getCalendarGroupMap(hazelcast);
        this.jobs = Hazelcast.getJobMap(hazelcast);
        this.jobGroups = Hazelcast.getJobGroupMap(hazelcast);
        this.acls = Hazelcast.getACLMap(hazelcast);
        this.aclGroups = Hazelcast.getACLGroupMap(hazelcast);
    }

    public boolean exists(Name name) {
        return this.jobs.containsKey((Object)name) || this.calendars.containsKey((Object)name) || this.acls.containsKey((Object)name) || this.groups.containsKey((Object)name) || this.jobGroups.containsKey((Object)name) || this.calendarGroups.containsKey((Object)name);
    }

    public boolean isACL(Name name) {
        return this.acls.containsKey((Object)name);
    }

    public boolean isCalendar(Name name) {
        return this.calendars.containsKey((Object)name);
    }

    public boolean isJob(Name name) {
        return this.jobs.containsKey((Object)name);
    }
}

