/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.io;

import com.beyondcron.core.Configs;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.Role;
import com.beyondcron.core.config.Config;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.security.ACL;
import com.beyondcron.core.security.HostACL;
import com.beyondcron.core.security.Protected;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.CommandConnection;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.message.CommandMessage;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.message.calendar.Calendar;
import com.hazelcast.core.HazelcastInstance;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.Logger;

public abstract class AbstractIO {
    static final Logger logger = LogUtils.getLogger(AbstractIO.class);
    public static final String JSON_ACLS = "acls";
    public static final String JSON_CALENDARS = "calendars";
    public static final String JSON_CONFIGS = "configs";
    public static final String JSON_HOSTS = "hosts";
    public static final String JSON_JOBS = "jobs";
    public static final String JSON_NAMES = "names";
    public static final String JSON_PROPERTIES = "properties";
    public static final String JSON_PROTECTED = "protected";
    public static final String JSON_ROLES = "roles";
    public static final String JSON_USERS = "users";
    private CommandConnection connection;
    private Set<ACL> acls = new TreeSet<ACL>();
    private Set<Calendar> calendars = new TreeSet<Calendar>();
    private Set<Config> configs = new TreeSet<Config>();
    private Set<HostACL> hostAcls = new TreeSet<HostACL>();
    private Set<Job> jobs = new TreeSet<Job>();
    private Set<Property> properties = new TreeSet<Property>(new Property.FullComparator());
    private Set<String> protectedHosts = new TreeSet<String>();
    private Set<String> protectedUsers = new TreeSet<String>();
    private Set<User> users = new TreeSet<User>();
    private Set<Role> roles = new TreeSet<Role>();

    protected AbstractIO(CommandConnection connection) {
        this.connection = connection;
    }

    protected CommandConnection getConnection() {
        return this.connection;
    }

    protected HazelcastInstance getHazelcast() {
        return this.connection.getHazelcast();
    }

    protected ResultMessage sendReceive(CommandMessage command) {
        return this.connection.sendReceive(command);
    }

    public boolean isEmpty() {
        return this.acls.isEmpty() && this.calendars.isEmpty() && this.hostAcls.isEmpty() && this.jobs.isEmpty() && this.properties.isEmpty() && this.protectedHosts.isEmpty() && this.protectedUsers.isEmpty() && this.users.isEmpty() && this.roles.isEmpty();
    }

    protected void addACL(ACL acl) {
        this.acls.add(acl);
    }

    public boolean hasACLs() {
        return !this.acls.isEmpty();
    }

    public Set<ACL> getACLs() {
        return this.acls;
    }

    protected void addCalendar(Calendar calendar) {
        this.calendars.add(calendar);
    }

    public boolean hasCalendars() {
        return !this.calendars.isEmpty();
    }

    public Set<Calendar> getCalendars() {
        return this.calendars;
    }

    public void addConfig(Config config) {
        this.configs.add(config);
    }

    public void includeConfigs() {
        for (Config config : Configs.getConfigs(false)) {
            if (config.isDefault()) continue;
            this.configs.add(config);
        }
    }

    public boolean hasConfigs() {
        return !this.configs.isEmpty();
    }

    public Set<Config> getConfigs() {
        return this.configs;
    }

    public void addHostACL(HostACL acl) {
        this.hostAcls.add(acl);
    }

    public void includeHostACls() {
        this.hostAcls.addAll(Hazelcast.getACLHostMap(this.connection.getHazelcast()).values());
    }

    public boolean hasHostACLs() {
        return !this.hostAcls.isEmpty();
    }

    public Set<HostACL> getHostAcls() {
        return this.hostAcls;
    }

    protected void addJob(Job job) {
        this.jobs.add(job);
    }

    public boolean hasJobs() {
        return !this.jobs.isEmpty();
    }

    public Set<Job> getJobs() {
        return this.jobs;
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public boolean hasProperties() {
        return !this.properties.isEmpty();
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    public void addProtected(Protected.Type type, String value) {
        switch (type) {
            case HOST: {
                this.protectedHosts.add(value);
                break;
            }
            case USER: {
                this.protectedUsers.add(value);
                break;
            }
            default: {
                logger.error("unsupported protected type {}", (Object)type.toString());
            }
        }
    }

    public void includeProtected(Protected.Type type) {
        switch (type) {
            case HOST: {
                this.protectedHosts.addAll(Hazelcast.getProtectedNames(this.connection.getHazelcast()).get((Object)type));
                break;
            }
            case USER: {
                this.protectedUsers.addAll(Hazelcast.getProtectedNames(this.connection.getHazelcast()).get((Object)type));
                break;
            }
            default: {
                logger.error("unsupported protected type {}", (Object)type.toString());
            }
        }
    }

    public boolean hasProtected(Protected.Type type) {
        switch (type) {
            case HOST: {
                return !this.protectedHosts.isEmpty();
            }
            case USER: {
                return !this.protectedUsers.isEmpty();
            }
        }
        logger.error("unsupported protected type {}", (Object)type.toString());
        return false;
    }

    public Set<String> getProtected(Protected.Type type) {
        switch (type) {
            case HOST: {
                return this.protectedHosts;
            }
            case USER: {
                return this.protectedUsers;
            }
        }
        logger.error("unsupported protected type {}", (Object)type.toString());
        return new TreeSet<String>();
    }

    protected void addRole(Role role) {
        this.roles.add(role);
    }

    public boolean hasRoles() {
        return !this.roles.isEmpty();
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    protected void addUser(User user) {
        this.users.add(user);
    }

    public boolean hasUsers() {
        return !this.users.isEmpty();
    }

    public Set<User> getUsers() {
        return this.users;
    }

    public boolean checkAccess(Name name, ACL.Permission permission) {
        return this.connection.isAdminUser() || this.connection.hasPermission(name, permission);
    }

    public static enum DATA_FORMAT {
        JSON,
        YAML;

    }

    public static enum DataType {
        USER(1, "User"),
        ROLE(2, "Role"),
        ACL(4, "ACL"),
        CALENDAR(8, "Calendar"),
        CONFIG(16, "Config"),
        JOB(32, "Job"),
        HOST(64, "Host"),
        PROTECTED(128, "Protected"),
        PROPERTY(256, "Property"),
        DEFAULT(296, "Default"),
        ALL(65535, "All");

        private int bits;
        private String label;

        private DataType(int bits, String label) {
            this.bits = bits;
            this.label = label;
        }

        public int getBits() {
            return this.bits;
        }

        public String getLabel() {
            return this.label;
        }

        public static Set<DataType> getDefaultTypes() {
            return DataType.getTypes(DataType.DEFAULT.bits);
        }

        public static Set<DataType> consolidateTypes(Set<DataType> types) {
            int bits = 0;
            for (DataType value : types) {
                bits |= value.bits;
            }
            return DataType.getTypes(bits);
        }

        private static Set<DataType> getTypes(int bits) {
            HashSet<DataType> consolidated = new HashSet<DataType>();
            if ((bits & DataType.ACL.bits) != 0) {
                consolidated.add(ACL);
            }
            if ((bits & DataType.CALENDAR.bits) != 0) {
                consolidated.add(CALENDAR);
            }
            if ((bits & DataType.CONFIG.bits) != 0) {
                consolidated.add(CONFIG);
            }
            if ((bits & DataType.HOST.bits) != 0) {
                consolidated.add(HOST);
            }
            if ((bits & DataType.JOB.bits) != 0) {
                consolidated.add(JOB);
            }
            if ((bits & DataType.PROPERTY.bits) != 0) {
                consolidated.add(PROPERTY);
            }
            if ((bits & DataType.PROTECTED.bits) != 0) {
                consolidated.add(PROTECTED);
            }
            if ((bits & DataType.ROLE.bits) != 0) {
                consolidated.add(ROLE);
            }
            if ((bits & DataType.USER.bits) != 0) {
                consolidated.add(USER);
            }
            return consolidated;
        }

        public static DataType getDataType(String name) {
            switch (name.toLowerCase()) {
                case "all": {
                    return ALL;
                }
                case "acl": 
                case "acls": {
                    return ACL;
                }
                case "calendar": 
                case "calendars": {
                    return CALENDAR;
                }
                case "config": 
                case "configs": {
                    return CONFIG;
                }
                case "host": 
                case "hosts": {
                    return HOST;
                }
                case "job": 
                case "jobs": {
                    return JOB;
                }
                case "property": 
                case "properties": {
                    return PROPERTY;
                }
                case "protected": {
                    return PROTECTED;
                }
                case "role": 
                case "roles": {
                    return ROLE;
                }
                case "user": 
                case "users": {
                    return USER;
                }
            }
            throw new IllegalArgumentException(name);
        }
    }
}

