/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.io;

import com.beyondcron.core.BlissUtils;
import com.beyondcron.core.CollectionUtils;
import com.beyondcron.core.JSONUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.Role;
import com.beyondcron.core.config.Config;
import com.beyondcron.core.config.ConfigProperty;
import com.beyondcron.core.io.AbstractIO;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.security.ACL;
import com.beyondcron.core.security.HostACL;
import com.beyondcron.core.security.Protected;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.CommandConnection;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.message.calendar.Calendar;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MultiMap;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONObject;

public class ExportIO
extends AbstractIO {
    private Name root;
    private Set<AbstractIO.DataType> types = new TreeSet<AbstractIO.DataType>();
    private MultiMap<Name, Name> groups;
    private MultiMap<Name, ACL> acls;
    private IMap<Name, Calendar> calendars;
    private MultiMap<Name, Name> calendarGroups;
    private IMap<Name, Job> jobs;
    private MultiMap<Name, Name> jobGroups;

    public ExportIO(CommandConnection connection, Name root) {
        super(connection);
        this.root = root;
        HazelcastInstance hazelcast = this.getHazelcast();
        this.groups = Hazelcast.getGroupTreeMap(hazelcast);
        this.acls = Hazelcast.getACLMap(hazelcast);
        this.calendars = Hazelcast.getCalendarMap(hazelcast);
        this.calendarGroups = Hazelcast.getCalendarGroupMap(hazelcast);
        this.jobs = Hazelcast.getJobMap(hazelcast);
        this.jobGroups = Hazelcast.getJobGroupMap(hazelcast);
    }

    public void writeJSON(OutputStream out) {
        new PrintStream(out).println(this.buildJSON().toString(2));
    }

    public void writeYAML(OutputStream out) {
        new PrintStream(out).println(JSONUtils.toYAML(this.buildJSON()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject buildJSON() {
        JSONObject json = new JSONObject();
        if (this.root != null) {
            Name.setThreadRoot(this.root);
        } else {
            Name.clearThreadRoot();
        }
        try {
            JSONArray array;
            if (this.hasConfigs()) {
                boolean showSecrets = this.checkAccess(BlissUtils.ACL_DIR_CONFIGURATION, ACL.Permission.WRITE);
                array = new JSONArray();
                for (Config config : this.getConfigs()) {
                    array.put(new ConfigProperty(config.getName(), !config.isSecret() || showSecrets ? config.getValue().toString() : "********").toJSON());
                }
                json.put("configs", array);
            }
            if (this.hasRoles()) {
                array = new JSONArray();
                for (Role role : this.getRoles()) {
                    array.put(role.toJSON());
                }
                json.put("roles", array);
            }
            if (this.hasUsers()) {
                array = new JSONArray();
                for (User user : this.getUsers()) {
                    array.put(user.toJSON());
                }
                json.put("users", array);
            }
            JSONObject object = new JSONObject();
            if (this.hasACLs()) {
                array = new JSONArray();
                for (ACL aCL : this.getACLs()) {
                    array.put(aCL.toJSON());
                }
                object.put("names", array);
            }
            if (this.hasHostACLs()) {
                array = new JSONArray();
                for (HostACL hostACL : this.getHostAcls()) {
                    array.put(hostACL.toJSON());
                }
                object.put("hosts", array);
            }
            JSONObject obj = new JSONObject();
            if (this.hasProtected(Protected.Type.HOST)) {
                array = new JSONArray();
                for (String host : this.getProtected(Protected.Type.HOST)) {
                    array.put(host);
                }
                obj.put("hosts", array);
            }
            if (this.hasProtected(Protected.Type.USER)) {
                array = new JSONArray();
                for (String user : this.getProtected(Protected.Type.USER)) {
                    array.put(user);
                }
                obj.put("users", array);
            }
            if (!obj.keySet().isEmpty()) {
                object.put("protected", obj);
            }
            if (!object.keySet().isEmpty()) {
                json.put("acls", object);
            }
            if (this.hasCalendars()) {
                array = new JSONArray();
                for (Calendar calendar : this.getCalendars()) {
                    array.put(calendar.toJSON());
                }
                json.put("calendars", array);
            }
            if (this.hasProperties()) {
                array = new JSONArray();
                for (Property property : this.getProperties()) {
                    array.put(property.toJSON(this.checkAccess(property.getGroup(), ACL.Permission.WRITE)));
                }
                json.put("properties", array);
            }
            if (this.hasJobs()) {
                array = new JSONArray();
                for (Job job : this.getJobs()) {
                    array.put(job.toJSON(this.checkAccess(job.getName(), ACL.Permission.WRITE)));
                }
                json.put("jobs", array);
            }
        }
        finally {
            Name.clearThreadRoot();
        }
        return json;
    }

    public boolean exists(Name name) {
        return this.groups.containsKey((Object)name) || this.acls.containsKey((Object)name) || this.calendars.containsKey((Object)name) || this.calendarGroups.containsKey((Object)name) || this.jobs.containsKey((Object)name) || this.jobGroups.containsKey((Object)name);
    }

    public Set<AbstractIO.DataType> getTypes() {
        return this.types;
    }

    public void add(Name name, Set<AbstractIO.DataType> types) {
        if (types.contains((Object)AbstractIO.DataType.ACL)) {
            this.addNameACLs(name);
        }
        if (name.equals(Name.ROOT)) {
            if (types.contains((Object)AbstractIO.DataType.CONFIG) && this.checkAccess(BlissUtils.ACL_DIR_CONFIGURATION, ACL.Permission.READ)) {
                this.addConfigs();
            }
            if (types.contains((Object)AbstractIO.DataType.HOST) && this.checkAccess(BlissUtils.ACL_DIR_HOST_ACLS, ACL.Permission.READ)) {
                this.addHostACLs();
            }
            if (types.contains((Object)AbstractIO.DataType.PROTECTED) && this.checkAccess(BlissUtils.ACL_DIR_PROTECTED, ACL.Permission.READ)) {
                this.addProtected(Protected.Type.HOST);
                this.addProtected(Protected.Type.USER);
            }
        }
        if (types.contains((Object)AbstractIO.DataType.PROPERTY)) {
            this.addProperties(name);
        }
        if (types.contains((Object)AbstractIO.DataType.CALENDAR)) {
            this.addCalendars(name);
        }
        if (types.contains((Object)AbstractIO.DataType.JOB)) {
            this.addJobs(name);
        }
    }

    private void addConfigs() {
        this.includeConfigs();
        if (this.hasConfigs()) {
            this.types.add(AbstractIO.DataType.CONFIG);
        }
    }

    private void addNameACLs(Name name) {
        for (ACL acl : CollectionUtils.sort(Hazelcast.getValues(this.acls, name))) {
            if (!this.checkAccess(acl.getName(), ACL.Permission.READ)) continue;
            this.addACL(acl);
        }
        if (this.hasACLs()) {
            this.types.add(AbstractIO.DataType.ACL);
        }
    }

    private void addHostACLs() {
        this.includeHostACls();
        if (this.hasHostACLs()) {
            this.types.add(AbstractIO.DataType.HOST);
        }
    }

    private void addProperties(Name name) {
        for (Property property : Hazelcast.getValues(Hazelcast.getPropertyMap(this.getHazelcast()), name)) {
            if (!this.checkAccess(property.getGroup(), ACL.Permission.READ)) continue;
            this.addProperty(property);
        }
        if (this.hasProperties()) {
            this.types.add(AbstractIO.DataType.PROPERTY);
        }
    }

    private void addProtected(Protected.Type type) {
        this.includeProtected(type);
        if (this.hasProtected(type)) {
            this.types.add(AbstractIO.DataType.PROTECTED);
        }
    }

    private void addCalendars(Name name) {
        for (Calendar calendar : CollectionUtils.sort(Hazelcast.getValues(this.groups, this.calendarGroups, this.calendars, name))) {
            if (!this.checkAccess(calendar.getName(), ACL.Permission.READ)) continue;
            this.addCalendar(calendar);
        }
        if (this.hasCalendars()) {
            this.types.add(AbstractIO.DataType.CALENDAR);
        }
    }

    private void addJobs(Name name) {
        for (Job job : CollectionUtils.sort(Hazelcast.getValues(this.groups, this.jobGroups, this.jobs, name))) {
            if (!this.checkAccess(job.getName(), ACL.Permission.READ)) continue;
            this.addJob(job);
        }
        if (this.hasJobs()) {
            this.types.add(AbstractIO.DataType.JOB);
        }
    }

    private void addUsers() {
        if (this.checkAccess(BlissUtils.ACL_DIR_USERS, ACL.Permission.ADMIN)) {
            for (User user : Hazelcast.getUserMap(this.getHazelcast()).values()) {
                if (user.isReadOnly()) continue;
                this.addUser(user);
            }
        }
        if (this.hasUsers()) {
            this.types.add(AbstractIO.DataType.USER);
        }
    }

    private void addRoles() {
        if (this.checkAccess(BlissUtils.ACL_DIR_ROLES, ACL.Permission.ADMIN)) {
            for (Role role : Hazelcast.getRoleMap(this.getHazelcast()).values()) {
                if (role.isReadOnly()) continue;
                this.addRole(role);
            }
        }
        if (this.hasRoles()) {
            this.types.add(AbstractIO.DataType.ROLE);
        }
    }
}

