/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.io;

import com.beyondcron.core.BlissUtils;
import com.beyondcron.core.CollectionUtils;
import com.beyondcron.core.Configs;
import com.beyondcron.core.JSONUtils;
import com.beyondcron.core.Localise;
import com.beyondcron.core.MultiMapClone;
import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.Result;
import com.beyondcron.core.Role;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.config.Config;
import com.beyondcron.core.config.ConfigProperty;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.core.io.AbstractIO;
import com.beyondcron.core.job.Command;
import com.beyondcron.core.job.CommandJob;
import com.beyondcron.core.job.Condition;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.VariableFormatter;
import com.beyondcron.core.property.PropertyValidator;
import com.beyondcron.core.security.ACL;
import com.beyondcron.core.security.HostACL;
import com.beyondcron.core.security.Protected;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.CommandConnection;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.NamedMessage;
import com.beyondcron.messaging.message.ACLCommand;
import com.beyondcron.messaging.message.CalendarCommand;
import com.beyondcron.messaging.message.CommandMessage;
import com.beyondcron.messaging.message.ConfigCommand;
import com.beyondcron.messaging.message.HostACLCommand;
import com.beyondcron.messaging.message.JobCommand;
import com.beyondcron.messaging.message.JobControl;
import com.beyondcron.messaging.message.Link;
import com.beyondcron.messaging.message.PersistCommand;
import com.beyondcron.messaging.message.PropertyCommand;
import com.beyondcron.messaging.message.ProtectedCommand;
import com.beyondcron.messaging.message.ResultMessage;
import com.beyondcron.messaging.message.RoleCommand;
import com.beyondcron.messaging.message.UserCommand;
import com.beyondcron.messaging.message.calendar.Calendar;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MultiMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ImportIO
extends AbstractIO {
    private int changeGroup = com.beyondcron.messaging.message.Change.createGroup();
    private Mode mode;
    private Map<String, String> variables;
    private Name root;
    private List<Error> errors = new ArrayList<Error>();
    private List<Change> changes = new ArrayList<Change>();
    private List<Change> changed = new ArrayList<Change>();
    private MultiMapClone<Name, Name> calendarJobs = null;
    private Set<Name> calendarsIn = new HashSet<Name>();
    private MultiMap<Name, Name> groups;

    public ImportIO(CommandConnection connection, AbstractIO.DATA_FORMAT format, InputStream in, Name root, Set<AbstractIO.DataType> types, Map<String, String> variables, Mode mode) throws IOException {
        super(connection);
        HazelcastInstance hazelcast = this.getHazelcast();
        this.groups = Hazelcast.getGroupTreeMap(hazelcast);
        this.calendarJobs = new MultiMapClone<Name, Name>(Hazelcast.getCalendarJobMap(hazelcast));
        this.variables = variables;
        this.mode = mode;
        switch (format) {
            case JSON: {
                this.readJSON(in, root, types);
                break;
            }
            case YAML: {
                this.readYAML(in, root, types);
            }
        }
        this.initChanges(types);
    }

    private void addError(Error error) {
        this.errors.add(error);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    private void initChanges(Set<AbstractIO.DataType> types) {
        this.changes.clear();
        if (types.contains((Object)AbstractIO.DataType.CONFIG)) {
            this.initConfigs();
        }
        if (types.contains((Object)AbstractIO.DataType.ACL)) {
            this.initNameACLChanges();
        }
        if (this.root.equals(Name.ROOT)) {
            if (types.contains((Object)AbstractIO.DataType.HOST)) {
                this.initHostACLChanges();
            }
            if (types.contains((Object)AbstractIO.DataType.PROTECTED)) {
                this.initProtectedChanges(Protected.Type.HOST);
                this.initProtectedChanges(Protected.Type.USER);
            }
        }
        if (types.contains((Object)AbstractIO.DataType.PROPERTY)) {
            this.initPropertyChanges();
        }
        if (types.contains((Object)AbstractIO.DataType.CALENDAR)) {
            this.initCalendarInserts();
        }
        if (types.contains((Object)AbstractIO.DataType.JOB)) {
            this.initJobChanges();
        }
        if (types.contains((Object)AbstractIO.DataType.CALENDAR)) {
            this.initCalendarDeletes();
        }
    }

    private void initConfigs() {
        for (Config config : this.getConfigs()) {
            Config currentConfig = Configs.getConfig(config.getName());
            if (currentConfig == null) {
                this.addChange(AbstractIO.DataType.CONFIG, Change.Type.CREATE, config.getPath(), config);
                continue;
            }
            if (config.getValue().equals(currentConfig.getValue())) continue;
            this.addChange(AbstractIO.DataType.CONFIG, Change.Type.UPDATE, config.getPath(), config);
        }
    }

    private void initNameACLChanges() {
        HashMap<Name, ACL> currentAcls = new HashMap<Name, ACL>();
        for (ACL acl : Hazelcast.getValues(Hazelcast.getACLMap(this.getHazelcast()), this.root)) {
            currentAcls.put(acl.getPersistName(), acl);
        }
        HashMap<Name, ACL> aclsIn = new HashMap<Name, ACL>();
        for (ACL acl : this.getACLs()) {
            aclsIn.put(acl.getPersistName(), acl);
        }
        if (this.mode == Mode.REPLACE) {
            for (ACL acl : currentAcls.values()) {
                if (aclsIn.containsKey(acl.getPersistName()) || !this.validate(acl.getName(), ACL.Permission.ADMIN, AbstractIO.DataType.ACL)) continue;
                this.addChange(AbstractIO.DataType.ACL, Change.Type.DELETE, acl);
            }
        }
        for (ACL acl : aclsIn.values()) {
            ACL a = (ACL)currentAcls.get(acl.getPersistName());
            if (a != null) {
                if (JSONUtils.equals(acl, a)) continue;
                this.addChange(AbstractIO.DataType.ACL, Change.Type.UPDATE, acl);
                continue;
            }
            this.addChange(AbstractIO.DataType.ACL, Change.Type.CREATE, acl);
        }
    }

    private void initHostACLChanges() {
        HashMap<Name, HostACL> currentAcls = new HashMap<Name, HostACL>();
        for (HostACL acl : Hazelcast.getACLHostMap(this.getHazelcast()).values()) {
            currentAcls.put(acl.getPersistName(), acl);
        }
        HashMap<Name, HostACL> aclsIn = new HashMap<Name, HostACL>();
        for (HostACL acl : this.getHostAcls()) {
            aclsIn.put(acl.getPersistName(), acl);
        }
        if (this.mode == Mode.REPLACE) {
            for (HostACL acl : currentAcls.values()) {
                if (aclsIn.containsKey(acl.getPersistName())) continue;
                this.addChange(AbstractIO.DataType.ACL, Change.Type.DELETE, acl);
            }
        }
        for (HostACL acl : aclsIn.values()) {
            HostACL a = (HostACL)currentAcls.get(acl.getPersistName());
            if (a != null) {
                if (JSONUtils.equals(acl, a)) continue;
                this.addChange(AbstractIO.DataType.ACL, Change.Type.UPDATE, acl);
                continue;
            }
            this.addChange(AbstractIO.DataType.ACL, Change.Type.CREATE, acl);
        }
    }

    private void initCalendarInserts() {
        HazelcastInstance hazelcast = this.getHazelcast();
        IMap<Name, Calendar> currentCalendars = Hazelcast.getCalendarMap(hazelcast);
        for (Calendar calendar : this.getCalendars()) {
            Name name = calendar.getName();
            Calendar c = (Calendar)currentCalendars.get((Object)name);
            if (c != null) {
                if (!JSONUtils.equals(calendar, c)) {
                    this.addChange(AbstractIO.DataType.CALENDAR, Change.Type.UPDATE, calendar.getName(), calendar);
                }
            } else {
                this.addChange(AbstractIO.DataType.CALENDAR, Change.Type.CREATE, calendar.getName(), calendar);
            }
            this.calendarsIn.add(name);
        }
    }

    private void initCalendarDeletes() {
        if (this.mode != Mode.REPLACE) {
            return;
        }
        HazelcastInstance hazelcast = this.getHazelcast();
        IMap<Name, Calendar> currentCalendars = Hazelcast.getCalendarMap(hazelcast);
        MultiMap<Name, Name> calendarGroups = Hazelcast.getCalendarGroupMap(hazelcast);
        for (Calendar calendar : CollectionUtils.sort(Hazelcast.getValues(this.groups, calendarGroups, currentCalendars, this.root))) {
            Name name = calendar.getName();
            if (this.calendarsIn.contains(name) || this.calendarJobs.containsKey(name)) continue;
            if (this.validate(name, ACL.Permission.WRITE, AbstractIO.DataType.CALENDAR)) {
                this.addChange(AbstractIO.DataType.CALENDAR, Change.Type.DELETE, name);
                continue;
            }
            this.addError(new Error(AbstractIO.DataType.CALENDAR, Error.Type.PERMISSION, name, Localise.format("Calendar in use, cannot delete.")));
        }
    }

    private void initJobChanges() {
        Name name;
        HazelcastInstance hazelcast = this.getHazelcast();
        IMap<Name, Calendar> currentCalendars = Hazelcast.getCalendarMap(hazelcast);
        IMap<Name, Job> currentJobs = Hazelcast.getJobMap(hazelcast);
        MultiMap<Name, Name> jobGroups = Hazelcast.getJobGroupMap(hazelcast);
        PropertyValidator properties = PropertyValidator.getInstance(hazelcast);
        Set<Job> jobsIn = this.getJobs();
        for (Job job : jobsIn) {
            Object hostName;
            Job tJob = job.duplicate();
            tJob.setProperties(properties.getProperties(tJob.getName(), true));
            VariableFormatter formatter = new VariableFormatter(tJob);
            boolean hostUserChanged = false;
            if (job instanceof CommandJob) {
                String userName;
                CommandJob cJob = (CommandJob)job;
                Command command = cJob.getCommand();
                if (command != null) {
                    try {
                        command.validate();
                    }
                    catch (IllegalArgumentException e) {
                        this.addError(new Error(AbstractIO.DataType.JOB, Error.Type.SYNTAX, job.getName(), e.getMessage()));
                    }
                }
                if (!StringUtils.isNullOrEmpty((String)(hostName = this.variables.get("job.host")))) {
                    cJob.setHostName((String)hostName);
                    hostUserChanged = true;
                } else {
                    hostName = cJob.getHostName();
                }
                if (VariableFormatter.containsVariable((String)hostName)) {
                    hostName = VariableFormatter.expand((String)hostName, this.variables);
                    hostName = formatter.expand((String)hostName);
                    cJob.setHostName((String)hostName);
                    hostUserChanged = true;
                }
                if (!StringUtils.isNullOrEmpty(userName = this.variables.get("job.user"))) {
                    cJob.setUserName(userName);
                    hostUserChanged = true;
                } else {
                    userName = cJob.getUserName();
                }
                if (VariableFormatter.containsVariable(userName)) {
                    userName = VariableFormatter.expand(userName, this.variables);
                    userName = formatter.expand(userName);
                    cJob.setUserName(userName);
                    hostUserChanged = true;
                }
                if (hostUserChanged) {
                    ((CommandJob)tJob).setHostName((String)hostName);
                    ((CommandJob)tJob).setUserName(userName);
                }
            }
            boolean propertiesChanged = false;
            ArrayList<Property> propertyList = new ArrayList<Property>(job.getProperties());
            hostName = propertyList.iterator();
            while (hostName.hasNext()) {
                Property property = (Property)hostName.next();
                String value = this.variables.get(property.getName());
                if (value == null) continue;
                property.setValue(value);
                job.setProperty(property);
                propertiesChanged = true;
            }
            if (hostUserChanged || propertiesChanged) {
                formatter = new VariableFormatter(tJob);
            }
            String description = VariableFormatter.expand(job.getDescription(), this.variables);
            job.setDescription(formatter.expand(description));
            if (!job.hasCalendar()) continue;
            Name name2 = job.getCalendar();
            if (!this.calendarsIn.contains(name2) && !currentCalendars.containsKey((Object)name2)) {
                this.addError(new Error(AbstractIO.DataType.JOB, Error.Type.DEPENDENCY, job.getName(), Localise.format("Calendar %s does not exist", name2.toString())));
                continue;
            }
            this.calendarJobs.put(name2, job.getName());
        }
        if (this.mode == Mode.REPLACE) {
            for (Job job : CollectionUtils.sort(Hazelcast.getValues(this.groups, jobGroups, currentJobs, this.root))) {
                if (jobsIn.contains(job) || !this.validate(name = job.getName(), ACL.Permission.WRITE, AbstractIO.DataType.JOB)) continue;
                this.addChange(AbstractIO.DataType.JOB, Change.Type.DELETE, name);
                if (!job.hasCalendar()) continue;
                this.calendarJobs.remove(job.getCalendar(), name);
            }
        }
        for (Job job : jobsIn) {
            name = job.getName();
            Job j = (Job)currentJobs.get((Object)name);
            if (j != null) {
                if (JSONUtils.equals(job, j)) continue;
                this.addChange(AbstractIO.DataType.JOB, Change.Type.UPDATE, job.getName(), job);
                continue;
            }
            this.addChange(AbstractIO.DataType.JOB, Change.Type.CREATE, job.getName(), job);
        }
    }

    private void initPropertyChanges() {
        HashMap<Name, Property> currentProperties = new HashMap<Name, Property>();
        for (Property property : Hazelcast.getValues(Hazelcast.getPropertyMap(this.getHazelcast()), this.root)) {
            currentProperties.put(property.getPersistName(), property);
        }
        HashMap<Name, Property> propertiesIn = new HashMap<Name, Property>();
        for (Property property : this.getProperties()) {
            String value = this.variables.get(property.getName());
            if (value != null) {
                property.setValue(value);
            }
            propertiesIn.put(property.getPersistName(), property);
        }
        if (this.mode == Mode.REPLACE) {
            for (Property property : currentProperties.values()) {
                if (propertiesIn.containsKey(property.getPersistName()) || !this.validate(property.getGroup(), ACL.Permission.WRITE, AbstractIO.DataType.PROPERTY)) continue;
                this.addChange(AbstractIO.DataType.PROPERTY, Change.Type.DELETE, property.getGroup(), property);
            }
        }
        for (Property property : propertiesIn.values()) {
            Property p = (Property)currentProperties.get(property.getPersistName());
            if (p != null) {
                if (property.equals(p)) continue;
                this.addChange(AbstractIO.DataType.PROPERTY, Change.Type.UPDATE, property.getGroup(), property);
                continue;
            }
            this.addChange(AbstractIO.DataType.PROPERTY, Change.Type.CREATE, property.getGroup(), property);
        }
    }

    private void initProtectedChanges(Protected.Type type) {
        Collection currentProtected = Hazelcast.getProtectedNames(this.getHazelcast()).get((Object)type);
        Set<String> protectedIn = this.getProtected(type);
        if (this.mode == Mode.REPLACE) {
            for (String value : currentProtected) {
                if (protectedIn.contains(value)) continue;
                this.addChange(AbstractIO.DataType.ACL, Change.Type.DELETE, new Protected(type, value));
            }
        }
        for (String value : protectedIn) {
            if (currentProtected.contains(value)) continue;
            this.addChange(AbstractIO.DataType.ACL, Change.Type.CREATE, new Protected(type, value));
        }
    }

    private void initRoleChanges() {
        IMap<String, Role> currentRoles = Hazelcast.getRoleMap(this.getHazelcast());
        Set<Role> rolesIn = this.getRoles();
        if (this.mode == Mode.REPLACE) {
            for (Role role : currentRoles.values()) {
                if (role.isReadOnly() || rolesIn.contains(role)) continue;
                this.addChange(AbstractIO.DataType.ROLE, Change.Type.DELETE, role.getName());
            }
        }
        for (Role role : rolesIn) {
            String name = role.getName();
            Role r = (Role)currentRoles.get((Object)name);
            if (r != null) {
                if (JSONUtils.equals(role, r)) continue;
                this.addChange(AbstractIO.DataType.ROLE, Change.Type.UPDATE, name);
                continue;
            }
            this.addChange(AbstractIO.DataType.ROLE, Change.Type.CREATE, name);
        }
    }

    private void initUserChanges() {
        IMap<String, User> currentUsers = Hazelcast.getUserMap(this.getHazelcast());
        Set<User> usersIn = this.getUsers();
        if (this.mode == Mode.REPLACE) {
            for (User user : currentUsers.values()) {
                if (user.isReadOnly() || usersIn.contains(user)) continue;
                this.addChange(AbstractIO.DataType.USER, Change.Type.DELETE, user.getName());
            }
        }
        for (User user : usersIn) {
            String name = user.getName();
            User u = (User)currentUsers.get((Object)name);
            if (u != null) {
                if (JSONUtils.equals(user, u)) continue;
                this.addChange(AbstractIO.DataType.USER, Change.Type.UPDATE, name);
                continue;
            }
            this.addChange(AbstractIO.DataType.USER, Change.Type.CREATE, name);
        }
    }

    private void addChange(AbstractIO.DataType dataType, Change.Type type, String name) {
        this.addChange(dataType, type, Name.parse(name), null);
    }

    private void addChange(AbstractIO.DataType dataType, Change.Type type, Name name) {
        this.addChange(dataType, type, name, null);
    }

    private void addChange(AbstractIO.DataType dataType, Change.Type type, NamedMessage value) {
        this.addChange(dataType, type, value.getName(), value);
    }

    private void addChange(AbstractIO.DataType dataType, Change.Type type, Name name, Message value) {
        this.changes.add(new Change(dataType, type, name, value));
    }

    public List<Change> getChanges() {
        return this.changes;
    }

    public boolean wasChanged() {
        return !this.changed.isEmpty();
    }

    public List<Change> getChanged() {
        return this.changed;
    }

    private boolean readJSON(InputStream in, Name root, Set<AbstractIO.DataType> types) throws IOException {
        return this.parseJSON(new JSONObject(this.readFile(in)), root, types);
    }

    private boolean readYAML(InputStream in, Name root, Set<AbstractIO.DataType> types) throws IOException {
        return this.parseJSON(JSONUtils.fromYAML(in), root, types);
    }

    private String readFile(InputStream inputStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        while (in.ready()) {
            sb.append(in.readLine());
            sb.append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseJSON(JSONObject json, Name root, Set<AbstractIO.DataType> types) {
        this.root = root != null ? root : Name.ROOT;
        Name.setThreadRoot(root);
        try {
            Iterator<String> iterator = json.keySet().iterator();
            block21: while (iterator.hasNext()) {
                String name;
                switch (name = iterator.next()) {
                    case "acls": {
                        this.readACLs(json.getJSONObject(name), types);
                        continue block21;
                    }
                    case "calendars": {
                        if (!types.contains((Object)AbstractIO.DataType.CALENDAR)) continue block21;
                        this.readCalendars(json.getJSONArray(name));
                        continue block21;
                    }
                    case "configs": {
                        if (types.contains((Object)AbstractIO.DataType.CONFIG)) {
                            this.readConfigs(json.getJSONArray(name));
                        }
                    }
                    case "jobs": {
                        if (!types.contains((Object)AbstractIO.DataType.JOB)) continue block21;
                        this.readJobs(json.getJSONArray(name));
                        continue block21;
                    }
                    case "properties": {
                        if (!types.contains((Object)AbstractIO.DataType.PROPERTY)) continue block21;
                        this.readProperties(json.getJSONArray(name));
                        continue block21;
                    }
                    case "roles": {
                        if (!types.contains((Object)AbstractIO.DataType.ROLE) || !this.validate(BlissUtils.ACL_DIR_ROLES, ACL.Permission.ADMIN, AbstractIO.DataType.ROLE)) continue block21;
                        this.readRoles(json.getJSONArray(name));
                        continue block21;
                    }
                    case "users": {
                        if (!types.contains((Object)AbstractIO.DataType.USER) || !this.validate(BlissUtils.ACL_DIR_USERS, ACL.Permission.ADMIN, AbstractIO.DataType.USER)) continue block21;
                        this.readUsers(json.getJSONArray(name));
                        continue block21;
                    }
                }
                throw new JSONException(Localise.format("Unsupported entry - %s", name));
            }
        }
        finally {
            Name.clearThreadRoot();
        }
        return this.errors.isEmpty();
    }

    private void readACLs(JSONObject json, Set<AbstractIO.DataType> types) {
        if (types.contains((Object)AbstractIO.DataType.ACL) && json.has("names")) {
            for (Object obj : json.getJSONArray("names")) {
                try {
                    ACL acl = new ACL().fromJSON((JSONObject)obj);
                    if (!this.validate(acl.getName(), ACL.Permission.ADMIN, AbstractIO.DataType.ACL)) continue;
                    this.addACL(acl);
                }
                catch (JSONException e) {
                    this.addError(new Error(AbstractIO.DataType.ACL, (JSONObject)obj, e));
                }
            }
        }
        if (types.contains((Object)AbstractIO.DataType.HOST) && json.has("hosts") && this.validate(BlissUtils.ACL_DIR_HOST_ACLS, ACL.Permission.ADMIN, AbstractIO.DataType.HOST)) {
            for (Object obj : json.getJSONArray("hosts")) {
                try {
                    this.addHostACL(new HostACL().fromJSON((JSONObject)obj));
                }
                catch (JSONException e) {
                    this.addError(new Error(AbstractIO.DataType.ACL, (JSONObject)obj, e));
                }
            }
        }
        if (types.contains((Object)AbstractIO.DataType.PROTECTED) && json.has("protected") && this.validate(BlissUtils.ACL_DIR_PROTECTED, ACL.Permission.ADMIN, AbstractIO.DataType.PROTECTED)) {
            JSONObject object = json.getJSONObject("protected");
            if (object.has("hosts")) {
                for (Object obj : object.getJSONArray("hosts")) {
                    try {
                        this.addProtected(Protected.Type.HOST, (String)obj);
                    }
                    catch (JSONException e) {
                        this.addError(new Error(AbstractIO.DataType.ACL, (JSONObject)obj, e));
                    }
                }
            }
            if (object.has("users")) {
                for (Object obj : object.getJSONArray("users")) {
                    try {
                        this.addProtected(Protected.Type.USER, (String)obj);
                    }
                    catch (JSONException e) {
                        this.addError(new Error(AbstractIO.DataType.ACL, (JSONObject)obj, e));
                    }
                }
            }
        }
    }

    private void readCalendars(JSONArray json) {
        for (Object obj : json) {
            try {
                Calendar calendar = new Calendar().fromJSON((JSONObject)obj);
                if (!this.validate(calendar.getName(), ACL.Permission.WRITE, AbstractIO.DataType.CALENDAR)) continue;
                this.addCalendar(calendar);
            }
            catch (JSONException e) {
                this.addError(new Error(AbstractIO.DataType.CALENDAR, (JSONObject)obj, e));
            }
        }
    }

    private void readConfigs(JSONArray json) {
        if (this.validate(BlissUtils.ACL_DIR_CONFIGURATION, ACL.Permission.ADMIN, AbstractIO.DataType.CONFIG)) {
            for (Object obj : json) {
                try {
                    ConfigProperty property = new ConfigProperty().fromJSON((JSONObject)obj);
                    String name = property.getName();
                    String value = property.getValue();
                    Config config = Configs.getConfig(name);
                    if (config != null) {
                        try {
                            this.addConfig(config.set(value));
                        }
                        catch (IllegalArgumentException e) {
                            this.addError(new Error(AbstractIO.DataType.CONFIG, Error.Type.SYNTAX, config.getPath(), e.getMessage()));
                        }
                        continue;
                    }
                    this.addConfig(new StringConfig(name, value));
                }
                catch (JSONException e) {
                    this.addError(new Error(AbstractIO.DataType.CONFIG, (JSONObject)obj, e));
                }
            }
        }
    }

    private void readJobs(JSONArray json) {
        for (Object obj : json) {
            try {
                Job job = Job.parseFromJSON((JSONObject)obj);
                if (job.getMode() == Job.Mode.ENABLED && !job.canEnable()) {
                    this.addError(new Error(AbstractIO.DataType.JOB, Error.Type.ENABLE, job.getName(), job.canEnableReason()));
                    continue;
                }
                if (job.hasSchedule()) {
                    for (Condition condition : job.getConditions()) {
                        if (condition.getType() != Condition.Type.ANY) continue;
                        this.addError(new Error(AbstractIO.DataType.JOB, Error.Type.SYNTAX, job.getName(), "Job has both schedule/s and trigger/s."));
                    }
                }
                if (!this.validate(job.getName(), ACL.Permission.WRITE, AbstractIO.DataType.JOB)) continue;
                this.addJob(job);
            }
            catch (JSONException e) {
                this.addError(new Error(AbstractIO.DataType.JOB, (JSONObject)obj, e));
            }
        }
    }

    private void readProperties(JSONArray json) {
        for (Object obj : json) {
            try {
                Property property = new Property().fromJSON((JSONObject)obj, true);
                if (property.getType() == Property.Type.DEFAULT) {
                    property.setType(Property.Type.VARIABLE);
                }
                if (!this.validate(property.getGroup(), ACL.Permission.WRITE, AbstractIO.DataType.PROPERTY)) continue;
                this.addProperty(property);
            }
            catch (JSONException e) {
                this.addError(new Error(AbstractIO.DataType.PROPERTY, (JSONObject)obj, e));
            }
        }
    }

    private void readRoles(JSONArray json) {
        if (this.validate(BlissUtils.ACL_DIR_USERS, ACL.Permission.ADMIN, AbstractIO.DataType.ROLE)) {
            for (Object obj : json) {
                try {
                    this.addRole(new Role().fromJSON((JSONObject)obj));
                }
                catch (JSONException e) {
                    this.addError(new Error(AbstractIO.DataType.ROLE, (JSONObject)obj, e));
                }
            }
        }
    }

    private void readUsers(JSONArray json) {
        if (this.validate(BlissUtils.ACL_DIR_USERS, ACL.Permission.ADMIN, AbstractIO.DataType.USER)) {
            for (Object obj : json) {
                try {
                    this.addUser(new User().fromJSON((JSONObject)obj));
                }
                catch (JSONException e) {
                    this.addError(new Error(AbstractIO.DataType.USER, (JSONObject)obj, e));
                }
            }
        }
    }

    public boolean load(String reference) {
        Result result;
        if (!this.errors.isEmpty()) {
            return false;
        }
        if (this.mode != Mode.INSERT) {
            HashSet<Name> jobNames = new HashSet<Name>();
            for (Change change : this.changes) {
                if (change.getType() == Change.Type.CREATE || !change.getDataType().equals((Object)AbstractIO.DataType.JOB)) continue;
                jobNames.add(change.getName());
            }
            if (!jobNames.isEmpty() && !this.disableJobs(jobNames)) {
                return false;
            }
        }
        for (Change change : this.changes) {
            if (this.mode != Mode.REPLACE && change.getType() == Change.Type.DELETE) continue;
            Change.Type type = change.getType();
            switch (change.getDataType()) {
                case ACL: {
                    result = type != Change.Type.DELETE ? this.loadACL((NamedMessage)change.getValue(), type) : this.deleteACL((NamedMessage)change.getValue());
                    break;
                }
                case CALENDAR: {
                    result = type != Change.Type.DELETE ? this.loadCalendar((Calendar)change.getValue(), type) : this.deleteCalendar(change.getName());
                    break;
                }
                case CONFIG: {
                    result = this.loadConfig((Config)change.getValue(), type);
                    break;
                }
                case JOB: {
                    result = type != Change.Type.DELETE ? this.loadJob((Job)change.getValue(), type) : this.deleteJob(change.getName());
                    break;
                }
                case ROLE: {
                    result = type != Change.Type.DELETE ? this.loadRole((Role)change.getValue(), type) : this.deleteRole(((Role)change.getValue()).getName());
                    break;
                }
                case PROPERTY: {
                    result = type != Change.Type.DELETE ? this.loadProperty((Property)change.getValue()) : this.deleteProperty((Property)change.getValue());
                    break;
                }
                case USER: {
                    result = type != Change.Type.DELETE ? this.loadUser((User)change.getValue(), type) : this.deleteUser(((User)change.getValue()).getName());
                    break;
                }
                default: {
                    result = new Result(false, "Unexpected change label - " + change.getDataType().getLabel(), new Link[0]);
                }
            }
            boolean success = result.wasSuccess();
            if (success) {
                this.changed.add(change);
                continue;
            }
            this.addError(new Error(change.getDataType(), Error.Type.LOAD, change.getName(), result.getMessage()));
            break;
        }
        if (!this.changed.isEmpty() && !(result = this.sendReceive(new PersistCommand(this.changeGroup, reference)).getResult()).wasSuccess()) {
            this.addError(new Error(AbstractIO.DataType.ALL, Error.Type.LOAD, Name.ROOT, result.getMessage()));
        }
        return this.errors.isEmpty();
    }

    private boolean disableJobs(Set<Name> names) {
        IMap<Name, Job> jobMap = Hazelcast.getJobMap(this.getHazelcast());
        HashSet<Job> disabled = new HashSet<Job>();
        for (Name name : names) {
            Job job = (Job)jobMap.get((Object)name);
            if (job == null || job.getMode() != Job.Mode.ENABLED) continue;
            Result result = this.sendReceive(new JobControl(name, Job.Mode.DISABLED)).getResult();
            if (result.wasSuccess()) {
                disabled.add(job);
                continue;
            }
            this.addError(new Error(AbstractIO.DataType.JOB, Error.Type.DISABLE, name, result.getMessage()));
            this.reenableJobs(disabled);
            break;
        }
        return this.errors.isEmpty();
    }

    private void reenableJobs(Set<Job> jobs) {
        for (Job job : jobs) {
            Result result = this.sendReceive(new JobControl(job.getName(), job.getMode())).getResult();
            if (result.wasSuccess()) continue;
            this.addError(new Error(AbstractIO.DataType.JOB, Error.Type.ENABLE, job.getName(), result.getMessage()));
        }
    }

    private Result loadACL(NamedMessage value, Change.Type type) {
        if (value instanceof ACL) {
            return this.loadNameACL((ACL)value, type);
        }
        if (value instanceof HostACL) {
            return this.loadHostACL((HostACL)value);
        }
        if (value instanceof Protected) {
            return this.loadProtected((Protected)value);
        }
        return new Result(false, "unsupported ACL type - " + value.getClass().getName(), new Link[0]);
    }

    private Result deleteACL(NamedMessage value) {
        if (value instanceof ACL) {
            return this.deleteNameACL((ACL)value);
        }
        if (value instanceof HostACL) {
            return this.deleteHostACL((HostACL)value);
        }
        if (value instanceof Protected) {
            return this.deleteProtected((Protected)value);
        }
        return new Result(false, "unsupported ACL type - " + value.getClass().getName(), new Link[0]);
    }

    private Result loadNameACL(ACL acl, Change.Type type) {
        return this.sendReceive(new ACLCommand(acl, type == Change.Type.UPDATE ? ACLCommand.Action.UPDATE : ACLCommand.Action.CREATE)).getResult();
    }

    private Result deleteNameACL(ACL acl) {
        return this.sendReceive(new ACLCommand(acl, ACLCommand.Action.DELETE)).getResult();
    }

    private Result loadHostACL(HostACL acl) {
        return this.sendReceive(new HostACLCommand(acl, HostACLCommand.Action.SET)).getResult();
    }

    private Result deleteHostACL(HostACL acl) {
        return this.sendReceive(new HostACLCommand(acl, HostACLCommand.Action.DELETE)).getResult();
    }

    private Result loadProperty(Property property) {
        return this.sendReceive(new PropertyCommand(property.getGroup(), property, PropertyCommand.Action.SET)).getResult();
    }

    private Result deleteProperty(Property property) {
        return this.sendReceive(new PropertyCommand(property.getGroup(), property, PropertyCommand.Action.DELETE)).getResult();
    }

    private Result loadProtected(Protected value) {
        return this.sendReceive(new ProtectedCommand(value.getType(), value.getValue(), ProtectedCommand.Action.ADD)).getResult();
    }

    private Result deleteProtected(Protected value) {
        return this.sendReceive(new ProtectedCommand(value.getType(), value.getValue(), ProtectedCommand.Action.DELETE)).getResult();
    }

    private Result loadCalendar(Calendar calendar, Change.Type type) {
        return this.sendReceive(new CalendarCommand(calendar, type == Change.Type.UPDATE ? CalendarCommand.Action.UPDATE : CalendarCommand.Action.CREATE)).getResult();
    }

    private Result loadConfig(Config config, Change.Type type) {
        return this.sendReceive(new ConfigCommand(config.getName(), config.getValue().toString())).getResult();
    }

    private Result deleteCalendar(Name name) {
        return this.sendReceive(new CalendarCommand(name, CalendarCommand.Action.DELETE)).getResult();
    }

    private Result loadJob(Job job, Change.Type type) {
        return this.sendReceive(new JobCommand(job, type == Change.Type.UPDATE ? JobCommand.Action.UPDATE : JobCommand.Action.CREATE)).getResult();
    }

    private Result deleteJob(Name name) {
        return this.sendReceive(new JobCommand(name, JobCommand.Action.DELETE)).getResult();
    }

    private Result loadRole(Role role, Change.Type type) {
        return this.sendReceive(new RoleCommand(role, type == Change.Type.UPDATE ? RoleCommand.Action.UPDATE : RoleCommand.Action.CREATE)).getResult();
    }

    private Result deleteRole(String name) {
        return this.sendReceive(new RoleCommand(name, RoleCommand.Action.DELETE)).getResult();
    }

    private Result loadUser(User user, Change.Type type) {
        return this.sendReceive(new UserCommand(user, type == Change.Type.UPDATE ? UserCommand.Action.UPDATE : UserCommand.Action.CREATE)).getResult();
    }

    private Result deleteUser(String name) {
        return this.sendReceive(new UserCommand(name, UserCommand.Action.DELETE)).getResult();
    }

    @Override
    protected ResultMessage sendReceive(CommandMessage command) {
        return super.sendReceive(command.setChangeGroup(this.changeGroup));
    }

    private boolean validate(Name name, ACL.Permission permission, AbstractIO.DataType type) {
        if (!this.root.contains(name) && (!this.root.equals(name) || type != AbstractIO.DataType.ACL && type != AbstractIO.DataType.PROPERTY)) {
            this.addError(new Error(type, Error.Type.SCOPE, name));
            return false;
        }
        return this.checkAccess(name, permission, type);
    }

    private boolean checkAccess(Name name, ACL.Permission permission, AbstractIO.DataType type) {
        boolean canAccess = this.checkAccess(name, permission);
        if (!canAccess) {
            this.addError(new Error(type, Error.Type.PERMISSION, name));
        }
        return canAccess;
    }

    public static class Error
    implements Comparable<Error> {
        private AbstractIO.DataType dataType;
        private Type type;
        private Name name = null;
        private String message = null;
        private JSONObject json = null;
        private long ctime = System.currentTimeMillis();

        private Error(AbstractIO.DataType dataType, Type type, Name name) {
            this(dataType, type, name, null);
        }

        private Error(AbstractIO.DataType dataType, Type type, Name name, String message) {
            this.dataType = dataType;
            this.type = type;
            this.name = name;
            this.message = message;
        }

        private Error(AbstractIO.DataType dataType, JSONObject json, JSONException exception) {
            this.dataType = dataType;
            this.type = Type.JSON;
            this.json = json;
            this.message = exception.getMessage();
        }

        public AbstractIO.DataType getDataType() {
            return this.dataType;
        }

        public Type getType() {
            return this.type;
        }

        public Name getName() {
            return this.name;
        }

        public String getMessage() {
            return this.message;
        }

        public JSONObject getJSON() {
            return this.json;
        }

        public String toString() {
            return this.type == Type.JSON ? String.format("%s: %s: %s", new Object[]{this.dataType.getLabel(), this.type, this.message}) : String.format("%s: %s: %s", new Object[]{this.dataType.getLabel(), this.type, this.name});
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Error)) {
                return false;
            }
            return this.compareTo((Error)obj) == 0;
        }

        @Override
        public int compareTo(Error that) {
            int i = this.type.compareTo(that.type);
            if (i != 0) {
                return i;
            }
            if (this.name != null && (i = this.name.compareTo(that.name)) != 0) {
                return i;
            }
            i = this.dataType.compareTo(that.dataType);
            if (i != 0) {
                return i;
            }
            return (int)(this.ctime - that.ctime);
        }

        public static enum Type {
            JSON,
            PERMISSION,
            SCOPE,
            DISABLE,
            ENABLE,
            LOAD,
            SYNTAX,
            DEPENDENCY;

        }
    }

    public static class Change
    implements Comparable<Change> {
        private AbstractIO.DataType dataType;
        private Type type;
        private Name name;
        private Message value;

        private Change(AbstractIO.DataType dataType, Type type, Name name, Message value) {
            this.dataType = dataType;
            this.type = type;
            this.name = name;
            this.value = value;
        }

        public AbstractIO.DataType getDataType() {
            return this.dataType;
        }

        public Type getType() {
            return this.type;
        }

        public Name getName() {
            return this.name;
        }

        public Message getValue() {
            return this.value;
        }

        public static Set<Type> getTypes(Collection<Change> changes) {
            HashSet<Type> types = new HashSet<Type>();
            int found = 0;
            for (Change change : changes) {
                if (types.add(change.getType()) && ++found == 3) break;
            }
            return types;
        }

        public String toString() {
            return String.format("%s: %s: %s", new Object[]{this.dataType.getLabel(), this.type, this.name});
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Change)) {
                return false;
            }
            return this.compareTo((Change)obj) == 0;
        }

        @Override
        public int compareTo(Change that) {
            int i = this.type.compareTo(that.type);
            if (i != 0) {
                return i;
            }
            i = this.name.compareTo(that.name);
            if (i != 0) {
                return i;
            }
            return this.dataType.compareTo(that.dataType);
        }

        public static enum Type {
            CREATE,
            UPDATE,
            DELETE;

        }
    }

    public static enum Mode {
        INSERT,
        UPDATE,
        REPLACE;

    }
}

