/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.ArrayUtils;
import com.beyondcron.core.Diff;
import com.beyondcron.core.Name;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.Property;
import com.beyondcron.core.PropertyDefaults;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.job.AgentJob;
import com.beyondcron.core.job.Command;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.VariableFormatter;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class CommandJob
extends AgentJob {
    private static final int MESSAGE_TYPE = "au.com.tonbo.bliss.core.job.CommandJob".hashCode();
    private static final List<Property.Type> propertyTypes = ArrayUtils.asList(Property.Type.ENVIRONMENT, Property.Type.VARIABLE);
    public static final String JSON_USER = "user";
    public static final String JSON_USER_NAME = "username";
    public static final String JSON_HOST = "host";
    public static final String JSON_HOST_NAME = "hostname";
    public static final String JSON_COMMAND = "command";
    public static final String JSON_INPUT = "input";
    private String userName = "";
    private String hostName = "";
    private Map<Job.Action, Command> commands = new HashMap<Job.Action, Command>();

    public CommandJob() {
    }

    public CommandJob(Job job) {
        super(job);
        if (job instanceof CommandJob) {
            CommandJob j = (CommandJob)job;
            this.userName = j.userName;
            this.hostName = j.hostName;
            for (Command command : j.commands.values()) {
                this.commands.put(command.getAction(), command.duplicate());
            }
        }
    }

    public CommandJob(Name name) {
        super(name);
    }

    @Override
    public void setDefaults(PropertyDefaults defaults) {
        if (defaults != null) {
            String command;
            super.setDefaults(defaults);
            if (this.userName.isBlank()) {
                this.userName = defaults.getTemplateValue(JSON_USER, "");
            }
            if (this.hostName.isBlank()) {
                this.hostName = defaults.getTemplateValue(JSON_HOST, "");
            }
            if (this.commands.isEmpty() && !StringUtils.isNullOrEmpty(command = defaults.getTemplateValue(JSON_COMMAND, false))) {
                this.setCommand(new Command(command));
            }
        }
    }

    @Override
    public String canEnableReason() {
        return this.canEnableReason(true);
    }

    protected String canEnableReason(boolean requiresUser) {
        if (requiresUser && this.getUserName().length() < 1) {
            return "Job has no user";
        }
        if (this.getHostName().length() < 1) {
            return "Job has no host";
        }
        Command command = this.getCommand(Job.Action.START);
        if (command == null || command.getCommand().trim().isEmpty()) {
            return "Job has no command";
        }
        return super.canEnableReason();
    }

    @Override
    public Job.Type getType() {
        return Job.Type.COMMAND;
    }

    @Override
    public Property.Type getDefaultPropertyType() {
        return Property.Type.ENVIRONMENT;
    }

    @Override
    public List<Property.Type> getPropertyTypes() {
        return propertyTypes;
    }

    @Override
    public boolean isEchoJob() {
        return NetUtils.isEchoHost(this.hostName);
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    public CommandJob setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public CommandJob setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public Collection<Command> getCommands() {
        return this.commands.values();
    }

    public Command getCommand() {
        return this.getCommand(Job.Action.START);
    }

    public Command getCommand(Job.Action action) {
        return this.commands.get((Object)action);
    }

    public CommandJob setCommand(Command command) {
        Job.Action action = command.getAction();
        this.commands.put(action, command);
        this.addAction(action);
        if (action == Job.Action.START) {
            this.addAction(Job.Action.KILL);
        }
        return this;
    }

    public boolean removeCommand(Job.Action action) {
        if (this.commands.remove((Object)action) == null) {
            return false;
        }
        this.removeAction(action);
        if (action == Job.Action.START) {
            this.removeAction(Job.Action.KILL);
        }
        return true;
    }

    public boolean hasCommand(Job.Action action) {
        return this.commands.containsKey((Object)action);
    }

    @Override
    protected Job expand(VariableFormatter formatter) {
        super.expand(formatter);
        if (!this.hasProperty("TZ")) {
            this.setProperty(new Property("TZ", this.getTimeZone().getID()));
        }
        for (Command command : this.commands.values()) {
            command.setCommand(formatter.expand(command.getCommand()));
            if (!command.hasInput()) continue;
            ArrayList<String> lines = new ArrayList<String>(command.getInput());
            command.clearInput();
            for (String line : lines) {
                command.addInput(formatter.expand(line));
            }
        }
        return this;
    }

    @Override
    public JSONObject diff(Job that, boolean showSecrets) {
        JSONObject diffs = super.diff(that, showSecrets);
        if (that instanceof CommandJob) {
            Command thatCommand;
            Command thisCommand;
            CommandJob cThat = (CommandJob)that;
            JSONArray diff = Diff.diff(this.userName, cThat.userName);
            if (diff.length() > 0) {
                diffs.put(JSON_USER, diff);
            }
            if ((diff = Diff.diff(this.hostName, cThat.hostName)).length() > 0) {
                diffs.put(JSON_HOST, diff);
            }
            if ((diff = Command.diffCommand(thisCommand = this.getCommand(), thatCommand = cThat.getCommand())).length() > 0) {
                diffs.put(JSON_COMMAND, diff);
            }
            if ((diff = Command.diffInput(thisCommand, thatCommand)).length() > 0) {
                diffs.put(JSON_COMMAND, diff);
            }
        }
        return diffs;
    }

    @Override
    public JSONObject toJSON(boolean showSecrets) {
        Command command;
        JSONObject json = super.toJSON(showSecrets);
        if (!StringUtils.isNullOrEmpty(this.userName)) {
            json.put(JSON_USER, this.userName);
        }
        if (!StringUtils.isNullOrEmpty(this.hostName)) {
            json.put(JSON_HOST, this.hostName);
        }
        if ((command = this.getCommand()) != null) {
            json.put(JSON_COMMAND, command.getCommand());
            if (command.hasInput()) {
                JSONArray array = new JSONArray();
                for (String line : command.getInput()) {
                    array.put(line);
                }
                json.put(JSON_INPUT, array);
            }
        }
        return json;
    }

    @Override
    public CommandJob fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.userName = json.has(JSON_USER_NAME) ? json.getString(JSON_USER_NAME) : json.optString(JSON_USER);
        this.hostName = json.has(JSON_HOST_NAME) ? json.getString(JSON_HOST_NAME) : json.optString(JSON_HOST);
        this.commands.clear();
        if (json.has(JSON_COMMAND)) {
            Command command = new Command(json.getString(JSON_COMMAND));
            if (json.has(JSON_INPUT)) {
                JSONArray array = json.getJSONArray(JSON_INPUT);
                ArrayList<String> lines = new ArrayList<String>();
                for (int i = 0; i < array.length(); ++i) {
                    lines.add(array.getString(i));
                }
                command.setInput(lines);
            }
            this.setCommand(command);
        }
        return this;
    }

    @Override
    public int getMessageType() {
        return MESSAGE_TYPE;
    }

    @Override
    public ProtoJob.Job.Builder toProto(boolean summary) {
        ProtoJob.Job.Builder baseBuilder = super.toProto(summary);
        ProtoJob.CommandJob.Builder builder = ProtoJob.CommandJob.newBuilder();
        if (!summary) {
            if (this.userName.length() > 0) {
                builder.setUserName(this.userName);
            }
            if (this.hostName.length() > 0) {
                builder.setHostName(this.hostName);
            }
            for (Command command : this.commands.values()) {
                builder.addCommand(command.toProto());
            }
        }
        baseBuilder.setCommandExt(builder);
        return baseBuilder;
    }

    @Override
    public CommandJob fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.CommandJob proto = ProtoJob.Job.parseFrom(data).getCommandExt();
        super.fromProto(data);
        this.setUserName(proto.hasUserName() ? proto.getUserName() : "");
        this.setHostName(proto.hasHostName() ? proto.getHostName() : "");
        this.commands.clear();
        for (ProtoJob.ShellCommand command : proto.getCommandList()) {
            this.setCommand(new Command().fromProto(command.toByteArray()));
        }
        return this;
    }
}

