/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Identical;
import com.beyondcron.core.JSON;
import com.beyondcron.core.Localise;
import com.beyondcron.core.Name;
import com.beyondcron.core.NameUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.job.Status;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.URISyntaxException;
import org.json.JSONException;
import org.json.JSONObject;

public class Condition
implements Comparable<Condition>,
Message<Condition>,
JSON<Condition>,
Identical<Condition> {
    public static final String JSON_TYPE = "type";
    public static final String JSON_TYPE_ANY = "TRIGGER";
    public static final String JSON_TYPE_ALL = "CONDITION";
    public static final String JSON_JOB = "job";
    public static final String JSON_STATE = "state";
    public static final String JSON_RESULT = "result";
    public static final String JSON_MAX_AGE = "maxAge";
    private static final String MESSAGE_TAG = "condition";
    private Type type = Type.ALL;
    private Name job;
    private Status.State state;
    private Status.Result result;
    private Period maxAge = null;

    public Condition() {
    }

    public Condition(Type type, Name job, Status.State state, Status.Result result, Period maxAge) {
        this.type = type;
        this.job = job;
        this.state = state;
        this.result = result;
        this.maxAge = type == Type.ALL ? maxAge : null;
    }

    public Type getType() {
        return this.type;
    }

    public Condition setType(Type type) {
        this.type = type;
        return this;
    }

    public Name getJob() {
        return this.job;
    }

    public Condition setJob(Name job) {
        this.job = job;
        return this;
    }

    public Status.State getState() {
        return this.state;
    }

    public Condition setState(Status.State state) {
        this.state = state;
        return this;
    }

    public Status.Result getResult() {
        return this.result;
    }

    public Condition setResult(Status.Result result) {
        this.result = result;
        return this;
    }

    public Period getMaxAge() {
        return this.maxAge;
    }

    public Condition setMaxAge(Period maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public boolean matches(Status status, boolean checkAge) {
        if (status == null) {
            return false;
        }
        if (this.state != null && status.getState() != this.state) {
            return false;
        }
        if (this.result != null) {
            Status.Result r = status.getResult();
            if (this.result != Status.Result.FAILED ? r != this.result : r != Status.Result.ERROR && r != Status.Result.MISSED && r != Status.Result.KILLED && r != Status.Result.EXCEPTION) {
                return false;
            }
        }
        return !checkAge || this.maxAge == null || status.getTimestamp() >= System.currentTimeMillis() - this.maxAge.getMilliseconds();
    }

    public String toString() {
        return this.toString(false, false, false);
    }

    public String toString(boolean abbreviated, boolean displayName, boolean includeLabel) {
        StringBuilder sb = new StringBuilder();
        if (includeLabel) {
            sb.append(this.type.label).append(" ");
        }
        if (this.job != null) {
            if (displayName) {
                sb.append(NameUtils.getDisplayName(Name.parse(this.job.isRootGroup() ? Name.ROOT : this.job.getGroup(), this.job.getName())));
            } else {
                sb.append(this.job.getPath());
            }
        }
        boolean and = false;
        if (this.state != null) {
            if (!abbreviated) {
                sb.append(Localise.format(" state is "));
            } else {
                sb.append(" - ");
            }
            sb.append(Localise.format(this.state.toString().toLowerCase()));
            and = true;
        }
        if (this.result != null) {
            if (and) {
                sb.append(!abbreviated ? Localise.format(" and") : Localise.format(" & "));
            }
            if (!abbreviated) {
                sb.append(Localise.format(" result is "));
            } else if (!and) {
                sb.append(" - ");
            }
            sb.append(Localise.format(this.result.toString().toLowerCase()));
        }
        if (this.maxAge != null) {
            sb.append(abbreviated ? " < " : Localise.format(" less than "));
            sb.append(this.maxAge.toString());
            sb.append(Localise.format(" ago"));
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        return this.equals(obj, false);
    }

    public boolean equals(Object obj, boolean ignoreType) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        return this.compareTo((Condition)obj, ignoreType) == 0;
    }

    @Override
    public int compareTo(Condition that) {
        return this.compareTo(that, false);
    }

    public int compareTo(Condition that, boolean ignoreType) {
        int i;
        if (!ignoreType && (i = this.type.compareTo(that.type)) != 0) {
            return i;
        }
        if (this.job != that.job) {
            if (this.job == null) {
                return -1;
            }
            if (that.job == null) {
                return 1;
            }
            i = this.job.compareTo(that.job);
            if (i != 0) {
                return i;
            }
        }
        if (this.state != that.state) {
            if (this.state == null) {
                return -1;
            }
            if (that.state == null) {
                return 1;
            }
            return this.state.compareTo(that.state);
        }
        if (this.result != that.result) {
            if (this.result == null) {
                return -1;
            }
            if (that.result == null) {
                return 1;
            }
            return this.result.compareTo(that.result);
        }
        return 0;
    }

    @Override
    public boolean identical(Condition that) {
        if (this.compareTo(that) == 0) {
            return this.maxAge != null ? this.maxAge.compareTo(that.maxAge) == 0 : that.maxAge == null;
        }
        return false;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put(JSON_TYPE, this.type.getJsonType());
        json.put(JSON_JOB, this.job.toString());
        if (this.state != null) {
            json.put(JSON_STATE, this.state.toString());
        }
        if (this.result != null && (this.state != null || this.result != Status.Result.SUCCESS)) {
            json.put(JSON_RESULT, this.result.toString());
        }
        if (this.type == Type.ALL && this.maxAge != null) {
            json.put(JSON_MAX_AGE, this.maxAge.toString(true));
        }
        return json;
    }

    @Override
    public Condition fromJSON(JSONObject json) throws JSONException {
        try {
            switch (json.getString(JSON_TYPE).toUpperCase()) {
                case "ALL": 
                case "CONDITION": {
                    this.type = Type.ALL;
                    break;
                }
                case "ANY": 
                case "TRIGGER": {
                    this.type = Type.ANY;
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_TYPE, json.get(JSON_TYPE).toString()));
        }
        try {
            this.job = new Name(json.getString(JSON_JOB));
        }
        catch (URISyntaxException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s - %3$s", JSON_JOB, json.get(JSON_JOB).toString(), e.getMessage()));
        }
        if (json.has(JSON_STATE)) {
            try {
                this.state = Status.State.valueOf(json.getString(JSON_STATE).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_STATE, json.get(JSON_STATE).toString()));
            }
        } else {
            this.state = null;
        }
        if (json.has(JSON_RESULT)) {
            try {
                this.result = Status.Result.valueOf(json.getString(JSON_RESULT).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_RESULT, json.get(JSON_RESULT).toString()));
            }
        } else {
            this.result = null;
        }
        if (this.state == null && this.result == null) {
            this.result = Status.Result.SUCCESS;
        }
        if (this.type == Type.ALL && json.has(JSON_MAX_AGE)) {
            try {
                this.maxAge = new Period(json.getString(JSON_MAX_AGE));
            }
            catch (IllegalArgumentException e) {
                throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_MAX_AGE, json.get(JSON_MAX_AGE).toString()));
            }
        } else {
            this.maxAge = null;
        }
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoJob.Condition.Builder toProto() {
        ProtoJob.Condition.Builder builder = ProtoJob.Condition.newBuilder();
        if (this.type != Type.ANY) {
            builder.setType(this.type.toProto());
        }
        builder.setName(this.job.toProto());
        if (this.state != null) {
            builder.setState(this.state.toProto());
        }
        if (this.result != null) {
            builder.setResult(this.result.toProto());
        }
        if (this.type == Type.ALL && this.maxAge != null) {
            builder.setMaxAge(this.maxAge.toProto());
        }
        return builder;
    }

    @Override
    public Condition fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.Condition proto = ProtoJob.Condition.parseFrom(data);
        this.type = proto.hasType() ? Type.fromProto(proto.getType()) : Type.ANY;
        this.job = new Name(proto.getName());
        this.state = proto.hasState() ? Status.State.fromProto(proto.getState()) : null;
        this.result = proto.hasResult() ? Status.Result.fromProto(proto.getResult()) : null;
        this.maxAge = proto.hasMaxAge() && this.type == Type.ALL ? new Period().fromProto(proto.getMaxAge().toByteArray()) : null;
        return this;
    }

    public static enum Type {
        ALL("C", Localise.format("Condition"), Localise.format("Condition event")),
        ANY("T", Localise.format("Trigger"), Localise.format("Trigger event"));

        private String tag;
        private String label;
        private String description;
        private static final EnumMap<Type, ProtoJob.Condition.Type> typeMap;

        private Type(String tag, String label, String description) {
            this.tag = tag;
            this.label = label;
            this.description = description;
        }

        public String getTag() {
            return this.tag;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public String getJsonType() {
            return this == ALL ? Condition.JSON_TYPE_ALL : Condition.JSON_TYPE_ANY;
        }

        public static Type fromProto(ProtoJob.Condition.Type type) {
            return typeMap.getA(type);
        }

        public ProtoJob.Condition.Type toProto() {
            return typeMap.getB(this);
        }

        static {
            typeMap = new EnumMap<Type, ProtoJob.Condition.Type>(Type.class, ProtoJob.Condition.Type.class);
        }
    }
}

