/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.ArrayUtils;
import com.beyondcron.core.Configs;
import com.beyondcron.core.Diff;
import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.PropertyDefaults;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.job.Command;
import com.beyondcron.core.job.CommandJob;
import com.beyondcron.core.job.Job;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class ContainerJob
extends CommandJob {
    private static final int MESSAGE_TYPE = "au.com.tonbo.bliss.core.job.ContainerJob".hashCode();
    private static final List<Property.Type> propertyTypes = ArrayUtils.asList(Property.Type.ENVIRONMENT, Property.Type.RESOURCE, Property.Type.VARIABLE);
    public static final String JSON_IMAGE = "image";
    private String imageName = "";

    public ContainerJob() {
    }

    public ContainerJob(Job job) {
        super(job);
        if (job instanceof ContainerJob) {
            this.imageName = ((ContainerJob)job).imageName;
        }
    }

    public ContainerJob(Name name) {
        super(name);
    }

    @Override
    public void setDefaults(PropertyDefaults defaults) {
        if (defaults != null) {
            super.setDefaults(defaults);
            if (this.imageName.isBlank()) {
                this.imageName = defaults.getTemplateValue(JSON_IMAGE, "");
            }
        }
    }

    @Override
    public String getHostName() {
        return (String)Configs.get("beyondcron.command.localhost");
    }

    @Override
    public String canEnableReason() {
        if (StringUtils.isNullOrEmpty(this.imageName)) {
            return "Job has no image";
        }
        return super.canEnableReason(false);
    }

    @Override
    public Job.Type getType() {
        return Job.Type.CONTAINER;
    }

    @Override
    public List<Property.Type> getPropertyTypes() {
        return propertyTypes;
    }

    public String getImageName() {
        return this.imageName;
    }

    public ContainerJob setImageName(String imageName) {
        this.imageName = imageName != null ? imageName : "";
        return this;
    }

    @Override
    public JSONObject diff(Job that, boolean showSecrets) {
        JSONObject diffs = super.diff(that, showSecrets);
        if (that instanceof ContainerJob) {
            Command thatCommand;
            Command thisCommand;
            ContainerJob cThat = (ContainerJob)that;
            JSONArray diff = Diff.diff(this.getUserName(), cThat.getUserName());
            if (diff.length() > 0) {
                diffs.put("username", diff);
            }
            if ((diff = Diff.diff(this.imageName, cThat.imageName)).length() > 0) {
                diffs.put(JSON_IMAGE, diff);
            }
            if ((diff = Command.diffCommand(thisCommand = this.getCommand(), thatCommand = cThat.getCommand())).length() > 0) {
                diffs.put("command", diff);
            }
            if ((diff = Command.diffInput(thisCommand, thatCommand)).length() > 0) {
                diffs.put("command", diff);
            }
        }
        return diffs;
    }

    @Override
    public JSONObject toJSON(boolean showSecrets) {
        JSONObject json = super.toJSON(showSecrets);
        if (this.imageName.length() > 0) {
            json.put(JSON_IMAGE, this.imageName);
        }
        json.remove("hostname");
        json.remove("input");
        json.remove("output");
        return json;
    }

    @Override
    public ContainerJob fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.imageName = json.optString(JSON_IMAGE);
        return this;
    }

    @Override
    public int getMessageType() {
        return MESSAGE_TYPE;
    }

    @Override
    public ProtoJob.Job.Builder toProto(boolean summary) {
        ProtoJob.Job.Builder baseBuilder = super.toProto(summary);
        ProtoJob.ContainerJob.Builder builder = ProtoJob.ContainerJob.newBuilder();
        if (!summary && this.imageName.length() > 0) {
            builder.setImageName(this.imageName);
        }
        baseBuilder.setContainerExt(builder);
        return baseBuilder;
    }

    @Override
    public ContainerJob fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.ContainerJob proto = ProtoJob.Job.parseFrom(data).getContainerExt();
        super.fromProto(data);
        this.imageName = proto.hasImageName() ? proto.getImageName() : "";
        return this;
    }
}

