/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Diff;
import com.beyondcron.core.Duplicatable;
import com.beyondcron.core.EnumMap;
import com.beyondcron.core.JSON;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Period;
import com.beyondcron.core.Program;
import com.beyondcron.core.Property;
import com.beyondcron.core.PropertyDefaults;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.TimeUtils;
import com.beyondcron.core.job.CalendarUpdateJob;
import com.beyondcron.core.job.CommandJob;
import com.beyondcron.core.job.Condition;
import com.beyondcron.core.job.ContainerJob;
import com.beyondcron.core.job.CustomJob;
import com.beyondcron.core.job.MailJob;
import com.beyondcron.core.job.SQLJob;
import com.beyondcron.core.job.Status;
import com.beyondcron.core.job.Trigger;
import com.beyondcron.core.job.TriggerJob;
import com.beyondcron.core.job.URLJob;
import com.beyondcron.core.job.VariableFormatter;
import com.beyondcron.core.property.Schema;
import com.beyondcron.core.schedule.CalendarSchedule;
import com.beyondcron.core.schedule.Schedule;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.MessageSerializer;
import com.beyondcron.messaging.NamedMessage;
import com.beyondcron.messaging.proto.ProtoJob;
import com.beyondcron.messaging.proto.ProtoProperty;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IQueue;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.jobs.NoOpJob;

public abstract class Job
implements Comparable<Job>,
Diff<Job>,
Duplicatable<Job>,
NamedMessage<Job>,
JSON<Job> {
    static final Logger logger = LogUtils.getLogger(Job.class);
    public static final String MESSAGE_TAG = "job";
    public static final String JSON_NAME = "name";
    public static final String JSON_DESCRIPTION = "description";
    public static final String JSON_TYPE = "type";
    public static final String JSON_MODE = "mode";
    public static final String JSON_CALENDAR = "calendar";
    public static final String JSON_TIME_ZONE = "timezone";
    public static final String JSON_CONDITIONS = "conditions";
    public static final String JSON_EVENTS = "events";
    public static final String JSON_SCHEDULES = "schedules";
    public static final String JSON_PROPERTIES = "properties";
    public static final String JSON_OUTPUT = "output";
    public static final String JSON_LIMITS = "limits";
    public static final String JSON_LIMIT_START = "start";
    public static final String JSON_LIMIT_RUN = "run";
    protected static HazelcastInstance hazelcast = null;
    private static IQueue<Status> jobStatusQueue = null;
    private static Map<Type, List<Property.Type>> propertyTypes = new HashMap<Type, List<Property.Type>>();
    private static Period defaultLimitStart = (Period)Configs.get("beyondcron.job.default.limit.start");
    private static Period defaultLimitRun = new Period(0, Period.Unit.SECOND);
    private Name name;
    private String description = "";
    private Mode mode = Mode.DISABLED;
    private Name calendar = null;
    private TimeZone timeZone = TimeZone.getDefault();
    private JobKey key = null;
    private JobDetail details = null;
    private Set<Action> actions = new TreeSet<Action>();
    private Set<Condition> conditions = new TreeSet<Condition>();
    private Set<Schedule> schedules = new TreeSet<Schedule>();
    private Map<String, Property> properties = new LinkedHashMap<String, Property>();
    private URL output = null;
    private Period limitStart = defaultLimitStart;
    private Period limitRun = defaultLimitRun;

    protected Job() {
    }

    public Job(Job that) {
        this.name = that.name;
        this.description = that.description;
        this.mode = that.mode;
        this.calendar = that.calendar;
        this.timeZone = that.timeZone;
        for (Property property : that.getProperties()) {
            this.setProperty(property);
        }
        this.actions.addAll(that.actions);
        this.conditions.addAll(that.conditions);
        this.schedules.addAll(that.schedules);
        this.properties.putAll(that.properties);
        this.output = that.output;
        this.limitStart = that.limitStart;
        this.limitRun = that.limitRun;
    }

    public Job(Name name) {
        this.name = name;
    }

    public static void setHazelcast(HazelcastInstance hazelcast) {
        Job.hazelcast = hazelcast;
        jobStatusQueue = Hazelcast.getJobStatusQueue(hazelcast);
    }

    public void setDefaults(PropertyDefaults defaults) {
        if (defaults != null) {
            String s;
            if (this.description.isBlank()) {
                this.description = defaults.getTemplateValue(JSON_DESCRIPTION, "");
            }
            if (this.calendar == null) {
                s = defaults.getTemplateValue(JSON_CALENDAR);
                try {
                    this.calendar = s != null ? Name.parse(s) : null;
                }
                catch (Exception e) {
                    Localise.logInfo(logger, "Invalid %1$s - %2$s - %3$s", JSON_CALENDAR, s, e.getMessage());
                }
            }
            if (this.timeZone == null) {
                TimeZone tz = TimeUtils.getTimeZone(defaults.getTemplateValue(JSON_TIME_ZONE, defaults.getTimeZone().getID()));
                TimeZone timeZone = this.timeZone = tz != null ? tz : defaults.getTimeZone();
            }
            if (this.output == null) {
                s = defaults.getTemplateValue(JSON_OUTPUT, false);
                try {
                    this.output = s != null ? new URL("file:" + s) : null;
                }
                catch (Exception e) {
                    Localise.logInfo(logger, "Invalid %1$s - %2$s - %3$s", JSON_OUTPUT, s, e.getMessage());
                }
            }
        }
    }

    private static Job getJob(Type type) {
        switch (type) {
            case COMMAND: {
                return new CommandJob();
            }
            case CONTAINER: {
                return new ContainerJob();
            }
            case CUSTOM: {
                return new CustomJob();
            }
            case CALENDAR_UPDATE: {
                return new CalendarUpdateJob();
            }
            case URL: {
                return new URLJob();
            }
            case MAIL: {
                return new MailJob();
            }
            case SQL: {
                return new SQLJob();
            }
            case TRIGGER: {
                return new TriggerJob();
            }
        }
        return null;
    }

    @Override
    public Name getName() {
        return this.name;
    }

    private Job setName(Name name) {
        this.name = name;
        this.key = null;
        return this;
    }

    public boolean hasDescription() {
        return !StringUtils.isNullOrEmpty(this.description);
    }

    public String getDescription() {
        return this.description;
    }

    public Job setDescription(String description) {
        this.description = StringUtils.stripDuplicateSpaces(description);
        return this;
    }

    public boolean hasCalendar() {
        return this.calendar != null;
    }

    public Name getCalendar() {
        return this.calendar;
    }

    public Job setCalendar(Name calendar) {
        this.calendar = calendar;
        return this;
    }

    public boolean hasTimeZone() {
        return this.timeZone != null;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public Job setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isEnabled() {
        return this.mode == Mode.ENABLED;
    }

    public boolean isDisabled() {
        return this.mode == Mode.DISABLED;
    }

    public boolean isBypass() {
        return this.mode == Mode.BYPASS;
    }

    public Job setMode(Mode mode) {
        if (this.mode != mode) {
            if (mode == Mode.ENABLED && !this.canEnable()) {
                Localise.logWarn(logger, "Cannot enable %s as it not suitably configured to execute", this.getName());
                return this;
            }
            this.mode = mode;
        }
        return this;
    }

    public boolean canEnable() {
        return this.canEnableReason() == null;
    }

    public String canEnableReason() {
        if (!this.isAction(Action.START)) {
            return "Job has no start action";
        }
        for (Schedule schedule : this.getSchedules()) {
            if (!(schedule instanceof CalendarSchedule) || this.hasCalendar()) continue;
            return "Job has a calendar schedule but no calendar";
        }
        return null;
    }

    public abstract Type getType();

    public boolean canQueue() {
        if (this.hasSchedule() || !this.hasCondition()) {
            return false;
        }
        for (Condition condition : this.conditions) {
            if (condition.getType() != Condition.Type.ALL) continue;
            return false;
        }
        return true;
    }

    protected Job addAction(Action action) {
        this.actions.add(action);
        return this;
    }

    protected boolean removeAction(Action action) {
        return this.actions.remove((Object)action);
    }

    public boolean isAction(Action action) {
        return this.actions.contains((Object)action);
    }

    public Set<Action> getActions() {
        return this.actions;
    }

    public Job addCondition(Condition condition) {
        if (!this.conditions.add(condition)) {
            this.conditions.remove(condition);
            this.conditions.add(condition);
        }
        return this;
    }

    public Job addCondition(Condition condition, Condition.Type type) {
        Condition currentCondition = null;
        for (Condition c : this.conditions) {
            if (!condition.equals(c, true)) continue;
            currentCondition = c;
            break;
        }
        if (currentCondition != null) {
            if (currentCondition.getType() == type && condition.getType() != type) {
                return this;
            }
            this.conditions.remove(currentCondition);
        }
        this.conditions.add(condition);
        return this;
    }

    public Job addConditions(Collection<Condition> conditions) {
        this.conditions.addAll(conditions);
        return this;
    }

    public boolean removeCondition(Condition condition) {
        if (!this.conditions.remove(condition)) {
            return false;
        }
        if (this.mode == Mode.ENABLED && !this.canEnable()) {
            Localise.logWarn(logger, "Disabling %s as it not suitably configured to execute", this.getName());
            this.setMode(Mode.DISABLED);
        }
        return true;
    }

    public Job clearConditions() {
        this.conditions.clear();
        return this;
    }

    public boolean hasCondition() {
        return !this.conditions.isEmpty();
    }

    public Collection<Condition> getConditions() {
        return this.conditions;
    }

    public Collection<Condition> getConditions(Name name) {
        TreeSet<Condition> set = new TreeSet<Condition>();
        for (Condition condition : this.conditions) {
            if (!condition.getJob().equals(name)) continue;
            set.add(condition);
        }
        return set;
    }

    public boolean hasSchedule() {
        return !this.schedules.isEmpty();
    }

    public Collection<Schedule> getSchedules() {
        return this.schedules;
    }

    public boolean addSchedule(Schedule schedule) {
        schedule.setJob(this);
        return this.schedules.add(schedule);
    }

    public Job addSchedules(Collection<Schedule> schedules) {
        for (Schedule schedule : schedules) {
            schedule.setJob(this);
            this.schedules.add(schedule);
        }
        return this;
    }

    public boolean removeSchedule(Schedule schedule) {
        if (!this.schedules.remove(schedule)) {
            return false;
        }
        if (this.mode == Mode.ENABLED && !this.canEnable()) {
            Localise.logWarn(logger, "Disabling %s as it not suitably configured to execute", this.getName());
            this.setMode(Mode.DISABLED);
        }
        return true;
    }

    public Job clearSchedules() {
        if (!this.schedules.isEmpty()) {
            this.schedules.clear();
        }
        return this;
    }

    public Period getStartLimit() {
        return this.limitStart;
    }

    public Period getRunLimit() {
        return this.limitRun;
    }

    public Property getProperty(String name) {
        return this.properties.get(name);
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Collection<Property> getProperties() {
        return this.properties.values();
    }

    public List<Property> getProperties(Property.Type type) {
        ArrayList<Property> list = new ArrayList<Property>();
        if (type == this.getDefaultPropertyType()) {
            type = Property.Type.DEFAULT;
        }
        for (Property property : this.properties.values()) {
            if (property.getType() != type) continue;
            list.add(property);
        }
        return list;
    }

    public abstract boolean isEchoJob();

    public abstract Property.Type getDefaultPropertyType();

    public abstract List<Property.Type> getPropertyTypes();

    public static List<Property.Type> getPropertyTypes(Type type) {
        List<Property.Type> types = propertyTypes.get((Object)type);
        if (types == null) {
            Job job = Job.getJob(type);
            if (job != null) {
                types = job.getPropertyTypes();
            } else {
                types = new ArrayList<Property.Type>();
                Localise.logError(logger, "Unsupported job type: %s", type.getLabel());
            }
            propertyTypes.put(type, types);
        }
        return types;
    }

    public boolean hasProperty() {
        return !this.properties.isEmpty();
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public boolean isSupportedPropertyType(Property.Type type) {
        return this.getPropertyTypes().contains((Object)type) || type == Property.Type.SYSTEM || type == Property.Type.UNSET;
    }

    public Job setProperty(Property property) {
        Property.Type type = property.getType();
        Schema schema = property.getSchema();
        if (schema != Property.DEFAULT_SCHEMA && schema.inScope(Schema.Scope.JOB)) {
            this.properties.put(property.getName(), property);
        } else if (type == this.getDefaultPropertyType() || !this.isSupportedPropertyType(type)) {
            this.properties.put(property.getName(), new Property(property).setType(Property.Type.DEFAULT));
        } else {
            this.properties.put(property.getName(), property);
        }
        return this;
    }

    public Job setProperties(Collection<Property> properties) {
        for (Property property : properties) {
            this.setProperty(property);
        }
        return this;
    }

    public Property removeProperty(String name) {
        return this.properties.remove(name);
    }

    public Job clearProperties() {
        if (!this.properties.isEmpty()) {
            this.properties.clear();
        }
        return this;
    }

    public Job setDefaultProperties(Collection<Property> properties) {
        for (Property property : properties) {
            String name = property.getName();
            if (this.properties.containsKey(name) || !this.isSupportedPropertyType(property.getType())) continue;
            this.properties.put(name, property);
        }
        return this;
    }

    public URL getOutput() {
        return this.output;
    }

    public boolean hasOutput() {
        return this.output != null;
    }

    public Job setOutput(URL output) {
        if (output == null || output.getProtocol().equals("file")) {
            this.output = output;
        } else {
            Localise.logError(logger, "Unsupported output protocol - %s", output.getProtocol());
        }
        return this;
    }

    public URL getDefaultOutput() {
        String tag = this instanceof CommandJob ? ((CommandJob)this).getUserName() : "";
        return this.getDefaultOutput(tag);
    }

    public URL getDefaultOutput(String tag) {
        VariableFormatter formatter = new VariableFormatter(this);
        boolean tagFile = !StringUtils.isNullOrEmpty(tag);
        String format = tagFile ? (String)Configs.get("beyondcron.file.log.tagged", Program.getOs()) : (String)Configs.get("beyondcron.file.log", Program.getOs());
        String fileName = formatter.expand(format);
        if (tagFile) {
            fileName = String.format(fileName, tag);
        }
        try {
            return new File(fileName).toURI().toURL();
        }
        catch (MalformedURLException e) {
            Localise.logError(logger, "Could not create default output file from %1$s - %2$s", fileName, e.getMessage());
            return null;
        }
    }

    public JobDetail getDetails() {
        if (this.details == null) {
            this.details = JobBuilder.newJob().ofType(NoOpJob.class).withIdentity(this.getKey()).build();
        }
        return this.details;
    }

    public JobKey getKey() {
        if (this.key == null) {
            this.key = Job.getKey(this.name);
        }
        return this.key;
    }

    public static JobKey getKey(Name name) {
        return new JobKey(name.getName(), name.getGroupName());
    }

    public abstract void execute(Action var1, long var2, Trigger var4, Status var5);

    public Job setStatus(Status status) {
        jobStatusQueue.add((Object)status);
        return this;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        return this.compareTo((Job)obj) == 0;
    }

    @Override
    public int compareTo(Job that) {
        return this.name.compareTo(that.name);
    }

    public Job expand() {
        return this.expand(this.getFormatter());
    }

    public Job expand(long startTimestamp, Trigger trigger, Status triggerStatus) {
        return this.expand(this.getFormatter(startTimestamp, trigger, triggerStatus));
    }

    protected Job expand(VariableFormatter formatter) {
        boolean showSecrets = !this.isEchoJob();
        for (Property property : this.properties.values()) {
            property.setValue(formatter.expand(property.getValue(showSecrets)));
        }
        if (this.output != null) {
            try {
                this.output = new URL(formatter.expand(this.output.toString()));
            }
            catch (MalformedURLException e) {
                Localise.logError(logger, "Could not expand %1$s - %2$s", this.output.toString(), e.getMessage());
            }
        } else {
            this.output = this.getDefaultOutput();
        }
        return this;
    }

    protected VariableFormatter getFormatter() {
        return new VariableFormatter(this, null, null, System.currentTimeMillis());
    }

    public VariableFormatter getFormatter(long timestamp, Trigger trigger, Status triggerStatus) {
        return new VariableFormatter(this, trigger, triggerStatus, timestamp);
    }

    @Override
    public JSONObject diff(Job that) {
        return this.diff(that, false);
    }

    public JSONObject diff(Job that, boolean showSecrets) {
        JSONArray diff;
        JSONObject diffs = new JSONObject();
        if (!this.name.equals(that.name)) {
            diffs.put(JSON_NAME, JSON.array(this.name, that.name));
        }
        if (!this.description.equals(that.description)) {
            diffs.put(JSON_DESCRIPTION, JSON.array(this.description, that.description));
        }
        if (this.getType() != that.getType()) {
            diffs.put(JSON_TYPE, JSON.array(new Object[]{this.getTimeZone(), that.getType()}));
        }
        if (this.mode != that.mode) {
            diffs.put(JSON_MODE, JSON.array(this.mode.getLabel(), that.mode.getLabel()));
        }
        if ((diff = Diff.diff(this.calendar, that.calendar)).length() > 0) {
            diffs.put(JSON_CALENDAR, diff);
        }
        if (!this.timeZone.getID().equals(that.timeZone.getID())) {
            diffs.put(JSON_TIME_ZONE, JSON.array(this.timeZone.getID(), that.timeZone.getID()));
        }
        if (!this.conditions.equals(that.conditions)) {
            diff = new JSONArray();
            diff.put(JSON.array(this.conditions.toArray()));
            diff.put(JSON.array(that.conditions.toArray()));
            diffs.put(JSON_EVENTS, diff);
        }
        if (!this.schedules.equals(that.schedules)) {
            diff = new JSONArray();
            diff.put(JSON.array(this.schedules.toArray()));
            diff.put(JSON.array(that.schedules.toArray()));
            diffs.put(JSON_SCHEDULES, diff);
        }
        if (!this.properties.equals(that.properties)) {
            diff = new JSONArray();
            JSONArray a = new JSONArray();
            for (Property p : this.properties.values()) {
                if (p.isSecret() && !showSecrets) {
                    p.setValue("********");
                }
                a.put(p.toString(showSecrets));
            }
            diff.put(a);
            a = new JSONArray();
            for (Property p : that.properties.values()) {
                if (p.isSecret() && !showSecrets) {
                    p.setValue("********");
                }
                a.put(p.toString(showSecrets));
            }
            diff.put(a);
            if (diff.length() > 0) {
                diffs.put(JSON_PROPERTIES, diff);
            }
        }
        if ((diff = Diff.diff(this.output, that.output)).length() > 0) {
            diffs.put(JSON_OUTPUT, diff);
        }
        return diffs;
    }

    @Override
    public JSONObject toJSON() {
        return this.toJSON(false);
    }

    public JSONObject toJSON(boolean showSecrets) {
        JSONArray array;
        JSONObject json = new JSONObject();
        json.put(JSON_NAME, this.name.toString());
        if (!StringUtils.isNullOrEmpty(this.description)) {
            json.put(JSON_DESCRIPTION, this.description);
        }
        json.put(JSON_TYPE, this.getType().toString());
        json.put(JSON_MODE, this.mode.toString().toLowerCase());
        if (this.calendar != null) {
            json.put(JSON_CALENDAR, this.calendar.toString());
        }
        if (this.timeZone != null) {
            json.put(JSON_TIME_ZONE, this.timeZone.getID());
        }
        if (!this.conditions.isEmpty()) {
            array = new JSONArray();
            for (Condition condition : this.conditions) {
                array.put(condition.toJSON());
            }
            json.put(JSON_EVENTS, array);
        }
        if (!this.schedules.isEmpty()) {
            array = new JSONArray();
            for (Schedule schedule : this.schedules) {
                array.put(schedule.toJSON());
            }
            json.put(JSON_SCHEDULES, array);
        }
        if (!this.properties.isEmpty()) {
            array = new JSONArray();
            ArrayList<String> names = new ArrayList<String>(this.properties.keySet());
            Collections.sort(names);
            for (String name : names) {
                Property property = this.properties.get(name);
                property.setGroup(null);
                array.put(property.toJSON(showSecrets));
            }
            json.put(JSON_PROPERTIES, array);
        }
        if (this.output != null) {
            json.put(JSON_OUTPUT, this.output.getPath());
        }
        JSONObject limits = new JSONObject();
        if (!this.limitStart.equals(defaultLimitStart)) {
            limits.put(JSON_LIMIT_START, this.limitStart.toString(true));
        }
        if (!this.limitRun.equals(defaultLimitRun)) {
            limits.put(JSON_LIMIT_RUN, this.limitRun.toString(true));
        }
        if (limits.length() > 0) {
            json.put(JSON_LIMITS, limits);
        }
        return json;
    }

    @Override
    public Job fromJSON(JSONObject json) {
        int i;
        JSONArray array;
        try {
            this.name = new Name(json.getString(JSON_NAME));
        }
        catch (URISyntaxException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s - %3$s", JSON_NAME, json.get(JSON_NAME).toString(), e.getMessage()));
        }
        this.description = json.optString(JSON_DESCRIPTION);
        try {
            this.mode = Mode.valueOf(json.getString(JSON_MODE).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_MODE, json.get(JSON_MODE).toString()));
        }
        if (json.has(JSON_CALENDAR)) {
            try {
                this.calendar = new Name(json.getString(JSON_CALENDAR));
            }
            catch (URISyntaxException e) {
                throw new JSONException(Localise.format("invalid %1$s - %2$s - %3$s", JSON_CALENDAR, json.get(JSON_CALENDAR).toString(), e.getMessage()));
            }
        } else {
            this.calendar = null;
        }
        this.timeZone = json.has(JSON_TIME_ZONE) ? TimeZone.getTimeZone(json.getString(JSON_TIME_ZONE)) : TimeZone.getDefault();
        this.conditions.clear();
        if (json.has(JSON_EVENTS)) {
            array = json.getJSONArray(JSON_EVENTS);
            for (i = 0; i < array.length(); ++i) {
                this.conditions.add(new Condition().fromJSON(array.getJSONObject(i)));
            }
        }
        if (json.has(JSON_CONDITIONS)) {
            array = json.getJSONArray(JSON_CONDITIONS);
            for (i = 0; i < array.length(); ++i) {
                this.conditions.add(new Condition().fromJSON(array.getJSONObject(i)));
            }
        }
        this.schedules.clear();
        if (json.has(JSON_SCHEDULES)) {
            array = json.getJSONArray(JSON_SCHEDULES);
            for (i = 0; i < array.length(); ++i) {
                Schedule schedule = Schedule.parseFromJSON(array.getJSONObject(i), this.timeZone);
                schedule.setJob(this);
                this.schedules.add(schedule);
            }
        }
        this.properties.clear();
        if (json.has(JSON_PROPERTIES)) {
            array = json.getJSONArray(JSON_PROPERTIES);
            for (i = 0; i < array.length(); ++i) {
                Property property = new Property().fromJSON(array.getJSONObject(i));
                property.setGroup(null);
                Property.Type propertyType = property.getType();
                if (propertyType != Property.Type.DEFAULT && !this.isSupportedPropertyType(propertyType)) {
                    throw new JSONException(Localise.format("unsupported type for property %1$s - %2$s", property.getName(), property.getType().getLabel()));
                }
                this.properties.put(property.getName(), property);
            }
        }
        try {
            this.output = json.has(JSON_OUTPUT) ? new URL("file:" + json.getString(JSON_OUTPUT)) : null;
        }
        catch (MalformedURLException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s - %3$s", JSON_OUTPUT, json.get(JSON_OUTPUT).toString(), e.getMessage()));
        }
        if (json.has(JSON_LIMITS)) {
            JSONObject limits = json.getJSONObject(JSON_LIMITS);
            this.limitStart = limits.has(JSON_LIMIT_START) ? new Period(json.getString(JSON_LIMIT_START), Period.Unit.HOUR) : defaultLimitStart;
            this.limitRun = limits.has(JSON_LIMIT_RUN) ? new Period(json.getString(JSON_LIMIT_RUN)) : defaultLimitRun;
        }
        return this;
    }

    public static Job parseFromJSON(JSONObject json) {
        try {
            switch (Type.valueOf(json.getString(JSON_TYPE))) {
                case COMMAND: {
                    return new CommandJob().fromJSON(json);
                }
                case CONTAINER: {
                    return new ContainerJob().fromJSON(json);
                }
                case CUSTOM: {
                    return new CustomJob().fromJSON(json);
                }
                case URL: {
                    return new URLJob().fromJSON(json);
                }
                case MAIL: {
                    return new MailJob().fromJSON(json);
                }
                case CALENDAR_UPDATE: {
                    return new CalendarUpdateJob().fromJSON(json);
                }
                case SQL: {
                    return new SQLJob().fromJSON(json);
                }
                case TRIGGER: {
                    return new TriggerJob().fromJSON(json);
                }
            }
            throw new JSONException(Localise.format("unsupported job type %s", json.getString(JSON_TYPE)));
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_TYPE, json.getString(JSON_TYPE)));
        }
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoJob.Job.Builder toProto() {
        return this.toProto(false);
    }

    public ProtoJob.Job.Builder toProto(boolean summary) {
        ProtoJob.Job.Builder builder = ProtoJob.Job.newBuilder();
        builder.setType(this.getType().toProto());
        builder.setMode(this.mode.toProto());
        builder.setName(this.name.toProto());
        if (!StringUtils.isNullOrEmpty(this.description)) {
            builder.setDescription(this.description);
        }
        if (this.calendar != null) {
            builder.setCalendar(this.calendar.toString());
        }
        if (this.timeZone != null) {
            builder.setTimeZone(this.timeZone.getID());
        }
        for (Action action : this.actions) {
            builder.addActions(action.toProto());
        }
        if (!summary) {
            for (Condition condition : this.conditions) {
                builder.addCondition(condition.toProto());
            }
            for (Schedule schedule : this.schedules) {
                builder.addSchedule(schedule.toProto());
            }
            for (Property property : this.properties.values()) {
                builder.addProperty(property.toProto());
            }
            if (this.output != null) {
                builder.setOutput(this.output.toString());
            }
            if (!this.limitStart.equals(defaultLimitStart)) {
                builder.setLimitStart(this.limitStart.toProto());
            }
            if (!this.limitRun.equals(defaultLimitRun)) {
                builder.setLimitRun(this.limitRun.toProto());
            }
        }
        return builder;
    }

    @Override
    public Job fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.Job proto = ProtoJob.Job.parseFrom(data);
        this.mode = Mode.fromProto(proto.getMode());
        this.name = new Name(proto.getName());
        this.description = proto.getDescription();
        this.calendar = proto.hasCalendar() ? Name.parse(proto.getCalendar()) : null;
        this.timeZone = proto.hasTimeZone() ? TimeZone.getTimeZone(proto.getTimeZone()) : TimeZone.getDefault();
        this.actions.clear();
        for (ProtoJob.Job.Action action : proto.getActionsList()) {
            this.actions.add(Action.fromProto(action));
        }
        this.conditions.clear();
        for (ProtoJob.Condition conditionProto : proto.getConditionList()) {
            Condition condition = new Condition().fromProto(conditionProto.toByteArray());
            this.conditions.add(condition);
        }
        this.schedules.clear();
        for (ProtoJob.Schedule scheduleProto : proto.getScheduleList()) {
            Schedule schedule = Schedule.parseFromProto(scheduleProto.toByteArray());
            schedule.setJob(this);
            this.schedules.add(schedule);
        }
        this.properties.clear();
        for (ProtoProperty.Property propertyProto : proto.getPropertyList()) {
            Property property = new Property().fromProto(propertyProto.toByteArray());
            this.setProperty(property);
        }
        try {
            URL uRL = this.output = proto.hasOutput() ? new URL(proto.getOutput()) : null;
            if (this.output != null && !this.output.getProtocol().equals("file")) {
                Localise.logError(logger, "Unsupported output protocol - %s", this.output.getProtocol());
                this.output = null;
            }
        }
        catch (MalformedURLException e) {
            this.output = null;
            Localise.logError(logger, "Could not parse - %1$s - %2$s", proto.getOutput(), e.getMessage());
        }
        this.limitStart = proto.hasLimitStart() ? new Period().fromProto(proto.getLimitStart().toByteArray()) : defaultLimitStart;
        this.limitRun = proto.hasLimitRun() ? new Period().fromProto(proto.getLimitRun().toByteArray()) : defaultLimitRun;
        return this;
    }

    public static Job parseFromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.Job proto = ProtoJob.Job.parseFrom(data);
        Job job = Job.getJob(Type.fromProto(proto.getType()));
        if (job != null) {
            return job.fromProto(data);
        }
        Localise.logError(logger, "Unsupported job received: %s", new Object[]{proto.getType()});
        return null;
    }

    @Override
    public Job duplicate() {
        return (Job)new MessageSerializer().duplicate(this);
    }

    public Job duplicate(Name name) {
        return this.duplicate().setName(name);
    }

    public boolean isDuplicate(Job that) {
        return that != null && this.toJSON(true).toString().equals(that.toJSON(true).toString());
    }

    public static enum Action {
        ALL,
        START,
        STOP,
        KILL,
        PROBE;

        public static EnumMap<Action, ProtoJob.Job.Action> actionMap;

        public static Action fromProto(ProtoJob.Job.Action action) {
            return actionMap.getA(action);
        }

        public ProtoJob.Job.Action toProto() {
            return actionMap.getB(this);
        }

        static {
            actionMap = new EnumMap<Action, ProtoJob.Job.Action>(Action.class, ProtoJob.Job.Action.class);
        }
    }

    public static enum Mode {
        ENABLED("Enabled"),
        BYPASS("Bypass"),
        DISABLED("Disabled");

        private final String label;
        public static final String propertyName = ":job-mode";
        public static EnumMap<Mode, ProtoJob.Job.Mode> modeMap;

        private Mode(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static Mode fromProto(ProtoJob.Job.Mode mode) {
            return modeMap.getA(mode);
        }

        public ProtoJob.Job.Mode toProto() {
            return modeMap.getB(this);
        }

        static {
            modeMap = new EnumMap<Mode, ProtoJob.Job.Mode>(Mode.class, ProtoJob.Job.Mode.class);
        }
    }

    public static enum Type {
        COMMAND(false, Localise.format("Command")),
        CONTAINER(false, Localise.format("Container")),
        CUSTOM(false, Localise.format("Custom")),
        CALENDAR_UPDATE(true, Localise.format("Internal")),
        URL(false, Localise.format("Webhook")),
        MAIL(false, Localise.format("Email")),
        SQL(false, Localise.format("SQL")),
        TRIGGER(false, Localise.format("Trigger"));

        private final boolean internal;
        private final String label;
        private static final EnumMap<Type, ProtoJob.Job.Type> typeMap;

        private Type(boolean internal, String label) {
            this.internal = internal;
            this.label = label;
        }

        public boolean isInternal() {
            return this.internal;
        }

        public String getLabel() {
            return this.label;
        }

        public static Type fromProto(ProtoJob.Job.Type type) {
            return typeMap.getA(type);
        }

        public ProtoJob.Job.Type toProto() {
            return typeMap.getB(this);
        }

        static {
            typeMap = new EnumMap<Type, ProtoJob.Job.Type>(Type.class, ProtoJob.Job.Type.class);
        }
    }
}

