/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.Localise;
import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.JobConfirm;
import com.beyondcron.core.property.PropertyValidator;
import com.hazelcast.core.HazelcastInstance;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class JobConfirmValidator {
    private static Map<String, JobConfirmValidator> validators = new HashMap<String, JobConfirmValidator>();
    private PropertyValidator properties;

    public static synchronized JobConfirmValidator getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        JobConfirmValidator validator = validators.get(name);
        if (validator == null) {
            validator = new JobConfirmValidator(hazelcast);
            validators.put(name, validator);
        }
        return validator;
    }

    protected JobConfirmValidator(HazelcastInstance hazelcast) {
        this.properties = PropertyValidator.getInstance(hazelcast);
    }

    public JobConfirm getJobConfirm(Job job) {
        if (job == null) {
            return new JobConfirm(false, null);
        }
        Property property = job.getProperty(":job-confirm");
        if (property == null) {
            return this.getJobConfirm(job.getName());
        }
        if (property.getType() == Property.Type.UNSET) {
            return new JobConfirm(false, null);
        }
        return new JobConfirm("enabled".equals(property.getValue()), null);
    }

    public JobConfirm getJobConfirm(Name name) {
        Stack<Property> props = new Stack<Property>();
        props.addAll(this.properties.getProperties(name, ":job-confirm"));
        while (!props.isEmpty()) {
            Property prop = (Property)props.pop();
            if (prop.getType() == Property.Type.UNSET) continue;
            return new JobConfirm("enabled".equals(prop.getValue()), prop.getGroup());
        }
        return new JobConfirm(false, null);
    }

    public String getJobConfirmMessage(Name name) {
        JobConfirm confirm = this.getJobConfirm(name);
        Name group = confirm.getGroup();
        String message = group != null ? Localise.format("Effective confirm is <b>%1$s</b>, set at <b>%2$s</b>", confirm.isConfirm() ? "enabled" : "disabled", group.toString()) : Localise.format("Effective confirm is <b>disabled</b>, the BeyondCron default");
        return message;
    }
}

