/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.property.PropertyValidator;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoJob;
import com.google.protobuf.InvalidProtocolBufferException;

public class JobMode
implements Message<JobMode> {
    private static final String MESSAGE_TAG = "jobMode";
    private Name group = null;
    private Job.Mode mode;

    public JobMode() {
    }

    public JobMode(Name name, Job.Mode mode, PropertyValidator properties) {
        Job.Mode mode2 = this.mode = mode != null ? mode : Job.Mode.ENABLED;
        if (this.mode != Job.Mode.DISABLED) {
            for (Property property : properties.getProperties(name, ":job-mode")) {
                this.setProperty(property);
            }
        }
    }

    public Name getGroup() {
        return this.group;
    }

    public Job.Mode getMode() {
        return this.mode;
    }

    public void setProperty(Property property) {
        try {
            Name g = property.getGroup();
            Job.Mode m = Job.Mode.valueOf(property.getValue().toUpperCase());
            int i = m.compareTo(this.mode);
            if (i > 0) {
                this.mode = m;
                this.group = g;
            }
        }
        catch (IllegalArgumentException e) {
            return;
        }
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoJob.JobMode.Builder toProto() {
        ProtoJob.JobMode.Builder builder = ProtoJob.JobMode.newBuilder();
        builder.setMode(this.mode.toProto());
        if (this.group != null) {
            builder.setGroup(this.group.toProto());
        }
        return builder;
    }

    @Override
    public JobMode fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoJob.JobMode proto = ProtoJob.JobMode.parseFrom(data);
        this.mode = Job.Mode.fromProto(proto.getMode());
        this.group = proto.hasGroup() ? new Name(proto.getGroup()) : null;
        return this;
    }
}

