/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core.job;

import com.beyondcron.core.Name;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.JobMode;
import com.beyondcron.core.property.PropertyValidator;
import com.beyondcron.messaging.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ITopic;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.Predicate;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class JobModeValidator {
    private static Map<String, JobModeValidator> validators = new HashMap<String, JobModeValidator>();
    private IMap<Name, Job> jobs;
    private IMap<Name, JobMode> jobModes;
    private ITopic<Name> jobModeUpdates;
    private PropertyValidator properties;
    private Set<JobModeListener> jobModeListeners = new HashSet<JobModeListener>();

    public static synchronized JobModeValidator getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        JobModeValidator validator = validators.get(name);
        if (validator == null) {
            validator = new JobModeValidator(hazelcast);
            validators.put(name, validator);
        }
        return validator;
    }

    protected JobModeValidator(HazelcastInstance hazelcast) {
        this.jobs = Hazelcast.getJobMap(hazelcast);
        this.jobModes = Hazelcast.getJobModeMap(hazelcast);
        this.properties = PropertyValidator.getInstance(hazelcast);
        this.jobModeUpdates = Hazelcast.getJobModeUpdateTopic(hazelcast);
        this.jobModeUpdates.addMessageListener(message -> this.notifyListeners((Name)message.getMessageObject()));
    }

    public JobMode getMode(Name name) {
        JobMode mode = (JobMode)this.jobModes.get((Object)name);
        if (mode == null) {
            Job job = (Job)this.jobs.get((Object)name);
            mode = new JobMode(name, job != null ? job.getMode() : null, this.properties);
            this.jobModes.put((Object)name, (Object)mode);
        }
        return mode;
    }

    public JobMode getMode(Job job) {
        Name name = job.getName();
        JobMode mode = (JobMode)this.jobModes.get((Object)name);
        if (mode == null) {
            mode = new JobMode(name, job.getMode(), this.properties);
            this.jobModes.put((Object)name, (Object)mode);
        }
        return mode;
    }

    protected void setMode(Name name, Job.Mode mode) {
        this.jobModes.put((Object)name, (Object)new JobMode(name, mode, this.properties));
    }

    public void flushJob(Name name) {
        if (this.jobModes.remove((Object)name) != null) {
            this.jobModeUpdates.publish((Object)name);
        }
    }

    public void flushGroup(Name group) {
        int i = this.jobModes.size();
        this.jobModes.removeAll((Predicate)new ContainsPredicate(group));
        if (this.jobModes.size() - 1 != 0) {
            this.jobModeUpdates.publish((Object)group);
        }
    }

    public JobModeValidator addActionListener(JobModeListener listener) {
        this.jobModeListeners.add(listener);
        return this;
    }

    public JobModeValidator removeActionListener(JobModeListener listener) {
        this.jobModeListeners.remove(listener);
        return this;
    }

    private void notifyListeners(Name name) {
        for (JobModeListener listener : new CopyOnWriteArraySet<JobModeListener>(this.jobModeListeners)) {
            listener.jobModeUpdated(name);
        }
    }

    public static class ContainsPredicate
    implements Predicate<Name, JobMode>,
    DataSerializable {
        private Name group;

        private ContainsPredicate() {
        }

        public ContainsPredicate(Name group) {
            this.group = group;
        }

        public boolean apply(Map.Entry<Name, JobMode> entry) {
            return this.group.contains(entry.getKey());
        }

        public boolean apply(Name name) {
            return this.group.contains(name);
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeByteArray(this.group.toProto().build().toByteArray());
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.group = new Name().fromProto(in.readByteArray());
        }
    }

    public static interface JobModeListener {
        public void jobModeUpdated(Name var1);
    }
}

